/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.opentracing;

import fish.payara.nucleus.requesttracing.RequestTracingService;
import fish.payara.opentracing.ScopeManager;
import fish.payara.opentracing.tracer.Tracer;
import io.opentracing.mock.MockTracer;
import io.opentracing.util.ThreadLocalScopeManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.interceptor.InvocationContext;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Service;

@Service(name="opentracing-service")
public class OpenTracingService
implements EventListener {
    private static final Map<String, io.opentracing.Tracer> tracers = new ConcurrentHashMap<String, io.opentracing.Tracer>();
    private static final ScopeManager scopeManager = new ScopeManager();
    public static final String PAYARA_CORBA_RMI_TRACER_NAME = "__PAYARA_CORBA_RMI";
    private static final Logger logger = Logger.getLogger(OpenTracingService.class.getName());

    @PostConstruct
    void postConstruct() {
        Events events = this.getFromServiceHandle(Globals.getDefaultBaseServiceLocator(), Events.class);
        if (events != null) {
            events.register((EventListener)this);
        } else {
            logger.log(Level.WARNING, "OpenTracing service not registered to Payara Events: The Tracer for an application won't be removed upon undeployment");
        }
    }

    public void event(EventListener.Event<?> event) {
        if (event.is(Deployment.APPLICATION_UNLOADED)) {
            ApplicationInfo info = (ApplicationInfo)event.hook();
            tracers.remove(info.getName());
        }
    }

    public synchronized io.opentracing.Tracer getTracer(String applicationName) {
        if (applicationName == null) {
            return null;
        }
        io.opentracing.Tracer tracer = tracers.get(applicationName);
        if (tracer == null) {
            try {
                ServiceLoader<io.opentracing.Tracer> tracerLoader = ServiceLoader.load(io.opentracing.Tracer.class);
                Iterator<io.opentracing.Tracer> loadedTracer = tracerLoader.iterator();
                if (loadedTracer.hasNext()) {
                    tracer = loadedTracer.next();
                }
            }
            catch (NoClassDefFoundError ex) {
                logger.log(Level.SEVERE, "Unable to find Tracer implementation", ex);
            }
            if (Boolean.getBoolean("USE_OPENTRACING_MOCK_TRACER")) {
                tracer = new MockTracer((io.opentracing.ScopeManager)new ThreadLocalScopeManager(), MockTracer.Propagator.TEXT_MAP);
            } else if (tracer == null) {
                tracer = new Tracer(applicationName, scopeManager);
            }
            tracers.put(applicationName, tracer);
        }
        return tracer;
    }

    public boolean isEnabled() {
        RequestTracingService requestTracingService = this.getFromServiceHandle(Globals.getDefaultBaseServiceLocator(), RequestTracingService.class);
        if (requestTracingService != null) {
            return requestTracingService.isRequestTracingEnabled();
        }
        return false;
    }

    public String getApplicationName(InvocationManager invocationManager) {
        ApplicationRegistry applicationRegistry;
        ComponentInvocation invocation = invocationManager.getCurrentInvocation();
        if (invocation == null) {
            return null;
        }
        String appName = invocation.getAppName();
        if (appName == null && (appName = invocation.getModuleName()) == null && (appName = invocation.getComponentId()) != null && (applicationRegistry = (ApplicationRegistry)Globals.getDefaultBaseServiceLocator().getService(ApplicationRegistry.class, new Annotation[0])).get(appName) == null) {
            String[] componentIds = appName.split("_/");
            appName = componentIds[0];
        }
        return appName;
    }

    public String getApplicationName(InvocationManager invocationManager, InvocationContext invocationContext) {
        String appName = invocationManager.getCurrentInvocation().getAppName();
        if (appName == null && (appName = invocationManager.getCurrentInvocation().getModuleName()) == null && (appName = invocationManager.getCurrentInvocation().getComponentId()) == null && invocationContext != null) {
            appName = this.getFullMethodSignature(invocationContext.getMethod());
        }
        return appName;
    }

    private String getFullMethodSignature(Method annotatedMethod) {
        return annotatedMethod.getDeclaringClass().getCanonicalName() + "#" + annotatedMethod.getName() + "(" + Arrays.toString(annotatedMethod.getParameterTypes()) + ")>" + annotatedMethod.getReturnType().getSimpleName();
    }

    private <T> T getFromServiceHandle(ServiceLocator serviceLocator, Class<T> serviceClass) {
        ServiceHandle serviceHandle;
        if (serviceLocator != null && (serviceHandle = serviceLocator.getServiceHandle(serviceClass, new Annotation[0])) != null && serviceHandle.isActive()) {
            return (T)serviceHandle.getService();
        }
        return null;
    }
}

