/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.grizzly.config.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.NetworkListeners;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.glassfish.internal.config.UnprocessedConfigListener;
import org.glassfish.web.admin.LogFacade;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.UnprocessedChangeEvent;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG, CommandTarget.DEPLOYMENT_GROUP})
@Service(name="set-network-listener-configuration")
@CommandLock(value=CommandLock.LockType.NONE)
@PerLookup
@I18n(value="set-network-listener-configuration")
@RestEndpoints(value={@RestEndpoint(configBean=NetworkListener.class, opType=RestEndpoint.OpType.POST, description="Configures a network listener")})
public class SetNetworkListenerConfiguration
implements AdminCommand,
EventListener {
    private static final Logger LOGGER = LogFacade.getLogger();
    private static final String ADMIN_LISTENER = "admin-listener";
    private static final ResourceBundle rb = LogFacade.getLogger().getResourceBundle();
    @Param(name="enabled", optional=true)
    private Boolean enabled;
    @Param(name="dynamic", optional=true)
    private Boolean dynamic;
    @Param(name="address", optional=true)
    private String address;
    @Param(name="listenerport", optional=false, alias="Port")
    private Integer port;
    @Param(name="listenerPortRange", alias="listenerportrange", optional=true)
    private String portRange;
    @Param(name="threadpool", optional=true, alias="threadPool")
    private String threadPool;
    @Param(name="protocol", optional=true)
    private String protocol;
    @Param(name="name", primary=true)
    private String listenerName;
    @Param(name="transport", optional=true)
    private String transport;
    @Param(name="jkenabled", optional=true, alias="jkEnabled")
    private Boolean jkEnabled;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    Target targetUtil;
    @Inject
    NetworkConfig confign;
    @Inject
    UnprocessedConfigListener ucl;
    @Inject
    Events events;

    @PostConstruct
    public void postConstuct() {
        this.events.register((EventListener)this);
    }

    public void event(EventListener.Event event) {
        if (event.is(EventTypes.SERVER_SHUTDOWN)) {
            this.shutdownChange();
        }
    }

    public void execute(AdminCommandContext context) {
        final ActionReport actionReport = context.getActionReport();
        Config newConfig = this.targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        NetworkListener listener = this.config.getNetworkConfig().getNetworkListener(this.listenerName);
        if (!this.validate(actionReport)) {
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkListener>(){

                public Object run(NetworkListener listenerProxy) throws PropertyVetoException, TransactionFailure {
                    if (SetNetworkListenerConfiguration.this.enabled != null) {
                        listenerProxy.setEnabled(SetNetworkListenerConfiguration.this.enabled.toString());
                    }
                    if (SetNetworkListenerConfiguration.this.address != null) {
                        listenerProxy.setAddress(SetNetworkListenerConfiguration.this.address);
                    }
                    if (SetNetworkListenerConfiguration.this.port != null && !SetNetworkListenerConfiguration.ADMIN_LISTENER.equals(SetNetworkListenerConfiguration.this.listenerName)) {
                        listenerProxy.setPort(SetNetworkListenerConfiguration.this.port.toString());
                    }
                    if (SetNetworkListenerConfiguration.this.portRange != null) {
                        listenerProxy.setPortRange(SetNetworkListenerConfiguration.this.portRange);
                    }
                    if (SetNetworkListenerConfiguration.this.protocol != null) {
                        listenerProxy.setProtocol(SetNetworkListenerConfiguration.this.protocol);
                    }
                    if (SetNetworkListenerConfiguration.this.threadPool != null) {
                        listenerProxy.setThreadPool(SetNetworkListenerConfiguration.this.threadPool);
                    }
                    if (SetNetworkListenerConfiguration.this.transport != null) {
                        listenerProxy.setTransport(SetNetworkListenerConfiguration.this.transport);
                    }
                    if (SetNetworkListenerConfiguration.this.jkEnabled != null) {
                        listenerProxy.setJkEnabled(SetNetworkListenerConfiguration.this.jkEnabled.toString());
                    }
                    actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                    return null;
                }
            }, (ConfigBeanProxy)listener);
            String oldPort = listener.getPort();
            if (this.port != null && ADMIN_LISTENER.equals(this.listenerName)) {
                UnprocessedChangeEvent unprocessed = new UnprocessedChangeEvent(new PropertyChangeEvent(this, "port", oldPort, this.port), listener.getName() + " port changed from " + oldPort + " to " + this.port);
                LOGGER.log(Level.INFO, MessageFormat.format(rb.getString("AS-WEB-ADMIN-00051"), this.listenerName, oldPort, this.port));
                actionReport.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00051"), this.listenerName, oldPort, this.port.toString()));
                ArrayList<UnprocessedChangeEvents> unprocessedList = new ArrayList<UnprocessedChangeEvents>();
                unprocessedList.add(new UnprocessedChangeEvents(unprocessed));
                this.ucl.unprocessedTransactedEvents(unprocessedList);
            }
        }
        catch (TransactionFailure e) {
            LOGGER.log(Level.SEVERE, null, e);
            actionReport.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00012"), this.listenerName) + (e.getMessage() == null ? "No reason given" : e.getMessage()));
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            actionReport.setFailureCause((Throwable)e);
            return;
        }
        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private boolean validate(ActionReport report) {
        NetworkListener listener = this.config.getNetworkConfig().getNetworkListener(this.listenerName);
        if (listener == null) {
            report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00030"), this.listenerName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        if (this.port < 1 || this.port > 65535) {
            report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00050"), this.port));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownChange() {
        ArrayList<UnprocessedChangeEvent> processed = new ArrayList<UnprocessedChangeEvent>();
        for (UnprocessedChangeEvents unchangedEvents : this.ucl.getUnprocessedChangeEvents()) {
            for (UnprocessedChangeEvent unprocessedEvent : unchangedEvents.getUnprocessed()) {
                final PropertyChangeEvent event = unprocessedEvent.getEvent();
                if (!event.getSource().getClass().equals(this.getClass()) || !event.getPropertyName().equals("port")) continue;
                SetNetworkListenerConfiguration oldConfig = (SetNetworkListenerConfiguration)event.getSource();
                NetworkListeners listeners = oldConfig.confign.getNetworkListeners();
                for (NetworkListener listener : listeners.getNetworkListener()) {
                    if (!listener.getName().equals(oldConfig.listenerName)) continue;
                    try {
                        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkListener>(){

                            public Object run(NetworkListener listenerProxy) throws PropertyVetoException, TransactionFailure {
                                listenerProxy.setPort(event.getNewValue().toString());
                                return null;
                            }
                        }, (ConfigBeanProxy)listener);
                    }
                    catch (TransactionFailure ex) {
                        Logger.getLogger(SetNetworkListenerConfiguration.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    finally {
                        processed.add(unprocessedEvent);
                    }
                }
            }
        }
    }
}

