/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jaspic;

import com.sun.enterprise.config.serverbeans.MessageSecurityConfig;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.jaspic.config.GFServerConfigProvider;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
@RunLevel(value=10)
public class MessageSecurityConfigEventListenerImpl
implements ConfigListener {
    private static Logger logger = LogDomains.getLogger(MessageSecurityConfigEventListenerImpl.class, (String)"javax.enterprise.system.core.security", (boolean)false);
    @Inject
    @Named(value="default-instance-name")
    private SecurityService service;

    public <T extends ConfigBeanProxy> NotProcessed handleUpdate(T instance) {
        NotProcessed notProcessed = null;
        logger.fine("MessageSecurityConfigEventListenerImpl - handleUpdate called");
        if (instance instanceof MessageSecurityConfig) {
            GFServerConfigProvider.loadConfigContext(this.service);
        } else {
            notProcessed = new NotProcessed("unimplemented: unknown instance: " + instance.getClass().getName());
        }
        return notProcessed;
    }

    public <T extends ConfigBeanProxy> NotProcessed handleDelete(T instance) {
        NotProcessed notProcessed = null;
        logger.fine("MessageSecurityConfigEventListenerImpl - handleDelete called");
        if (instance instanceof MessageSecurityConfig) {
            GFServerConfigProvider.loadConfigContext(this.service);
        } else {
            notProcessed = new NotProcessed("unimplemented: unknown instance: " + instance.getClass().getName());
        }
        return notProcessed;
    }

    public <T extends ConfigBeanProxy> NotProcessed handleCreate(T instance) {
        NotProcessed notProcessed = null;
        logger.fine("MessageSecurityConfigEventListenerImpl - handleCreate called");
        if (instance instanceof MessageSecurityConfig) {
            GFServerConfigProvider.loadConfigContext(this.service);
        } else {
            notProcessed = new NotProcessed("unimplemented: unknown instance: " + instance.getClass().getName());
        }
        return notProcessed;
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)new Changed(){

            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> changedType, T changedInstance) {
                NotProcessed notProcessed = null;
                switch (type) {
                    case ADD: {
                        logger.fine("A new " + changedType.getName() + " was added :  " + changedInstance);
                        notProcessed = MessageSecurityConfigEventListenerImpl.this.handleCreate(changedInstance);
                        break;
                    }
                    case CHANGE: {
                        logger.fine("A " + changedType.getName() + " was changed : " + changedInstance);
                        notProcessed = MessageSecurityConfigEventListenerImpl.this.handleUpdate(changedInstance);
                        break;
                    }
                    case REMOVE: {
                        logger.fine("A " + changedType.getName() + " was removed : " + changedInstance);
                        notProcessed = MessageSecurityConfigEventListenerImpl.this.handleDelete(changedInstance);
                    }
                }
                return notProcessed;
            }
        }, (Logger)logger);
        return null;
    }
}

