/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util.pool;

import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.util.pool.ObjectFactory;
import com.sun.ejb.containers.util.pool.Pool;
import com.sun.ejb.containers.util.pool.PoolException;
import com.sun.ejb.monitoring.probes.EjbPoolProbeProvider;
import com.sun.ejb.monitoring.stats.EjbMonitoringUtils;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.flashlight.provider.ProbeProviderFactory;

public abstract class AbstractPool
implements Pool {
    protected static final Logger _logger = EjbContainerUtilImpl.getLogger();
    protected final ArrayList<Object> list = new ArrayList();
    protected ObjectFactory factory = null;
    protected int waitCount = 0;
    protected int createdCount = 0;
    protected int steadyPoolSize;
    protected int resizeQuantity = 1;
    protected int maxPoolSize = Integer.MAX_VALUE;
    protected long maxWaitTimeInMillis;
    protected int idleTimeoutInSeconds;
    protected ClassLoader containerClassLoader;
    protected int destroyedCount = 0;
    protected int poolSuccess = 0;
    protected String poolName;
    protected int poolReturned = 0;
    protected String configData;
    protected EjbPoolProbeProvider poolProbeNotifier;
    protected String appName;
    protected String modName;
    protected String ejbName;
    protected long beanId;

    public void setContainerClassLoader(ClassLoader loader) {
        this.containerClassLoader = loader;
    }

    public void setInfo(String appName, String modName, String ejbName) {
        block3: {
            this.appName = appName;
            this.modName = modName;
            this.ejbName = ejbName;
            try {
                ProbeProviderFactory probeFactory = EjbContainerUtilImpl.getInstance().getProbeProviderFactory();
                String invokerId = EjbMonitoringUtils.getInvokerId(appName, modName, ejbName);
                this.poolProbeNotifier = (EjbPoolProbeProvider)probeFactory.getProbeProvider(EjbPoolProbeProvider.class, invokerId);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Got poolProbeNotifier: {0}", this.poolProbeNotifier.getClass().getName());
                }
            }
            catch (IllegalAccessException | InstantiationException ex) {
                this.poolProbeNotifier = new EjbPoolProbeProvider();
                if (!_logger.isLoggable(Level.FINE)) break block3;
                _logger.log(Level.FINE, "Error getting the EjbPoolProbeProvider");
            }
        }
    }

    @Override
    public Object getObject(boolean canWait, Object param) throws PoolException {
        return this.getObject(param);
    }

    @Override
    public Object getObject(long maxWaitTime, Object param) throws PoolException {
        return this.getObject(param);
    }

    protected abstract void removeIdleObjects();

    public abstract void close();

    public int getCreatedCount() {
        return this.createdCount;
    }

    public int getDestroyedCount() {
        return this.destroyedCount;
    }

    public int getPoolSuccess() {
        return this.poolSuccess;
    }

    public int getSize() {
        return this.list.size();
    }

    public int getWaitCount() {
        return this.waitCount;
    }

    public int getSteadyPoolSize() {
        return this.steadyPoolSize;
    }

    public int getResizeQuantity() {
        return this.resizeQuantity;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public long getMaxWaitTimeInMillis() {
        return this.maxWaitTimeInMillis;
    }

    public int getIdleTimeoutInSeconds() {
        return this.idleTimeoutInSeconds;
    }

    public void setConfigData(String configData) {
        this.configData = configData;
    }

    public void appendStats(StringBuilder sbuf) {
        sbuf.append("[Pool: ").append("SZ=").append(this.list.size()).append("; ").append("CC=").append(this.createdCount).append("; ").append("DC=").append(this.destroyedCount).append("; ").append("WC=").append(this.waitCount).append("; ").append("MSG=0");
        if (this.configData != null) {
            sbuf.append(this.configData);
        }
        sbuf.append("]");
    }

    public int getJmsMaxMessagesLoad() {
        return 0;
    }

    public int getNumBeansInPool() {
        return this.list.size();
    }

    public int getNumThreadsWaiting() {
        return this.waitCount;
    }

    public int getTotalBeansCreated() {
        return this.createdCount;
    }

    public int getTotalBeansDestroyed() {
        return this.destroyedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAllMonitoredAttrbuteValues() {
        StringBuilder sbuf = new StringBuilder();
        ArrayList<Object> arrayList = this.list;
        synchronized (arrayList) {
            sbuf.append("createdCount=").append(this.createdCount).append(";").append("destroyedCount=").append(this.destroyedCount).append(";").append("waitCount=").append(this.waitCount).append(";").append("size=").append(this.list.size()).append(";");
        }
        sbuf.append("maxPoolSize=").append(this.maxPoolSize).append(";");
        return sbuf.toString();
    }

    public String getAllAttrValues() {
        StringBuilder sbuf = new StringBuilder();
        if (null != this.poolName) {
            sbuf.append(":").append(this.poolName);
        } else {
            sbuf.append(":POOL");
        }
        sbuf.append("[FP=").append(this.poolSuccess).append(",").append("TC=").append(this.createdCount).append(",").append("TD=").append(this.destroyedCount).append(",").append("PR=").append(this.poolReturned).append(",").append("TW=").append(this.waitCount).append(",").append("CS=").append(this.list.size()).append(",").append("MS=").append(this.maxPoolSize);
        return sbuf.toString();
    }

    protected void unregisterProbeProvider() {
        block2: {
            try {
                ProbeProviderFactory probeFactory = EjbContainerUtilImpl.getInstance().getProbeProviderFactory();
                probeFactory.unregisterProbeProvider((Object)this.poolProbeNotifier);
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.FINE)) break block2;
                _logger.log(Level.FINE, "Error getting the EjbPoolProbeProvider");
            }
        }
    }
}

