/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.corba;

import java.applet.Applet;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.ConfigurationException;
import javax.rmi.CORBA.Stub;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class CorbaUtils {
    public static Object remoteToCorba(Remote remoteObj, ORB orb) throws ConfigurationException {
        Remote stub;
        try {
            stub = PortableRemoteObject.toStub((Remote)remoteObj);
        }
        catch (Throwable t) {
            ConfigurationException ce = new ConfigurationException("Problem with PortableRemoteObject.toStub(); object not exported or stub not found");
            ce.setRootCause(t);
            throw ce;
        }
        if (!(stub instanceof Stub)) {
            return null;
        }
        try {
            ((Stub)stub).connect(orb);
        }
        catch (RemoteException t) {
        }
        catch (Throwable t) {
            ConfigurationException ce = new ConfigurationException("Problem invoking javax.rmi.CORBA.Stub.connect()");
            ce.setRootCause(t);
            throw ce;
        }
        return (Object)stub;
    }

    public static ORB getOrb(String server, int port, Hashtable<?, ?> env) {
        Applet applet;
        Properties orbProp;
        if (env != null) {
            if (env instanceof Properties) {
                orbProp = (Properties)env.clone();
            } else {
                orbProp = new Properties();
                Enumeration<?> envProp = env.keys();
                while (envProp.hasMoreElements()) {
                    String key = (String)envProp.nextElement();
                    java.lang.Object val = env.get(key);
                    if (!(val instanceof String)) continue;
                    orbProp.put(key, val);
                }
            }
        } else {
            orbProp = new Properties();
        }
        if (server != null) {
            orbProp.put("org.omg.CORBA.ORBInitialHost", server);
        }
        if (port >= 0) {
            orbProp.put("org.omg.CORBA.ORBInitialPort", "" + port);
        }
        if (env != null && (applet = (Applet)env.get("java.naming.applet")) != null) {
            return ORB.init((Applet)applet, (Properties)orbProp);
        }
        return ORB.init((String[])new String[0], (Properties)orbProp);
    }

    public static final String decode(String s) throws MalformedURLException {
        try {
            return CorbaUtils.decode(s, "8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new MalformedURLException("ISO-Latin-1 decoder unavailable");
        }
    }

    public static final String decode(String s, String enc) throws MalformedURLException, UnsupportedEncodingException {
        try {
            return URLDecoder.decode(s, enc);
        }
        catch (IllegalArgumentException iae) {
            MalformedURLException mue = new MalformedURLException("Invalid URI encoding: " + s);
            mue.initCause(iae);
            throw mue;
        }
    }
}

