/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.enterprise.server.logging;

import com.sun.enterprise.server.logging.LogRotationTimerTask;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ScheduledFuture;

public class PayaraNotificationLogRotationTimer {
    private LogRotationTimerTask rotationTimerTask;
    private ScheduledFuture<?> logRotationFuture;
    private Timer rotationTimer = new Timer("payara-log-rotation-timer");
    private static PayaraNotificationLogRotationTimer instance = new PayaraNotificationLogRotationTimer();

    private PayaraNotificationLogRotationTimer() {
    }

    public static PayaraNotificationLogRotationTimer getInstance() {
        return instance;
    }

    public void startTimer(LogRotationTimerTask timerTask) {
        this.rotationTimerTask = timerTask;
        this.rotationTimer.schedule((TimerTask)this.rotationTimerTask, timerTask.getRotationTimerValue());
    }

    public void stopTimer() {
        this.rotationTimer.cancel();
    }

    public void restartTimer() {
        if (this.rotationTimerTask != null) {
            this.rotationTimerTask.cancel();
            this.rotationTimerTask = new LogRotationTimerTask(this.rotationTimerTask.task, this.rotationTimerTask.getRotationTimerValueInMinutes());
            this.rotationTimer.schedule((TimerTask)this.rotationTimerTask, this.rotationTimerTask.getRotationTimerValue());
        }
    }

    public void restartTimerForDayBasedRotation() {
        if (this.rotationTimerTask != null) {
            this.rotationTimerTask.cancel();
            this.rotationTimerTask = new LogRotationTimerTask(this.rotationTimerTask.task, 1440L);
            this.rotationTimer.schedule((TimerTask)this.rotationTimerTask, 86400000L);
        }
    }
}

