/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.jwtauth.jaxrs;

import fish.payara.microprofile.jwtauth.jaxrs.DenyAllRequestFilter;
import fish.payara.microprofile.jwtauth.jaxrs.RolesAllowedRequestFilter;
import java.lang.reflect.Method;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;

@Provider
public class RolesAllowedDynamicFeature
implements DynamicFeature {
    @Context
    private HttpServletRequest request;
    @Context
    private HttpServletResponse response;

    public void configure(ResourceInfo resourceInfo, FeatureContext configuration) {
        Method resourceMethod = resourceInfo.getResourceMethod();
        if (resourceMethod.isAnnotationPresent(DenyAll.class)) {
            configuration.register((Object)new DenyAllRequestFilter());
            return;
        }
        if (resourceMethod.isAnnotationPresent(PermitAll.class)) {
            configuration.register((Object)new RolesAllowedRequestFilter(this.request, this.response));
            return;
        }
        RolesAllowed rolesAllowed = resourceMethod.getAnnotation(RolesAllowed.class);
        if (rolesAllowed != null) {
            configuration.register((Object)new RolesAllowedRequestFilter(this.request, this.response, rolesAllowed.value()));
            return;
        }
        rolesAllowed = resourceInfo.getResourceClass().getAnnotation(RolesAllowed.class);
        if (rolesAllowed != null) {
            configuration.register((Object)new RolesAllowedRequestFilter(this.request, this.response, rolesAllowed.value()));
        }
    }
}

