/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.LogFacade;
import com.sun.enterprise.glassfish.bootstrap.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JarUtil {
    public static final String JAXR_RA_NAME = "jaxr-ra";
    public static final String JDBCDATASOURCE_RA_NAME = "__ds_jdbc_ra";
    public static final String JDBCCONNECTIONPOOLDATASOURCE_RA_NAME = "__cp_jdbc_ra";
    public static final String JDBCXA_RA_NAME = "__xa_jdbc_ra";
    public static final String JDBCDRIVER_RA_NAME = "__dm_jdbc_ra";
    public static final String DEFAULT_JMS_ADAPTER = "jmsra";
    public static final String RAR_EXTENSION = ".rar";
    public static final List<String> systemRarNames = Collections.unmodifiableList(Arrays.asList("jaxr-ra", "__ds_jdbc_ra", "__cp_jdbc_ra", "__xa_jdbc_ra", "__dm_jdbc_ra", "jmsra"));
    private static final Logger logger = LogFacade.BOOTSTRAP_LOGGER;

    private static String getSystemModuleLocation(String installDir, String rarName) {
        return installDir + File.separator + "lib" + File.separator + "install" + File.separator + "applications" + File.separator + rarName;
    }

    private static boolean systemModuleLocationExists(String installDir, String rarName) {
        return new File(JarUtil.getSystemModuleLocation(installDir, rarName)).exists();
    }

    public static boolean extractRars(String installDir) {
        boolean extracted = true;
        for (String rarName : systemRarNames) {
            extracted &= JarUtil.extractRar(installDir, rarName);
        }
        return extracted;
    }

    public static void setEnv(String installDir) {
        String imqLib = System.getProperty("com.sun.aas.imqLib", JarUtil.getSystemModuleLocation(installDir, DEFAULT_JMS_ADAPTER));
        System.setProperty("com.sun.aas.imqLib", imqLib);
    }

    public static boolean extractRar(String installDir, String rarName) {
        if (JarUtil.systemModuleLocationExists(installDir, rarName)) {
            return false;
        }
        InputStream is = JarUtil.class.getClassLoader().getResourceAsStream(rarName + RAR_EXTENSION);
        if (is != null) {
            String fileName = installDir + File.separator + rarName + RAR_EXTENSION;
            try (InputStream inputStream = is;
                 FileOutputStream outputStream = new FileOutputStream(fileName);){
                Util.copy(inputStream, outputStream, inputStream.available());
            }
            catch (IOException e) {
                LogFacade.log(logger, Level.WARNING, "NCLS-BOOTSTRAP-00003", e, rarName);
                return false;
            }
            File file = new File(fileName);
            if (file.exists()) {
                try {
                    JarUtil.extractJar(file, installDir);
                    file.delete();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            }
            logger.log(Level.INFO, "NCLS-BOOTSTRAP-00004", new Object[]{rarName, fileName});
            return false;
        }
        logger.log(Level.FINEST, "could not find RAR [ " + rarName + " ] in the archive, skipping .rar extraction");
        return false;
    }

    public static void extractJar(File jarFile, String destDir) throws IOException {
        try (JarFile jar = new JarFile(jarFile);){
            Enumeration<JarEntry> enum1 = jar.entries();
            while (enum1.hasMoreElements()) {
                JarEntry file = enum1.nextElement();
                File f = new File(destDir + File.separator + file.getName());
                if (file.isDirectory()) {
                    f.mkdir();
                    continue;
                }
                if (f.exists()) continue;
                InputStream is = jar.getInputStream(file);
                Throwable throwable = null;
                try {
                    FileOutputStream fos = new FileOutputStream(f);
                    Throwable throwable2 = null;
                    try {
                        int count = 0;
                        byte[] buffer = new byte[8192];
                        while ((count = is.read(buffer, 0, buffer.length)) != -1) {
                            fos.write(buffer, 0, count);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (fos == null) continue;
                        if (throwable2 != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        fos.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
    }
}

