/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.jar.JarFile;

public class NonCachedJarStreamHandler
extends URLStreamHandler {
    private static final NonCachedJarStreamHandler INSTANCE = new NonCachedJarStreamHandler();

    public static URL forceNonCachedJarURL(URL url) {
        if (url == null) {
            return null;
        }
        if (!"jar".equals(url.getProtocol())) {
            return url;
        }
        try {
            return AccessController.doPrivileged(() -> new URL(url, url.toExternalForm(), INSTANCE));
        }
        catch (PrivilegedActionException ex) {
            throw new IllegalArgumentException(ex.getException());
        }
    }

    @Override
    protected URLConnection openConnection(final URL u) throws IOException {
        return new JarURLConnection(u){
            private JarURLConnection urlConnection;

            @Override
            public JarFile getJarFile() throws IOException {
                this.connect();
                return this.urlConnection.getJarFile();
            }

            @Override
            public void connect() throws IOException {
                if (this.urlConnection == null) {
                    this.setUseCaches(false);
                    URLConnection conn = new URL(u.toExternalForm()).openConnection();
                    conn.setUseCaches(false);
                    this.urlConnection = (JarURLConnection)conn;
                }
            }

            @Override
            public InputStream getInputStream() throws IOException {
                this.connect();
                return this.urlConnection.getInputStream();
            }
        };
    }
}

