/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.deployment.AdministeredObjectDefinitionDescriptor;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.connectors.config.AdminObjectResource;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.util.ResourceManagerFactory;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
@ResourceDeployerInfo(value=AdministeredObjectDefinitionDescriptor.class)
public class AdministeredObjectDefinitionDeployer
implements ResourceDeployer {
    @Inject
    private Provider<ResourceManagerFactory> resourceManagerFactoryProvider;
    private static Logger _logger = LogDomains.getLogger(AdministeredObjectDefinitionDeployer.class, (String)"javax.enterprise.resource.resourceadapter");
    static final String PROPERTY_PREFIX = "org.glassfish.admin-object.";

    public void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
    }

    public void deployResource(Object resource) throws Exception {
        AdministeredObjectDefinitionDescriptor desc = (AdministeredObjectDefinitionDescriptor)resource;
        String resourceName = ConnectorsUtil.deriveResourceName((String)desc.getResourceId(), (String)desc.getName(), (JavaEEResourceType)desc.getResourceType());
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "AdministeredObjectDefinitionDeployer.deployResource() : resource-name [" + resourceName + "]");
        }
        MyAdministeredObjectResource adminObjectResource = new MyAdministeredObjectResource(desc, resourceName);
        this.getDeployer(adminObjectResource).deployResource((Object)adminObjectResource);
    }

    public boolean canDeploy(boolean postApplicationDeployment, Collection<Resource> allResources, Resource resource) {
        return this.handles(resource) && !postApplicationDeployment;
    }

    public void validatePreservedResource(Application oldApp, Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }

    private ResourceDeployer getDeployer(Object resource) {
        return ((ResourceManagerFactory)this.resourceManagerFactoryProvider.get()).getResourceDeployer(resource);
    }

    private AdministeredObjectProperty convertProperty(String name, String value) {
        return new AdministeredObjectProperty(name, value);
    }

    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
    }

    public void undeployResource(Object resource) throws Exception {
        AdministeredObjectDefinitionDescriptor desc = (AdministeredObjectDefinitionDescriptor)resource;
        String resourceName = ConnectorsUtil.deriveResourceName((String)desc.getResourceId(), (String)desc.getName(), (JavaEEResourceType)desc.getResourceType());
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "AdministeredObjectDefinitionDeployer.undeployResource() : resource-name [" + resourceName + "]");
        }
        MyAdministeredObjectResource adminObjectResource = new MyAdministeredObjectResource(desc, resourceName);
        this.getDeployer(adminObjectResource).undeployResource((Object)adminObjectResource);
    }

    public void redeployResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("redeploy() not supported for administered-object-definition type");
    }

    public void enableResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("enable() not supported for administered-object-definition type");
    }

    public void disableResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("disable() not supported for administered-object-definition type");
    }

    public boolean handles(Object resource) {
        return resource instanceof AdministeredObjectDefinitionDescriptor;
    }

    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    class MyAdministeredObjectResource
    extends FakeConfigBean
    implements AdminObjectResource {
        private AdministeredObjectDefinitionDescriptor desc;
        private String name;

        public MyAdministeredObjectResource(AdministeredObjectDefinitionDescriptor desc, String name) {
            this.desc = desc;
            this.name = name;
        }

        public String getObjectType() {
            return "user";
        }

        public void setObjectType(String value) throws PropertyVetoException {
        }

        public String getIdentity() {
            return this.name;
        }

        public String getResAdapter() {
            return this.desc.getResourceAdapter();
        }

        public void setResAdapter(String value) throws PropertyVetoException {
        }

        public String getDescription() {
            return this.desc.getDescription();
        }

        public void setDescription(String value) throws PropertyVetoException {
        }

        public String getJndiName() {
            return this.name;
        }

        public void setJndiName(String value) throws PropertyVetoException {
        }

        public String getResType() {
            return this.desc.getInterfaceName();
        }

        public void setResType(String value) throws PropertyVetoException {
        }

        public String getClassName() {
            return this.desc.getClassName();
        }

        public void setClassName(String value) throws PropertyVetoException {
        }

        public String getEnabled() {
            return "true";
        }

        public void setEnabled(String value) throws PropertyVetoException {
        }

        public List<Property> getProperty() {
            Properties p = this.desc.getProperties();
            ArrayList<Property> administeredObjectProperties = new ArrayList<Property>();
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String key = (String)entry.getKey();
                if (key.startsWith(AdministeredObjectDefinitionDeployer.PROPERTY_PREFIX)) continue;
                String value = (String)entry.getValue();
                AdministeredObjectProperty dp = AdministeredObjectDefinitionDeployer.this.convertProperty(key, value);
                administeredObjectProperties.add(dp);
            }
            return administeredObjectProperties;
        }

        public Property addProperty(Property property) {
            throw new UnsupportedOperationException();
        }

        public Property lookupProperty(String s) {
            throw new UnsupportedOperationException();
        }

        public Property removeProperty(String s) {
            throw new UnsupportedOperationException();
        }

        public Property removeProperty(Property property) {
            throw new UnsupportedOperationException();
        }

        public Property getProperty(String name) {
            String value = this.desc.getProperty(name);
            return new AdministeredObjectProperty(name, value);
        }

        public String getPropertyValue(String name) {
            return this.desc.getProperty(name);
        }

        public String getPropertyValue(String name, String defaultValue) {
            String value = null;
            value = this.desc.getProperty(name);
            if (value != null) {
                return value;
            }
            return defaultValue;
        }

        public void injectedInto(Object o) {
        }

        public String getDeploymentOrder() {
            return null;
        }

        public void setDeploymentOrder(String value) {
        }
    }

    class AdministeredObjectProperty
    extends FakeConfigBean
    implements Property {
        private String name;
        private String value;
        private String description;

        AdministeredObjectProperty(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String value) throws PropertyVetoException {
            this.name = value;
        }

        public String getValue() {
            return TranslatedConfigView.expandValue((String)this.value);
        }

        public void setValue(String value) throws PropertyVetoException {
            this.value = value;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String value) throws PropertyVetoException {
            this.description = value;
        }

        public void injectedInto(Object o) {
        }
    }

    abstract class FakeConfigBean
    implements ConfigBeanProxy {
        FakeConfigBean() {
        }

        public ConfigBeanProxy deepCopy(ConfigBeanProxy parent) {
            throw new UnsupportedOperationException();
        }

        public ConfigBeanProxy getParent() {
            return null;
        }

        public <T extends ConfigBeanProxy> T getParent(Class<T> tClass) {
            return null;
        }

        public <T extends ConfigBeanProxy> T createChild(Class<T> tClass) throws TransactionFailure {
            return null;
        }
    }
}

