/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.util;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.security.NewInstanceAction;

final class SecurityActions {
    private SecurityActions() {
    }

    static <T> T newInstance(Class<T> javaClass) throws InstantiationException, IllegalAccessException {
        if (System.getSecurityManager() != null) {
            try {
                return AccessController.doPrivileged(NewInstanceAction.of(javaClass));
            }
            catch (PrivilegedActionException e) {
                throw new WeldException(e.getCause());
            }
        }
        return javaClass.newInstance();
    }
}

