/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.util.Hashtable;

public class PurgeDurableHandler
extends AdminCmdHandler {
    private static boolean DEBUG = PurgeDurableHandler.getDEBUG();

    public PurgeDurableHandler(AdminDataHandler parent) {
        super(parent);
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        if (DEBUG) {
            this.logger.log(8, this.getClass().getName() + ": PurgeDurable: " + cmd_props);
        }
        int status = 200;
        String errMsg = null;
        String durable = (String)cmd_props.get("JMQDurableName");
        String clientID = (String)cmd_props.get("JMQClientID");
        try {
            if (clientID != null && clientID.trim().length() == 0) {
                throw new BrokerException(this.rb.getKString("B4109", clientID), 400);
            }
            HAMonitorService hamonitor = Globals.getHAMonitorService();
            if (hamonitor != null && hamonitor.inTakeover()) {
                status = 503;
                errMsg = this.rb.getString("B3233");
                this.logger.log(16, this.getClass().getName() + ": " + errMsg);
            } else {
                Subscription sub = Subscription.findDurableSubscription(clientID, durable);
                if (sub == null) {
                    errMsg = this.rb.getKString("B4425", Subscription.getDSubLogString(clientID, durable));
                    status = 404;
                } else {
                    sub.purge();
                }
            }
        }
        catch (BrokerException ex) {
            status = ex.getStatusCode();
            errMsg = PurgeDurableHandler.getMessageFromException(ex);
            if (status == 400 || status == 404 || status == 503) {
                this.logger.log(32, errMsg);
            }
            this.logger.logStack(32, ex.getMessage(), ex);
        }
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        PurgeDurableHandler.setProperties(reply, 67, status, errMsg);
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }
}

