/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resourcebase.resources.util;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;
import org.glassfish.logging.annotation.LoggerInfo;
import org.glassfish.resourcebase.resources.api.GenericResourceInfo;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;

public class ResourceUtil {
    @LogMessagesResourceBundle
    public static final String LOGMESSAGE_RESOURCE = "org.glassfish.resourcebase.resources.LogMessages";
    @LoggerInfo(subsystem="RESOURCE", description="Nucleus Resource", publish=true)
    public static final String LOGGER = "javax.enterprise.resources.util";
    private static final Logger _logger = Logger.getLogger("javax.enterprise.resources.util", "org.glassfish.resourcebase.resources.LogMessages");

    public static BindableResource getBindableResourceByName(Resources resources, String name) {
        Collection typedResources = resources.getResources(BindableResource.class);
        if (typedResources != null) {
            for (BindableResource resource : typedResources) {
                if (!resource.getJndiName().equals(name)) continue;
                return resource;
            }
        }
        return null;
    }

    public static Resource getResourceByName(Class<? extends Resource> clazz, Resources resources, String name) {
        Collection typedResources = resources.getResources(clazz);
        if (typedResources != null) {
            for (Resource resource : typedResources) {
                if (!resource.getIdentity().equals(name)) continue;
                return resource;
            }
        }
        return null;
    }

    public static Resource getResourceByIdentity(Resources resources, String name) {
        for (Resource resource : resources.getResources()) {
            if (!resource.getIdentity().equals(name)) continue;
            return resource;
        }
        return null;
    }

    public static ResourceInfo getResourceInfo(BindableResource resource) {
        if (resource.getParent() != null && resource.getParent().getParent() instanceof Application) {
            Application application = (Application)resource.getParent().getParent();
            return new ResourceInfo(resource.getJndiName(), application.getName());
        }
        if (resource.getParent() != null && resource.getParent().getParent() instanceof Module) {
            Module module = (Module)resource.getParent().getParent();
            Application application = (Application)module.getParent();
            return new ResourceInfo(resource.getJndiName(), application.getName(), module.getName());
        }
        return new ResourceInfo(resource.getJndiName());
    }

    public static boolean isValidEventType(Object instance) {
        return instance instanceof Resource;
    }

    public static ResourceInfo getGenericResourceInfo(Resource resource) {
        ResourceInfo resourceInfo = null;
        String resourceName = resource.getIdentity();
        resourceInfo = ResourceUtil.getGenericResourceInfo(resource, resourceName);
        return resourceInfo;
    }

    public static ResourceInfo getGenericResourceInfo(Resource resource, String resourceName) {
        if (resource.getParent() != null && resource.getParent().getParent() instanceof Application) {
            Application application = (Application)resource.getParent().getParent();
            return new ResourceInfo(resourceName, application.getName());
        }
        if (resource.getParent() != null && resource.getParent().getParent() instanceof Module) {
            Module module = (Module)resource.getParent().getParent();
            Application application = (Application)module.getParent();
            return new ResourceInfo(resourceName, application.getName(), module.getName());
        }
        return new ResourceInfo(resourceName);
    }

    public static PoolInfo getPoolInfo(ResourcePool resource) {
        if (resource.getParent() != null && resource.getParent().getParent() instanceof Application) {
            Application application = (Application)resource.getParent().getParent();
            return new PoolInfo(resource.getName(), application.getName());
        }
        if (resource.getParent() != null && resource.getParent().getParent() instanceof Module) {
            Module module = (Module)resource.getParent().getParent();
            Application application = (Application)module.getParent();
            return new PoolInfo(resource.getName(), application.getName(), module.getName());
        }
        return new PoolInfo(resource.getName());
    }

    public static String getActualModuleNameWithExtension(String moduleName) {
        String actualModuleName = moduleName;
        if (moduleName.endsWith("_war")) {
            int index = moduleName.lastIndexOf("_war");
            actualModuleName = moduleName.substring(0, index) + ".war";
        } else if (moduleName.endsWith("_rar")) {
            int index = moduleName.lastIndexOf("_rar");
            actualModuleName = moduleName.substring(0, index) + ".rar";
        } else if (moduleName.endsWith("_jar")) {
            int index = moduleName.lastIndexOf("_jar");
            actualModuleName = moduleName.substring(0, index) + ".jar";
        }
        return actualModuleName;
    }

    public static String getActualModuleName(String moduleName) {
        if (moduleName != null && (moduleName.endsWith(".jar") || moduleName.endsWith(".rar"))) {
            moduleName = moduleName.substring(0, moduleName.length() - 4);
        }
        return moduleName;
    }

    public static Object loadObject(String className) {
        Object obj = null;
        try {
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(className);
            obj = c.newInstance();
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "NCLS-RESOURCE-00001", className);
            _logger.log(Level.SEVERE, "NCLS-RESOURCE-00002", ex.getMessage());
        }
        return obj;
    }

    public static boolean isApplicationScopedResource(GenericResourceInfo resourceInfo) {
        return resourceInfo != null && resourceInfo.getApplicationName() != null && resourceInfo.getName() != null && resourceInfo.getName().startsWith("java:app/");
    }

    public static boolean isModuleScopedResource(GenericResourceInfo resourceInfo) {
        return resourceInfo != null && resourceInfo.getApplicationName() != null && resourceInfo.getModuleName() != null && resourceInfo.getName() != null && resourceInfo.getName().startsWith("java:module/");
    }
}

