/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.ActionManager;
import com.sun.messaging.jmq.admin.apps.console.ConsoleObj;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class AToolBar
extends JToolBar {
    private ConsoleObj conObj = null;
    private ActionManager actionMgr;
    private boolean displayIcons;
    private boolean displayText;
    private boolean displayToolTip;
    JButton addButton;
    JButton deleteButton;
    JButton propsButton;
    JButton shutdownButton;
    JButton restartButton;
    JButton connectButton;
    JButton disconnectButton;
    JButton queryButton;
    JButton pauseButton;
    JButton resumeButton;
    JButton refreshButton;

    public AToolBar(ActionManager actionMgr) {
        this(actionMgr, true, false, true);
    }

    public AToolBar(ActionManager actionMgr, boolean displayIcons, boolean displayText, boolean displayToolTip) {
        this.actionMgr = actionMgr;
        this.displayIcons = displayIcons;
        this.displayText = displayText;
        this.displayToolTip = displayToolTip;
        this.initGui();
    }

    public void setConsoleObj(ConsoleObj conObj) {
        this.conObj = conObj;
        this.setLabels();
        this.setIcons();
    }

    private void initGui() {
        this.setFloatable(false);
        this.addButton = this.addOneAction(this.actionMgr.getAction(1));
        this.deleteButton = this.addOneAction(this.actionMgr.getAction(2));
        this.propsButton = this.addOneAction(this.actionMgr.getAction(32));
        this.addSeparator();
        this.connectButton = this.addOneAction(this.actionMgr.getAction(1024));
        this.disconnectButton = this.addOneAction(this.actionMgr.getAction(2048));
        this.addSeparator();
        this.queryButton = this.addOneAction(this.actionMgr.getAction(65536));
        this.pauseButton = this.addOneAction(this.actionMgr.getAction(256));
        this.resumeButton = this.addOneAction(this.actionMgr.getAction(512));
        this.restartButton = this.addOneAction(this.actionMgr.getAction(128));
        this.shutdownButton = this.addOneAction(this.actionMgr.getAction(64));
        this.addSeparator();
        this.refreshButton = this.addOneAction(this.actionMgr.getAction(16384));
    }

    private JButton addOneAction(Action a) {
        JButton jb = this.add(a);
        if (!this.displayIcons) {
            jb.setIcon(null);
        }
        if (!this.displayText) {
            jb.setText("");
        }
        if (this.displayToolTip) {
            jb.setToolTipText((String)a.getValue("Name"));
        }
        return jb;
    }

    private void setLabels() {
        if (this.conObj == null) {
            return;
        }
        this.checkAndSetLabel(1, this.addButton);
        this.checkAndSetLabel(256, this.pauseButton);
        this.checkAndSetLabel(512, this.resumeButton);
        this.checkAndSetLabel(1024, this.connectButton);
        this.checkAndSetLabel(2048, this.disconnectButton);
    }

    private void checkAndSetLabel(int actionFlag, JButton button) {
        String label = this.conObj.getActionLabel(actionFlag, false);
        if (label != null) {
            if (this.displayToolTip) {
                button.setToolTipText(label);
            }
            if (this.displayText) {
                button.setText(label);
            }
        }
    }

    private void setIcons() {
        if (this.conObj == null) {
            return;
        }
        this.checkAndSetIcon(1024, this.connectButton);
        this.checkAndSetIcon(2048, this.disconnectButton);
    }

    private void checkAndSetIcon(int actionFlag, JButton button) {
        ImageIcon icon = this.conObj.getActionIcon(actionFlag);
        if (icon != null) {
            button.setDisabledIcon(null);
            button.setIcon(icon);
        }
    }
}

