/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.SessionQueue;
import java.io.PrintStream;
import java.util.logging.Level;

class AckQueue
extends SessionQueue {
    protected static long INITIAL_LOG_INTERVAL = 120000L;
    private static int DEFAULT_DUMP_COUNTER = 3;
    private static boolean dumpConnectionState = true;

    public AckQueue() {
    }

    public AckQueue(boolean useSequential, int size) {
        super(useSequential, size);
    }

    protected synchronized Object dequeueWait(ConnectionImpl conn, ReadWritePacket pkt, long timeout) {
        long totalElapsed = 0L;
        long timeLeftBeforeTimeout = timeout;
        int icounter = 0;
        long lengthOfNextWait = timeout > 0L && timeout < INITIAL_LOG_INTERVAL ? timeout : INITIAL_LOG_INTERVAL;
        while (this.isEmpty() && !this.isClosed) {
            if (icounter > 0) {
                // empty if block
            }
            long waitStartedTime = System.currentTimeMillis();
            try {
                this.wait(lengthOfNextWait);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.isEmpty() || this.isClosed) continue;
            long timeWeWaitedFor = System.currentTimeMillis() - waitStartedTime;
            totalElapsed += timeWeWaitedFor;
            if (timeWeWaitedFor < lengthOfNextWait) {
                lengthOfNextWait -= timeWeWaitedFor;
                continue;
            }
            if (this.shouldExit(conn)) {
                return null;
            }
            ++icounter;
            if (timeout == 0L) {
                lengthOfNextWait = INITIAL_LOG_INTERVAL * (long)(1 << icounter);
            } else {
                timeLeftBeforeTimeout = timeout - totalElapsed;
                System.out.println("timeleft=" + timeLeftBeforeTimeout);
                if (timeLeftBeforeTimeout > 0L) {
                    lengthOfNextWait = INITIAL_LOG_INTERVAL * (long)(1 << icounter);
                    if (timeLeftBeforeTimeout < lengthOfNextWait) {
                        lengthOfNextWait = timeLeftBeforeTimeout;
                    }
                } else {
                    this.isClosed = true;
                }
            }
            if (this.isClosed) continue;
            String ts = String.valueOf(totalElapsed / 1000L);
            this.printInfo(conn, pkt, ts);
            if (icounter != DEFAULT_DUMP_COUNTER) continue;
            String msg = "[Informational]: \n" + pkt.toVerboseString();
            ConnectionImpl.connectionLogger.log(Level.WARNING, msg);
            if (!dumpConnectionState) continue;
            conn.printDebugState();
        }
        if (this.isClosed) {
            return null;
        }
        return this.dequeue();
    }

    private boolean shouldExit(ConnectionImpl conn) {
        return conn.connectionIsBroken || conn.protocolHandler == null || conn.recoverInProcess;
    }

    protected void resend(ConnectionImpl conn, ReadWritePacket pkt) {
        try {
            boolean shouldResend = this.checkPacketType(conn, pkt);
            if (shouldResend) {
                conn.protocolHandler.resend(pkt);
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            this.isClosed = true;
        }
    }

    private boolean checkPacketType(ConnectionImpl conn, ReadWritePacket pkt) {
        if (!conn.isConnectedToHABroker) {
            return false;
        }
        boolean canResend = false;
        int ptype = pkt.getPacketType();
        switch (ptype) {
            case 10: 
            case 14: 
            case 18: 
            case 22: 
            case 28: 
            case 34: 
            case 46: 
            case 48: 
            case 50: 
            case 56: 
            case 68: 
            case 76: 
            case 78: {
                canResend = true;
                break;
            }
            default: {
                canResend = false;
            }
        }
        return canResend;
    }

    protected void printInfo(ConnectionImpl conn, ReadWritePacket pkt, String duration) {
        String type = PacketType.getString(pkt.getPacketType());
        String msg = AdministeredObject.cr.getKString("W2003", type, duration);
        msg = msg + ", broker addr=" + conn.getProtocolHandler().getConnectionHandler().getBrokerAddress() + ", connectionID=" + conn.connectionID + ", clientID=" + conn.clientID + ", consumerID=" + pkt.getConsumerID();
        ConnectionImpl.connectionLogger.log(Level.WARNING, msg);
    }

    @Override
    public void dump(PrintStream ps) {
        ps.println("------ AckQueue dump ------");
        ps.println("isEmpty: " + this.isEmpty());
        ps.println("isClosed: " + this.isClosed);
        if (this.size() > 0) {
            ps.println("^^^^^^ ack queue super class dump ^^^^^^");
            super.dump(ps);
            ps.println("^^^^^^ end ack queue super class dump ^^^^^^");
        }
    }

    static {
        try {
            boolean nostate;
            String dump_prop;
            String prop = System.getProperty("imq.ackWaitTime");
            if (prop != null) {
                INITIAL_LOG_INTERVAL = Long.parseLong(prop);
            }
            if ((dump_prop = System.getProperty("imq.ackDumpCount")) != null) {
                DEFAULT_DUMP_COUNTER = Integer.parseInt(dump_prop);
            }
            if (nostate = Boolean.getBoolean("imq.noConnectionState")) {
                dumpConnectionState = false;
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }
}

