/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.jmsclient.ConnectionConsumerImpl;
import com.sun.messaging.jmq.jmsclient.ConsumerReader;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import java.io.IOException;
import java.io.PrintStream;
import javax.jms.JMSException;

public class ConnectionConsumerReader
extends ConsumerReader {
    private ConnectionConsumerImpl connectionConsumer = null;
    private int load = 0;
    private int maxMessages;

    public ConnectionConsumerReader(ConnectionConsumerImpl connectionConsumer) {
        super(connectionConsumer.getConnection(), connectionConsumer.getReadQueue());
        this.connectionConsumer = connectionConsumer;
        this.maxMessages = connectionConsumer.getMaxMessages();
        if (this.maxMessages < 1) {
            this.maxMessages = 1;
        }
        this.load = 0;
    }

    @Override
    protected void deliver(ReadOnlyPacket packet) throws IOException, JMSException {
        MessageImpl message = this.protocolHandler.getJMSMessage(packet);
        if (this.maxMessages == 1) {
            this.connectionConsumer.onMessage(message);
            this.connectionConsumer.startServerSession();
        } else {
            if (this.load == 0) {
                this.load = this.sessionQueue.size() + 1;
                if (this.load > this.maxMessages) {
                    this.load = this.maxMessages;
                }
            }
            this.connectionConsumer.onMessage(message);
            --this.load;
            if (this.load == 0) {
                this.connectionConsumer.startServerSession();
            }
        }
    }

    @Override
    protected void deliver() throws IOException, JMSException {
        this.connectionConsumer.onNullMessage();
    }

    @Override
    public void dump(PrintStream ps) {
        ps.println("------ ConnectionConsumerReader dump ------");
        ps.println("maxMessages: " + this.maxMessages);
        ps.println("current load: " + this.load);
        super.dump(ps);
    }
}

