/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.Destination;
import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.auth.api.client.AuthenticationProtocolHandler;
import com.sun.messaging.jmq.auth.handlers.BasicAuthenticationHandler;
import com.sun.messaging.jmq.auth.handlers.DigestAuthenticationHandler;
import com.sun.messaging.jmq.io.PacketDispatcher;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsclient.AckQueue;
import com.sun.messaging.jmq.jmsclient.AsyncSendCallback;
import com.sun.messaging.jmq.jmsclient.BytesMessageImpl;
import com.sun.messaging.jmq.jmsclient.ConnectionConsumerImpl;
import com.sun.messaging.jmq.jmsclient.ConnectionHandler;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Consumer;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MapMessageImpl;
import com.sun.messaging.jmq.jmsclient.MessageConsumerImpl;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.MessageProducerImpl;
import com.sun.messaging.jmq.jmsclient.ObjectMessageImpl;
import com.sun.messaging.jmq.jmsclient.ReadChannel;
import com.sun.messaging.jmq.jmsclient.RemoteAcknowledgeException;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.StreamMessageImpl;
import com.sun.messaging.jmq.jmsclient.TemporaryDestination;
import com.sun.messaging.jmq.jmsclient.TextMessageImpl;
import com.sun.messaging.jmq.jmsclient.TransactionPrepareStateFAILEDException;
import com.sun.messaging.jmq.jmsclient.auth.JMQAdminKeyAuthenticationHandler;
import com.sun.messaging.jmq.jmsclient.auth.UnsupportedAuthTypeException;
import com.sun.messaging.jmq.jmsclient.logging.Loggable;
import com.sun.messaging.jmq.jmsclient.protocol.direct.DirectConnectionHandler;
import com.sun.messaging.jmq.jmsclient.runtime.impl.BrokerInstanceImpl;
import com.sun.messaging.jmq.jmsclient.validation.ValidatorFactory;
import com.sun.messaging.jmq.jmsclient.validation.XMLValidator;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.net.IPAddress;
import com.sun.messaging.jms.InvalidClientIDException;
import com.sun.messaging.jms.InvalidDestinationException;
import com.sun.messaging.jms.InvalidSelectorException;
import com.sun.messaging.jms.JMSSecurityException;
import com.sun.messaging.jms.ResourceAllocationException;
import com.sun.messaging.jms.TransactionRolledBackException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.constant.Constable;
import java.net.InetAddress;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.security.auth.login.LoginException;

public class ProtocolHandler {
    private volatile boolean sentSetClientID = false;
    private volatile boolean hasConnectionConsumer = false;
    private static final Version version = ConnectionImpl.version;
    public static final String REQUEST_META_DATA = "requestMetaData";
    public static final int ACK_MESSAGE_BODY_SIZE = 36;
    private static final int DIRECT_ACK_TIMEOUT = 60000;
    protected int timeout = 0;
    protected int pingTimeout = 0;
    public static final int SERVER_OK = 200;
    public static final long MIN_ACK_ID = 0L;
    private long nextAckID = 0L;
    private byte[] ipAddress = null;
    private byte[] macAddress = null;
    private int localPort = 0;
    private ConnectionImpl connection = null;
    protected Hashtable requestMetaData = null;
    private ConnectionHandler connectionHandler = null;
    private boolean ackEnabled = true;
    private boolean ackEnabledFlag = false;
    private boolean produceAck = false;
    private boolean debug = Debug.debug;
    private boolean isClosed = false;
    protected int stoppedCount = 0;
    private Object incObj = new Object();
    private boolean ackAck = true;
    protected boolean authenticated = false;
    protected Thread recoverThread = null;
    private boolean setJMSXAppID = false;
    private boolean setJMSXUserID = false;
    private boolean setJMSXRcvTimestamp = false;
    private String jmsxAppID = null;
    private String jmsxUserID = null;
    private static final String AUTHTYPE_JMQADMINKEY = "jmqadminkey";
    private static final String AUTHTYPE_JMQBASIC = "basic";
    private static final String AUTHTYPE_JMQDIGEST = "digest";
    private boolean timeToPing = false;
    private long nonRespPingTimeStamp = 0L;
    private Object nonResponsiveSyncObj = new Object();
    private boolean isPingTimeStampSet = false;
    private boolean imqAbortOnPingAckTimeout = false;
    private boolean enableZip = Boolean.getBoolean("imq.zip.enable");
    public static final String INBOUND_PACKET_LOGGING_NAME = "com.sun.messaging.jms.pkt.in";
    public static final String OUTBOUND_PACKET_LOGGING_NAME = "com.sun.messaging.jms.pkt.out";
    private boolean debugInboundPkt = false;
    private boolean debugOutboundPkt = false;
    private String pktFilter = null;
    private static Logger inpktLogger = null;
    private static Logger outpktLogger = null;
    private Logger connLogger = ConnectionImpl.connectionLogger;
    protected boolean twoPhaseCommitFlag = false;
    private static boolean turnOffXMLValidation = Boolean.getBoolean("imq.xml.validation.disabled");
    private Hashtable xmlValidationTable = new Hashtable();
    private Object getNextAckIDMutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getNextAckID() {
        Long result;
        Object object = this.getNextAckIDMutex;
        synchronized (object) {
            ++this.nextAckID;
            if (this.nextAckID == Long.MAX_VALUE) {
                this.nextAckID = 1L;
            }
            result = this.nextAckID;
        }
        return result;
    }

    protected void setTimeToPing(boolean pflag) {
        this.timeToPing = pflag;
    }

    protected boolean getTimeToPing() {
        return this.timeToPing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPingTimeStamp() {
        Object object = this.nonResponsiveSyncObj;
        synchronized (object) {
            this.isPingTimeStampSet = true;
            if (this.nonRespPingTimeStamp == 0L) {
                this.nonRespPingTimeStamp = System.currentTimeMillis();
                if (this.debug) {
                    Debug.println("*** ping time stamp: " + this.nonRespPingTimeStamp);
                }
            } else {
                long currentTime = System.currentTimeMillis();
                long waitTime = currentTime - this.nonRespPingTimeStamp;
                if (waitTime > (long)this.pingTimeout) {
                    this.connection.readChannel.setBrokerNonResponsive();
                    if (this.debug) {
                        Debug.println("*** timeout on ping.  wait time: " + waitTime);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetPingTimeStamp() {
        Object object = this.nonResponsiveSyncObj;
        synchronized (object) {
            this.isPingTimeStampSet = false;
            this.nonRespPingTimeStamp = 0L;
            if (this.debug) {
                Debug.println("*** ping time stamp reset to 0 ...");
            }
        }
    }

    private void findLocalHostIP() throws Exception {
        String useMac = System.getProperty("imq.useMac", "true");
        try {
            this.ipAddress = InetAddress.getLocalHost().getAddress();
            if (useMac.equalsIgnoreCase("true")) {
                this.macAddress = IPAddress.getRandomMac();
            }
            this.localPort = this.connectionHandler.getLocalPort();
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            this.ipAddress = null;
            this.localPort = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePacketNoAck(ReadWritePacket pkt) throws JMSException {
        this.checkConnectionState(pkt);
        try {
            ProtocolHandler protocolHandler = this;
            synchronized (protocolHandler) {
                if (this.macAddress == null) {
                    pkt.setIP(this.getIPAddress());
                } else {
                    pkt.setIP(this.getIPAddress(), this.getMacAddress());
                }
                pkt.setPort(this.getLocalPort());
                this.connectionHandler.writePacket(pkt);
                this.setTimeToPing(false);
                if (this.debugOutboundPkt) {
                    Debug.matchAndPrintPacket(pkt, this.pktFilter, " -------writing packet----->");
                } else if (this.debug) {
                    Debug.println(new Date().toString() + " ---> writing packet: " + pkt);
                    Debug.printWritePacket(pkt);
                }
                if (this.connLogger.isLoggable(Level.FINEST)) {
                    Object[] params = new Object[]{pkt, this.connection};
                    this.connLogger.log(Level.FINEST, "I106", params);
                }
                if (outpktLogger.isLoggable(Level.FINEST)) {
                    outpktLogger.log(Level.FINEST, "sent packet ... " + pkt, pkt);
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4001", true);
        }
    }

    private ReadOnlyPacket writePacketWithReply(ReadWritePacket pkt, int expectedReplyType) throws JMSException {
        ReadOnlyPacket ack = this.writePacketWithAck(pkt);
        this.checkReplyType(ack, expectedReplyType);
        return ack;
    }

    private ReadOnlyPacket writePacketWithReply(ReadWritePacket pkt, int expectedReplyType, int altExpectedReplyType) throws JMSException {
        ReadOnlyPacket ack = this.writePacketWithAck(pkt);
        int packetType = ack.getPacketType();
        if (packetType != expectedReplyType && packetType != altExpectedReplyType) {
            if (this.debug) {
                Debug.println("expected pkt type: " + expectedReplyType);
                Debug.println("alt expected pkt type: " + altExpectedReplyType);
                Debug.println("pkt type: " + packetType);
            }
            String errorString = AdministeredObject.cr.getKString("C4000") + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new com.sun.messaging.jms.JMSException(errorString, "C4000"));
        }
        return ack;
    }

    private ReadOnlyPacket writePacketWithReply2(ReadWritePacket pkt, int expectedReplyType1, int expectedReplyType2) throws JMSException {
        ReadOnlyPacket ack = this.writePacketWithAck(pkt, true, expectedReplyType1);
        if (ack.getPacketType() != expectedReplyType2) {
            if (this.debug) {
                Debug.println("expected pkt type: " + expectedReplyType2);
                Debug.println("pkt type: " + ack.getPacketType());
            }
            String errorString = AdministeredObject.cr.getKString("C4000") + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new com.sun.messaging.jms.JMSException(errorString, "C4000"));
        }
        return ack;
    }

    private void writePacketWithAck(ReadWritePacket pkt, int expectedAckType) throws JMSException {
        ReadOnlyPacket ack = this.writePacketWithReply(pkt, expectedAckType);
        int statusCode = ProtocolHandler.getReplyStatus(ack);
        if (statusCode != 200) {
            this.throwServerErrorException(ack);
        }
    }

    private ReadOnlyPacket writePacketWithAck(ReadWritePacket pkt) throws JMSException {
        return this.writePacketWithAck(pkt, false, -1);
    }

    private ReadOnlyPacket writePacketWithAck(ReadWritePacket pkt, boolean reply2, int expectedAckType1) throws JMSException {
        boolean synchronousReply;
        Object ack = null;
        Long ackId = this.getNextAckID();
        pkt.setConsumerID(ackId);
        pkt.setSendAcknowledge(true);
        AckQueue tmpQ = null;
        boolean bl = synchronousReply = this.isDirectModeTwoThreadWithSyncReplies() && pkt.getPacketType() != 22;
        if (!synchronousReply) {
            tmpQ = reply2 ? new AckQueue(true, 2) : new AckQueue(true, 1);
            this.connection.addToAckQTable(ackId, tmpQ);
        }
        this.addMetaData(pkt);
        this.writePacketNoAck(pkt);
        ack = synchronousReply ? (ReadOnlyPacket)((DirectConnectionHandler)this.connectionHandler).fetchReply() : ((this.connection.connectionIsBroken || this.connection.recoverInProcess) && tmpQ.isEmpty() ? null : (ReadOnlyPacket)tmpQ.dequeueWait(this.connection, pkt, this.timeout));
        if (reply2 && ack != null) {
            try {
                String errorString;
                int statusCode = (Integer)((ReadOnlyPacket)ack).getProperties().get("JMQStatus");
                int packetType = ((ReadOnlyPacket)ack).getPacketType();
                if (packetType != expectedAckType1) {
                    errorString = AdministeredObject.cr.getKString("C4000") + this.getUserBrokerInfo();
                    ExceptionHandler.throwJMSException(new com.sun.messaging.jms.JMSException(errorString, "C4000"));
                }
                if (packetType == 11) {
                    if (statusCode == 503) {
                        errorString = AdministeredObject.cr.getKString("C4037") + this.getUserBrokerInfo();
                        ExceptionHandler.throwJMSException((JMSException)((Object)new ResourceAllocationException(errorString, "C4037")));
                    } else if (statusCode == 408) {
                        errorString = AdministeredObject.cr.getKString("C4099") + this.getUserBrokerInfo();
                        ExceptionHandler.throwJMSException((JMSException)((Object)new ResourceAllocationException(errorString, "C4099")));
                    } else if (statusCode == 301) {
                        errorString = AdministeredObject.cr.getKString("C4100") + this.getUserBrokerInfo();
                        ExceptionHandler.throwJMSException((JMSException)((Object)new ResourceAllocationException(errorString, "C4100")));
                    }
                    Long brokerSessionIDLong = (Long)((ReadOnlyPacket)ack).getProperties().get("JMQBrokerSessionID");
                    if (brokerSessionIDLong != null) {
                        this.connection.setBrokerSessionID(brokerSessionIDLong);
                    }
                }
                if (statusCode != 200) {
                    this.throwServerErrorException((ReadOnlyPacket)ack);
                }
                ack = this.isDirectModeTwoThreadWithSyncReplies() ? (ReadOnlyPacket)((DirectConnectionHandler)this.connectionHandler).fetchReply() : ((this.connection.connectionIsBroken || this.connection.recoverInProcess) && tmpQ.isEmpty() ? null : (ReadOnlyPacket)tmpQ.dequeueWait(this.connection, pkt, this.timeout));
            }
            catch (IOException e) {
                ExceptionHandler.handleException(e, "C4000", true);
            }
            catch (ClassNotFoundException e) {
                ExceptionHandler.handleException(e, "C4000", true);
            }
        }
        this.connection.removeFromAckQTable(ackId);
        if (ack == null) {
            String errorString = AdministeredObject.cr.getKString("C4000") + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new com.sun.messaging.jms.JMSException(errorString, "C4000"));
        }
        return ack;
    }

    private ReadOnlyPacket writeJMSMessagePacketAsync(ReadWritePacket pkt, AsyncSendCallback asynccb) throws JMSException {
        ReadOnlyPacket ack = null;
        Long ackId = this.getNextAckID();
        pkt.setConsumerID(ackId);
        pkt.setSendAcknowledge(true);
        boolean synchronousReply = this.isDirectModeTwoThreadWithSyncReplies();
        if (!synchronousReply) {
            this.requestMetaData.put(ackId, asynccb);
            asynccb.asyncSendStart();
        }
        this.writePacketNoAck(pkt);
        if (synchronousReply) {
            ack = (ReadOnlyPacket)((DirectConnectionHandler)this.connectionHandler).fetchReply();
        }
        return ack;
    }

    protected void addMetaData(ReadWritePacket pkt) throws JMSException {
        int pktType = pkt.getPacketType();
        if (pktType == 14 || pktType == 26 || pktType == 18) {
            try {
                Hashtable props = pkt.getProperties();
                Object consumer = props.get(REQUEST_META_DATA);
                props.remove(REQUEST_META_DATA);
                Long ackID = pkt.getConsumerID();
                this.requestMetaData.put(ackID, consumer);
            }
            catch (IOException e) {
                ExceptionHandler.handleException(e, "C4000", true);
            }
            catch (ClassNotFoundException e) {
                ExceptionHandler.handleException(e, "C4000", true);
            }
        }
    }

    private void checkConnectionState(ReadWritePacket pkt) throws JMSException {
        if (this.connection.imqReconnect && this.connection.reconnecting && Thread.currentThread() != this.recoverThread && Thread.currentThread() != this.connection.readChannel.readChannelThread) {
            this.connection.checkReconnecting(pkt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(boolean isReconnect) throws JMSException {
        this.isClosed = false;
        try {
            this.connectionHandler = isReconnect ? this.connection.initiator.reconnect() : this.connection.initiator.createConnection();
            this.setTimeout();
            if (this.isDirectModeTwoThread()) {
                this.setAckAck(false);
                this.enableWriteAcknowledge(false);
            }
            this.connectionHandler.configure(this.connection.getConfiguration());
            this.findLocalHostIP();
            this.setJMSXAppID = this.connection.connectionMetaData.setJMSXAppID;
            if (this.setJMSXAppID) {
                this.jmsxAppID = InetAddress.getLocalHost().getHostAddress() + "-" + this.getLocalPort() + "-" + System.currentTimeMillis();
            }
            this.setJMSXUserID = this.connection.connectionMetaData.setJMSXUserID;
            if (this.setJMSXUserID) {
                this.jmsxUserID = this.connection.getUserName();
            }
            this.setJMSXRcvTimestamp = this.connection.connectionMetaData.setJMSXRcvTimestamp;
            String prop1 = this.connection.getProperty("imqAbortOnPingAckTimeout", "false");
            String prop2 = this.connection.getProperty("imqAbortOnTimeout", "false");
            if ("true".equals(prop1) || "true".equals(prop2)) {
                this.imqAbortOnPingAckTimeout = true;
            }
            this.nonRespPingTimeStamp = 0L;
            this.isPingTimeStampSet = false;
            if (this.debug) {
                Debug.println("*** Connected to broker: " + this.getUserBrokerInfo());
            }
        }
        catch (JMSException jmse) {
            throw jmse;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4038", true);
        }
    }

    public void hello(String name, String password) throws JMSException {
        this.hello(name, password, null);
    }

    public void hello(String name, String password, Long connectionID) throws JMSException {
        String dp;
        this.authenticated = false;
        ReadWritePacket pkt = new ReadWritePacket();
        Hashtable<String, Object> ht = new Hashtable<String, Object>(1);
        ht.put("JMQRBufferSize", this.connection.flowControlMsgSize);
        ht.put("JMQProtocolLevel", this.connection.getBrokerProtocolLevel());
        ht.put("JMQVersion", version.getProductVersion());
        ht.put("JMQUserAgent", version.getUserAgent());
        if (this.connection.isAdminKeyUsed()) {
            ht.put("JMQAuthType", AUTHTYPE_JMQADMINKEY);
        }
        if ((dp = System.getProperty("imqDestinationProvider")) != null) {
            ht.put("JMQDestinationProvider", dp);
        }
        ht.put("JMQReconnectable", this.connection.imqReconnect);
        if (connectionID != null) {
            ht.put("JMQConnectionID", connectionID);
        }
        ht.put("JMQHAClient", this.connection.isHAEnabled());
        if (this.connection.JMQClusterID != null) {
            ht.put("JMQClusterID", this.connection.JMQClusterID);
        }
        if (this.connection.JMQStoreSession != null) {
            ht.put("JMQStoreSession", this.connection.JMQStoreSession);
        }
        pkt.setProperties(ht);
        pkt.setPacketType(10);
        ReadOnlyPacket authReq = this.writePacketWithReply2(pkt, 11, 38);
        Integer status = null;
        try {
            status = (Integer)authReq.getProperties().get("JMQStatus");
        }
        catch (IOException e) {
            ExceptionHandler.handleException(e, "C4005", true);
        }
        catch (ClassNotFoundException e) {
            ExceptionHandler.handleException(e, "C4005", true);
        }
        if (status != null) {
            String errorString;
            if (status == 403) {
                errorString = AdministeredObject.cr.getKString("C4035") + this.getUserBrokerInfo();
                ExceptionHandler.throwJMSException((JMSException)((Object)new JMSSecurityException(errorString, "C4035")));
            }
            if (status == 503) {
                errorString = AdministeredObject.cr.getKString("C4037") + this.getUserBrokerInfo();
                ExceptionHandler.throwJMSException((JMSException)((Object)new ResourceAllocationException(errorString, "C4037")));
            }
            if (status != 200) {
                this.throwServerErrorException(authReq);
            }
        }
        this.authenticate(authReq, name, password);
        this.authenticated = true;
        if (this.debug) {
            Debug.println("got hello reply ...");
        }
    }

    private void authenticate(ReadOnlyPacket authRequest, String name, String password) throws JMSException {
        Properties authProperties = this.connection.getConfiguration();
        AuthenticationProtocolHandler hd = null;
        ReadWritePacket request = (ReadWritePacket)authRequest;
        try {
            String errorString;
            String errorString2;
            String authType = (String)request.getProperties().get("JMQAuthType");
            Boolean chanllenge = (Boolean)request.getProperties().get("JMQChallenge");
            if (chanllenge != null && chanllenge.booleanValue()) {
                this.checkAdminKeyAuth(authType);
                hd = this.getAuthHandlerInstance(authType);
                hd.init(name, password, authProperties);
                this.connection.setAuthenticationHandler(hd);
            } else {
                hd = this.connection.getAuthenticationHandler();
            }
            if (hd == null) {
                errorString2 = AdministeredObject.cr.getKString("C4034") + this.getUserBrokerInfo();
                ExceptionHandler.throwJMSException((JMSException)((Object)new JMSSecurityException(errorString2, "C4034")));
            }
            while (request.getPacketType() != 13) {
                if (!hd.getType().equals(authType)) {
                    errorString2 = AdministeredObject.cr.getKString("C4033", hd.getType(), authType) + this.getUserBrokerInfo();
                    ExceptionHandler.throwJMSException((JMSException)((Object)new JMSSecurityException(errorString2, "C4033")));
                }
                byte[] reqData = request.getMessageBody();
                byte[] resData = hd.handleRequest(reqData, authRequest.getSequence());
                ReadWritePacket response = new ReadWritePacket();
                response.setPacketType(12);
                Hashtable<String, String> properties = new Hashtable<String, String>();
                properties.put("JMQAuthType", hd.getType());
                response.setProperties(properties);
                response.setMessageBody(resData);
                request = (ReadWritePacket)this.writePacketWithReply(response, 13, 38);
                authType = (String)request.getProperties().get("JMQAuthType");
            }
            int statusCode = (Integer)request.getProperties().get("JMQStatus");
            if (statusCode == 403) {
                errorString = AdministeredObject.cr.getKString("C4084", this.getUserBrokerInfo());
                ExceptionHandler.throwJMSException((JMSException)((Object)new JMSSecurityException(errorString, "C4084")));
            }
            if (statusCode == 413) {
                errorString = AdministeredObject.cr.getKString("C4060", this.getUserBrokerInfo());
                ExceptionHandler.throwJMSException((JMSException)((Object)new JMSSecurityException(errorString, "C4060")));
            }
            if (statusCode == 503) {
                errorString = AdministeredObject.cr.getKString("C4037") + this.getUserBrokerInfo();
                ExceptionHandler.throwJMSException((JMSException)((Object)new ResourceAllocationException(errorString, "C4037")));
            }
            if (statusCode != 200) {
                this.throwServerErrorException(request);
            }
        }
        catch (ClassNotFoundException e) {
            ExceptionHandler.handleException(e, "C4005", true);
        }
        catch (UnsupportedAuthTypeException e) {
            ExceptionHandler.handleException((Exception)e, "C4038");
        }
        catch (LoginException e) {
            ExceptionHandler.handleException((Exception)e, "C4038");
        }
        catch (IOException e) {
            ExceptionHandler.handleException((Exception)e, "C4038");
        }
    }

    private void checkAdminKeyAuth(String authType) throws JMSException {
        if (this.connection.isAdminKeyUsed() && !authType.equals(AUTHTYPE_JMQADMINKEY)) {
            String errorString = AdministeredObject.cr.getKString("C4033", AUTHTYPE_JMQADMINKEY, authType) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((JMSException)((Object)new JMSSecurityException(errorString, "C4033")));
        }
        if (!this.connection.isAdminKeyUsed() && authType.equals(AUTHTYPE_JMQADMINKEY)) {
            JMSSecurityException e = new JMSSecurityException(authType + this.getUserBrokerInfo());
            e.setLinkedException(new UnsupportedAuthTypeException(authType));
            ExceptionHandler.throwJMSException((JMSException)((Object)e));
        }
    }

    private AuthenticationProtocolHandler getAuthHandlerInstance(String authType) throws UnsupportedAuthTypeException {
        if (authType == null) {
            throw new UnsupportedAuthTypeException("authType is null" + this.getUserBrokerInfo());
        }
        if (authType.equals(AUTHTYPE_JMQBASIC)) {
            return new BasicAuthenticationHandler();
        }
        if (authType.equals(AUTHTYPE_JMQDIGEST)) {
            return new DigestAuthenticationHandler();
        }
        if (authType.equals(AUTHTYPE_JMQADMINKEY)) {
            return new JMQAdminKeyAuthenticationHandler();
        }
        String c = this.connection.getProperty("JMQAuthClass." + authType, "");
        if (c == null || c.trim().equals("") || c.trim().equals(AUTHTYPE_JMQADMINKEY)) {
            throw new UnsupportedAuthTypeException(authType + ": " + c + this.getUserBrokerInfo());
        }
        try {
            return (AuthenticationProtocolHandler)Class.forName(c).newInstance();
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            throw new UnsupportedAuthTypeException(authType + " " + e.getMessage() + this.getUserBrokerInfo());
        }
    }

    public void resumeFlow(int maxMessages) throws JMSException {
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setPacketType(52);
        this.writePacketNoAck(pkt);
    }

    public void resumeConsumerFlow(Consumer consumer, int maxMessages) throws JMSException {
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setPacketType(52);
        Hashtable<String, Number> ht = new Hashtable<String, Number>(1);
        if (this.debug && maxMessages == 0) {
            Debug.getPrintStream().println("\n\n######## SENDING RESUME_FLOW WITH JMQSIZE = 0. (POTENTIAL PROBLEM) ########");
        }
        ht.put("JMQConsumerID", consumer.getInterestId());
        ht.put("JMQSize", maxMessages);
        pkt.setProperties(ht);
        this.writePacketNoAck(pkt);
    }

    public void createMessageProducer(MessageProducerImpl producer) throws JMSException {
        Destination dest = (Destination)producer.getDestination();
        this.createMessageProducer(producer, dest);
    }

    public void createMessageProducer(MessageProducerImpl producer, javax.jms.Destination destination) throws JMSException {
        this.createMessageProducer(producer, destination, false);
    }

    public void createMessageProducer(MessageProducerImpl producer, javax.jms.Destination destination, boolean isRetry) throws JMSException {
        String errorString;
        Destination dest = (Destination)destination;
        this.createDestination(dest);
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setPacketType(18);
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("JMQDestination", dest.getName());
        Integer destinationType = this.getDestinationType(dest);
        ht.put("JMQDestType", destinationType);
        ht.put("JMQSessionID", producer.getSession().getBrokerSessionID());
        producer.addProducerDest = dest;
        ht.put(REQUEST_META_DATA, producer);
        pkt.setProperties(ht);
        ReadOnlyPacket reply = this.writePacketWithReply(pkt, 19);
        int statusCode = -1;
        try {
            Hashtable replyProps = reply.getProperties();
            statusCode = (Integer)replyProps.get("JMQStatus");
        }
        catch (IOException e) {
            ExceptionHandler.handleException(e, "C4000", true);
        }
        catch (ClassNotFoundException e) {
            ExceptionHandler.handleException(e, "C4000", true);
        }
        if (statusCode == 404) {
            errorString = AdministeredObject.cr.getKString("C4019", dest.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((JMSException)((Object)new InvalidDestinationException(errorString, "C4019")));
        }
        if (statusCode == 403) {
            errorString = AdministeredObject.cr.getKString("C4076", dest.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((JMSException)((Object)new JMSSecurityException(errorString, "C4076")));
        }
        if (statusCode == 405) {
            String destString = AdministeredObject.cr.getString(dest.isQueue() ? "L0950" : "L0951");
            String errorString2 = AdministeredObject.cr.getKString("C4088", destString, dest.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((JMSException)((Object)new ResourceAllocationException(errorString2, "C4088")));
        }
        if (statusCode == 449 && !isRetry) {
            this.createMessageProducer(producer, destination, true);
            return;
        }
        if (statusCode != 200) {
            this.throwServerErrorException(reply);
        }
        if (this.debug) {
            Debug.println("got create producer reply ...");
        }
    }

    public void deleteMessageProducer(long producerID) throws JMSException {
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setPacketType(66);
        Hashtable<String, Long> ht = new Hashtable<String, Long>(1);
        ht.put("JMQProducerID", producerID);
        pkt.setProperties(ht);
        ReadOnlyPacket ack = this.writePacketWithReply(pkt, 67);
        int statusCode = ProtocolHandler.getReplyStatus(ack);
        if (statusCode != 200) {
            this.throwServerErrorException(ack);
        }
        if (this.debug) {
            Debug.println("got delete producer reply ...");
        }
    }

    public void createDestination(javax.jms.Destination dest) throws JMSException {
        this.createDestination(dest, false);
    }

    private void createDestination(javax.jms.Destination dest, boolean isRetry) throws JMSException {
        String errorString;
        TemporaryDestination tmpDest;
        Destination destination = (Destination)dest;
        if (destination.isTemporary() && destination instanceof TemporaryDestination && !(tmpDest = (TemporaryDestination)destination).checkSendCreateDest(destination, this.connection)) {
            return;
        }
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setPacketType(34);
        Hashtable<String, Object> ht = new Hashtable<String, Object>(2);
        ht.put("JMQDestination", destination.getName());
        Integer destinationType = this.getDestinationType(destination);
        ht.put("JMQDestType", destinationType);
        pkt.setProperties(ht);
        ReadOnlyPacket ack = this.writePacketWithReply(pkt, 35);
        int statusCode = ProtocolHandler.getReplyStatus(ack);
        if (statusCode == 404) {
            errorString = AdministeredObject.cr.getKString("C4019", destination.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((JMSException)((Object)new InvalidDestinationException(errorString, "C4019")));
        }
        if (statusCode == 403) {
            errorString = AdministeredObject.cr.getKString("C4077", destination.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((JMSException)((Object)new JMSSecurityException(errorString, "C4077")));
        }
        if (statusCode == 449 && !isRetry) {
            this.createDestination(destination, true);
            return;
        }
        if (statusCode != 200 && statusCode != 409) {
            this.throwServerErrorException(ack);
        }
        this.setXMLValidation(destination, ack);
        if (this.debug) {
            Debug.println("got create destination reply ...");
        }
    }

    public void deleteDestination(javax.jms.Destination dest) throws JMSException {
        Destination destination = (Destination)dest;
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setPacketType(36);
        Hashtable<String, Object> ht = new Hashtable<String, Object>(2);
        ht.put("JMQDestination", destination.getName());
        Integer destinationType = this.getDestinationType(destination);
        ht.put("JMQDestType", destinationType);
        pkt.setProperties(ht);
        ReadOnlyPacket ack = this.writePacketWithReply(pkt, 37);
        int statusCode = ProtocolHandler.getReplyStatus(ack);
        if (statusCode != 200 && statusCode != 404) {
            this.throwServerErrorException(ack);
        }
        if (this.debug) {
            Debug.println("got delete destination reply ...");
        }
    }

    public Integer getDestinationType(Destination destination) {
        int type = 0;
        type = destination.isQueue() ? 1 : 2;
        if (destination.isTemporary()) {
            type |= 0x10;
        }
        return type;
    }

    protected void getIPFromPacket(ReadOnlyPacket rpkt) throws JMSException {
        try {
            Hashtable properties = rpkt.getProperties();
            Object value = properties.get("JMQIPAddr");
            this.ipAddress = (byte[])value;
            value = properties.get("JMQPort");
            this.localPort = (Integer)value;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4005", true);
        }
    }

    public ProtocolHandler(ConnectionImpl connection) throws JMSException {
        this.connection = connection;
        this.requestMetaData = connection.requestMetaData;
        inpktLogger = Logger.getLogger(INBOUND_PACKET_LOGGING_NAME);
        outpktLogger = Logger.getLogger(OUTBOUND_PACKET_LOGGING_NAME);
        this.init(false);
    }

    public void enableWriteAcknowledge(boolean state) {
        this.ackEnabled = state;
        this.ackEnabledFlag = true;
        if (this.debug) {
            Debug.println("Producer ack required: " + this.ackEnabled);
        }
    }

    public boolean getAckEnabled() {
        return this.ackEnabled;
    }

    public void setAckAck(boolean state) {
        this.ackAck = state;
        if (this.debug) {
            Debug.println("Auto/Client acknowledge require ack from broker: " + this.ackAck);
        }
    }

    public boolean getAckAck() {
        return this.ackAck;
    }

    protected void setTimeout() {
        String prop = this.connection.getTrimmedProperty("imqAckTimeout");
        if (prop != null) {
            this.timeout = Integer.parseInt(prop);
        }
        if (this.isDirectMode() && this.timeout == 0) {
            this.timeout = 60000;
        }
        if ((prop = this.connection.getTrimmedProperty("imqPingAckTimeout")) != null) {
            this.pingTimeout = Integer.parseInt(prop);
        }
        if (this.debug) {
            Debug.println("Ack timeout: " + this.timeout);
            Debug.println("Ping Ack timeout: " + this.pingTimeout);
        }
    }

    public int getPingAckTimeout() {
        return this.pingTimeout;
    }

    public byte[] getIPAddress() {
        return this.ipAddress;
    }

    public byte[] getMacAddress() {
        return this.macAddress;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incStoppedCount() {
        Object object = this.incObj;
        synchronized (object) {
            ++this.stoppedCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decStoppedCount() {
        Object object = this.incObj;
        synchronized (object) {
            --this.stoppedCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStoppedCount() {
        Object object = this.incObj;
        synchronized (object) {
            return this.stoppedCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        try {
            Object object = this.incObj;
            synchronized (object) {
                if (this.stoppedCount == 0) {
                    ReadWritePacket pkt = new ReadWritePacket();
                    pkt.setPacketType(20);
                    this.writePacketNoAck(pkt);
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4001", true);
        }
    }

    public void resumeSession(long brokerSessionID) throws JMSException {
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setPacketType(20);
        Hashtable<String, Long> props = new Hashtable<String, Long>(1);
        props.put("JMQSessionID", brokerSessionID);
        pkt.setProperties(props);
        this.writePacketNoAck(pkt);
    }

    public void stop() throws JMSException {
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setPacketType(22);
        this.writePacketWithAck(pkt, 23);
    }

    public void stopSession(long brokerSessionID) throws JMSException {
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setPacketType(22);
        Hashtable<String, Long> props = new Hashtable<String, Long>(1);
        props.put("JMQSessionID", brokerSessionID);
        pkt.setProperties(props);
        this.writePacketWithAck(pkt, 23);
    }

    public void goodBye(boolean reply) throws JMSException {
        try {
            ReadWritePacket pkt = new ReadWritePacket();
            pkt.setPacketType(28);
            Hashtable<String, Comparable<Boolean>> props = new Hashtable<String, Comparable<Boolean>>();
            boolean jmqblock = this.sentSetClientID || this.hasConnectionConsumer;
            props.put("JMQBlock", Boolean.valueOf(jmqblock));
            props.put("JMQConnectionID", this.connection.connectionID);
            pkt.setProperties(props);
            if (reply) {
                this.writePacketWithAck(pkt, 29);
            } else {
                this.writePacketNoAck(pkt);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4001", true);
        }
    }

    public ReadWritePacket readPacket() throws JMSException {
        ReadWritePacket pkt = null;
        try {
            pkt = this.connectionHandler.readPacket();
            this.setTimeToPing(false);
            if (this.isPingTimeStampSet) {
                this.resetPingTimeStamp();
            }
            if (this.debugInboundPkt) {
                Debug.matchAndPrintPacket(pkt, this.pktFilter, " <------reading packet------");
            } else if (this.debug) {
                Debug.println(new Date().toString() + " <--- read packet: " + pkt);
                Debug.printReadPacket(pkt);
            }
            if (this.connLogger.isLoggable(Level.FINEST)) {
                Object[] params = new Object[]{pkt, this.connection};
                this.connLogger.log(Level.FINEST, "I105", params);
            }
            if (inpktLogger.isLoggable(Level.FINEST)) {
                inpktLogger.log(Level.FINEST, "read packet ... " + pkt, pkt);
            }
        }
        catch (Exception e) {
            if (!this.isClosed) {
                ExceptionHandler.handleException(e, "C4002", true);
            }
            throw new JMSException("ProtocolHandler is closed");
        }
        return pkt;
    }

    protected void writeJMSMessage(Message message, AsyncSendCallback asynccb) throws JMSException {
        ReadOnlyPacket ack;
        long jmsDeliveryTime;
        ReadWritePacket pkt = null;
        MessageImpl messageImpl = null;
        messageImpl = (MessageImpl)message;
        long jmsExpiration = message.getJMSExpiration();
        if (jmsExpiration != 0L) {
            message.setJMSExpiration(jmsExpiration += System.currentTimeMillis());
        }
        if ((jmsDeliveryTime = message.getJMSDeliveryTime()) != 0L) {
            message.setJMSDeliveryTime(jmsDeliveryTime += System.currentTimeMillis());
        }
        if (this.setJMSXAppID) {
            message.setStringProperty("JMSXAppID", this.jmsxAppID);
        }
        if (this.setJMSXUserID) {
            message.setStringProperty("JMSXUserID", this.jmsxUserID);
        }
        messageImpl.setMessageBodyToPacket();
        if (this.enableZip) {
            messageImpl.compress();
        } else if (messageImpl.shouldCompress) {
            messageImpl.compress();
        } else {
            messageImpl.getPacket().setFlag(1024, false);
        }
        messageImpl.setPropertiesToPacket();
        messageImpl.resetJMSMessageID();
        pkt = messageImpl.getPacket();
        Destination dest = (Destination)messageImpl.getJMSDestination();
        if (this.xmlValidationTable.containsKey(dest)) {
            if (pkt.getPacketType() == 1) {
                if (this.debug) {
                    Debug.println("*** Validating xml message ....");
                }
                XMLValidator validator = (XMLValidator)this.xmlValidationTable.get(dest);
                String xml = ((TextMessage)message).getText();
                validator.validate(xml);
                if (this.debug) {
                    Debug.println("*** xml message validated against xsd at URI: " + validator.getURIList());
                }
            }
        } else if (this.debug) {
            Debug.println("***** no validation for message ... on dest: " + dest.getName());
        }
        pkt.setDestination(dest.getName());
        pkt.setDestinationClass(dest.getClass().getName());
        pkt.setIsQueue(dest.isQueue());
        if (message.getJMSReplyTo() != null) {
            Destination replyTo = (Destination)message.getJMSReplyTo();
            pkt.setReplyTo(replyTo.getName());
            pkt.setReplyToClass(replyTo.getClass().getName());
        }
        if (asynccb == null) {
            if (this.ackEnabledFlag) {
                this.produceAck = this.ackEnabled;
            } else if (message.getJMSDeliveryMode() == 2) {
                this.produceAck = true;
                if (pkt.getTransactionID() != 0L && SessionImpl.noBlockUntilTxnCompletes) {
                    this.produceAck = false;
                }
            } else {
                this.produceAck = false;
            }
        }
        if (asynccb != null) {
            ack = this.writeJMSMessagePacketAsync(pkt, asynccb);
            if (ack != null) {
                int statusCode = ProtocolHandler.getReplyStatus(ack);
                if (statusCode != 200) {
                    try {
                        ProtocolHandler.checkWriteJMSMessageStatus(statusCode, dest, ack, this);
                    }
                    catch (JMSException e) {
                        asynccb.processException((Exception)((Object)e));
                        throw e;
                    }
                }
                asynccb.processCompletion(ack, false);
            }
        } else if (this.produceAck) {
            ack = this.writePacketWithReply(pkt, 9);
            int statusCode = ProtocolHandler.getReplyStatus(ack);
            if (statusCode != 200) {
                ProtocolHandler.checkWriteJMSMessageStatus(statusCode, dest, ack, this);
            }
        } else {
            pkt.setSendAcknowledge(false);
            this.writePacketNoAck(pkt);
        }
    }

    protected static void checkWriteJMSMessageStatus(int statusCode, Destination dest, ReadOnlyPacket ack, ProtocolHandler ph) throws JMSException {
        if (statusCode == 200) {
            return;
        }
        if (statusCode == 403) {
            String errorString = AdministeredObject.cr.getKString("C4078", dest.getName()) + ProtocolHandler.getUserBrokerInfo(ph);
            ExceptionHandler.throwJMSException((JMSException)((Object)new JMSSecurityException(errorString, "C4078")));
        } else if (statusCode == 404) {
            String errorString = AdministeredObject.cr.getKString("C4094", dest.getName()) + ProtocolHandler.getUserBrokerInfo(ph);
            ExceptionHandler.throwJMSException(new com.sun.messaging.jms.JMSException(errorString, "C4094"));
        } else if (statusCode == 423) {
            String errorString = AdministeredObject.cr.getKString("C4095", dest.getName()) + ProtocolHandler.getUserBrokerInfo(ph);
            ExceptionHandler.throwJMSException(new com.sun.messaging.jms.JMSException(errorString, "C4095"));
        } else if (statusCode == 414) {
            String errorString = AdministeredObject.cr.getKString("C4096", dest.getName()) + ProtocolHandler.getUserBrokerInfo(ph);
            ExceptionHandler.throwJMSException((JMSException)((Object)new ResourceAllocationException(errorString, "C4096")));
        } else {
            ProtocolHandler.throwServerErrorException(ack, ph);
        }
    }

    public MessageImpl getJMSMessage(ReadOnlyPacket pkt) throws JMSException {
        MessageImpl message = null;
        switch (pkt.getPacketType()) {
            case 1: {
                message = new TextMessageImpl();
                break;
            }
            case 2: {
                message = new BytesMessageImpl();
                break;
            }
            case 4: {
                message = new StreamMessageImpl();
                break;
            }
            case 3: {
                message = new MapMessageImpl();
                break;
            }
            case 5: {
                message = new ObjectMessageImpl();
                break;
            }
            case 6: {
                message = new MessageImpl();
                break;
            }
            default: {
                throw new com.sun.messaging.jms.JMSException("not implemented.");
            }
        }
        ((ReadWritePacket)pkt).setTransactionID(0L);
        message.setPacket((ReadWritePacket)pkt);
        message.getPropertiesFromPacket();
        message.getMessageBodyFromPacket();
        if (this.setJMSXRcvTimestamp) {
            message.setStringProperty("JMSXRcvTimestamp", String.valueOf(System.currentTimeMillis()));
        }
        message.setIntProperty("JMSXDeliveryCount", pkt.getDeliveryCount());
        message.setMessageReadMode(true);
        message.setPropertiesReadMode(true);
        message.setMessageID(pkt.getSysMessageID());
        message.setInterestID(pkt.getConsumerID());
        return message;
    }

    public ReadWritePacket createReadWritePacket() {
        return new ReadWritePacket();
    }

    public long getInterestId(ReadWritePacket pkt) {
        return pkt.getConsumerID();
    }

    public void resetClientID() throws JMSException {
        if (this.sentSetClientID) {
            this.setClientID(this.connection.clientID);
        }
    }

    public void unsetClientID() throws JMSException {
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setPacketType(50);
        Hashtable<String, String> props = new Hashtable<String, String>();
        if (this.connection.useNamespace()) {
            props.put("JMQNamespace", this.connection.getRANamespaceUID());
        }
        pkt.setProperties(props);
        ReadOnlyPacket ack = this.writePacketWithReply(pkt, 51);
        int statusCode = ProtocolHandler.getReplyStatus(ack);
        if (statusCode != 200) {
            this.throwServerErrorException(ack);
        }
        this.sentSetClientID = false;
    }

    public void setClientID(String clientID) throws JMSException {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setPacketType(50);
        props.put("JMQClientID", clientID);
        if (this.connection.useNamespace()) {
            props.put("JMQNamespace", this.connection.getRANamespaceUID());
        }
        props.put("JMQShare", this.connection.imqEnableSharedClientID);
        pkt.setProperties(props);
        ReadOnlyPacket ack = this.writePacketWithReply(pkt, 51);
        int statusCode = ProtocolHandler.getReplyStatus(ack);
        if (statusCode != 200) {
            if (statusCode == 409) {
                String errorString = AdministeredObject.cr.getKString("C4052", clientID) + this.getUserBrokerInfo();
                ExceptionHandler.throwJMSException((JMSException)((Object)new InvalidClientIDException(errorString, "C4052")));
            } else if (statusCode == 400) {
                String errorString = AdministeredObject.cr.getKString("C4087", clientID) + this.getUserBrokerInfo();
                ExceptionHandler.throwJMSException((JMSException)((Object)new InvalidClientIDException(errorString, "C4087")));
            } else if (statusCode == 408) {
                String errorString = AdministeredObject.cr.getKString("C4330", clientID, this) + this.getUserBrokerInfo();
                ExceptionHandler.throwJMSException(new com.sun.messaging.jms.JMSException(errorString, "C4330"));
            } else {
                this.throwServerErrorException(ack);
            }
        }
        this.sentSetClientID = true;
    }

    public void requestConsumerInfo(Destination dest, boolean off) throws JMSException {
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setPacketType(72);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("JMQDestination", dest.getName());
        props.put("JMQDestType", this.getDestinationType(dest));
        props.put("JMQRequestType", 3);
        props.put("JMQRequestOff", off);
        pkt.setProperties(props);
        this.writePacketNoAck(pkt);
    }

    public void addInterest(Consumer consumer) throws JMSException {
        this.addInterest(consumer, false);
    }

    private void addInterest(Consumer consumer, boolean isRetry) throws JMSException {
        String errorString;
        Destination dest = (Destination)consumer.getDestination();
        this.createDestination(dest);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setPacketType(14);
        if (consumer.getDurable()) {
            props.put("JMQDurableName", consumer.getDurableName());
        }
        if (consumer.getShared()) {
            if (this.connection.getBrokerProtocolLevel() < 500) {
                String errorString2 = AdministeredObject.cr.getKString("C4331", this.connection.getBrokerVersion());
                com.sun.messaging.jms.JMSException jmse = new com.sun.messaging.jms.JMSException(errorString2, "C4331");
                ExceptionHandler.throwJMSException(jmse);
            }
            props.put("JMQJMSShare", consumer.getShared());
            if (consumer.getSharedSubscriptionName() != null) {
                props.put("JMQSharedSubscriptionName", consumer.getSharedSubscriptionName());
            }
        } else if (consumer.getDurable()) {
            props.put("JMQShare", this.connection.imqEnableSharedClientID);
        } else {
            props.put("JMQShare", this.connection.imqEnableSharedSubscriptions && !dest.isTemporary());
        }
        props.put("JMQDestination", dest.getName());
        Integer destinationType = this.getDestinationType(dest);
        props.put("JMQDestType", destinationType);
        String selector = consumer.getMessageSelector();
        if (selector != null && selector.trim().length() == 0) {
            selector = null;
        }
        if (selector != null) {
            props.put("JMQSelector", selector);
        }
        props.put("JMQNoLocal", consumer.getNoLocal());
        props.put("JMQReconnect", Boolean.FALSE);
        if (consumer.acknowledgeMode > 0) {
            props.put("JMQAckMode", consumer.acknowledgeMode);
        }
        props.put(REQUEST_META_DATA, consumer);
        props.put("JMQSize", consumer.getPrefetchMaxMsgCount());
        if (consumer instanceof MessageConsumerImpl) {
            props.put("JMQSessionID", ((MessageConsumerImpl)consumer).getSession().getBrokerSessionID());
        } else if (consumer instanceof ConnectionConsumerImpl) {
            this.hasConnectionConsumer = true;
        }
        if (consumer.getInterestId() != null) {
            props.put("JMQOldConsumerID", consumer.getInterestId());
        }
        pkt.setProperties(props);
        ReadOnlyPacket reply = this.writePacketWithReply(pkt, 15);
        int statusCode = -1;
        String reason = null;
        try {
            Hashtable replyProps = reply.getProperties();
            statusCode = (Integer)replyProps.get("JMQStatus");
            reason = (String)replyProps.get("JMQReason");
        }
        catch (IOException e) {
            ExceptionHandler.handleException(e, "C4000", true);
        }
        catch (ClassNotFoundException e) {
            ExceptionHandler.handleException(e, "C4000", true);
        }
        if (statusCode == 400 && consumer.getMessageSelector() != null) {
            errorString = AdministeredObject.cr.getKString("C4022", consumer.getMessageSelector()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((JMSException)((Object)new InvalidSelectorException(errorString, "C4022")));
        }
        if (statusCode == 404) {
            errorString = AdministeredObject.cr.getKString("C4019", dest.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((JMSException)((Object)new InvalidDestinationException(errorString, "C4019")));
        }
        if (statusCode == 403) {
            errorString = AdministeredObject.cr.getKString("C4079", dest.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((JMSException)((Object)new JMSSecurityException(errorString, "C4079")));
        }
        if (statusCode == 405) {
            errorString = AdministeredObject.cr.getKString("C4020", dest.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new com.sun.messaging.jms.JMSException(errorString, "C4020"));
        }
        if (statusCode == 409) {
            String destString = AdministeredObject.cr.getString(dest.isQueue() ? "L0950" : "L0951");
            String errorString3 = AdministeredObject.cr.getKString("C4073", destString, dest.getName()) + this.getUserBrokerInfo() + (reason == null ? "" : "[" + reason + "]");
            ExceptionHandler.throwJMSException((JMSException)((Object)new ResourceAllocationException(errorString3, "C4073")));
        }
        if (statusCode == 449 && !isRetry) {
            this.addInterest(consumer, true);
            return;
        }
        if (statusCode != 200) {
            this.throwServerErrorException(reply);
        }
        if (this.debug) {
            Debug.println("added interest, JMQConsumerID: " + consumer.getInterestId());
        }
    }

    public void removeInterest(Consumer consumer) throws JMSException {
        String errorString;
        Hashtable<String, Constable> props = new Hashtable<String, Constable>();
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setPacketType(16);
        props.put("JMQConsumerID", consumer.getInterestId());
        props.put("JMQBlock", Boolean.TRUE);
        if (consumer instanceof MessageConsumerImpl) {
            SysMessageID lastID = ((MessageConsumerImpl)consumer).getLastDeliveredID();
            boolean lastIDInTransaction = ((MessageConsumerImpl)consumer).getLastDeliveredIDInTransaction();
            if (lastID != null) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(36);
                DataOutputStream dos = new DataOutputStream(bos);
                try {
                    lastID.writeID(dos);
                    dos.flush();
                    byte[] lastIDBody = bos.toByteArray();
                    dos.close();
                    bos.close();
                    pkt.setMessageBody(lastIDBody);
                    props.put("JMQBodyType", Integer.valueOf(3));
                    if (lastIDInTransaction) {
                        props.put("JMQLastDeliveredIDInTransaction", Boolean.valueOf(true));
                    }
                }
                catch (IOException ioe) {
                    ExceptionHandler.handleException((Exception)ioe, "C4038");
                }
            } else {
                props.put("JMQBodyType", Integer.valueOf(0));
                props.put("JMQRedeliverAll", Boolean.TRUE);
            }
        }
        pkt.setProperties(props);
        if (this.debug) {
            Debug.println("removing interest ....");
        }
        ReadOnlyPacket ack = this.writePacketWithReply(pkt, 17);
        int statusCode = ProtocolHandler.getReplyStatus(ack);
        if (statusCode == 403) {
            errorString = AdministeredObject.cr.getKString("C4080", consumer.getInterestId()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((JMSException)((Object)new JMSSecurityException(errorString, "C4080")));
        }
        if (statusCode == 404) {
            String cid = consumer.getInterestId().toString();
            String errorString2 = AdministeredObject.cr.getKString("C4085", cid) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((JMSException)((Object)new InvalidDestinationException(errorString2, "C4085")));
        }
        if (statusCode == 409 && consumer.getDurable()) {
            errorString = AdministeredObject.cr.getKString("C4007", consumer.getDurableName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((JMSException)((Object)new InvalidDestinationException(errorString, "C4007")));
        }
        if (statusCode != 200) {
            this.throwServerErrorException(ack);
        }
        if (this.debug) {
            Debug.println("interest removed: " + consumer.getInterestId());
        }
    }

    public void unsubscribe(String durableName) throws JMSException {
        String errorString;
        if (this.connection.getClientID() == null && this.connection.getBrokerProtocolLevel() < 500) {
            String errorString2 = AdministeredObject.cr.getKString("C4332", this.connection.getBrokerVersion());
            com.sun.messaging.jms.JMSException jmse = new com.sun.messaging.jms.JMSException(errorString2, "C4332");
            ExceptionHandler.throwJMSException(jmse);
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setPacketType(16);
        props.put("JMQDurableName", durableName);
        pkt.setProperties(props);
        ReadOnlyPacket ack = this.writePacketWithReply(pkt, 17);
        int statusCode = ProtocolHandler.getReplyStatus(ack);
        if (statusCode == 403) {
            errorString = AdministeredObject.cr.getKString("C4081", durableName) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((JMSException)((Object)new JMSSecurityException(errorString, "C4081")));
        }
        if (statusCode == 409) {
            errorString = AdministeredObject.cr.getKString("C4007", durableName) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((JMSException)((Object)new ResourceAllocationException(errorString, "C4007")));
        }
        if (statusCode == 404) {
            errorString = AdministeredObject.cr.getKString("C4086", durableName) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((JMSException)((Object)new InvalidDestinationException(errorString, "C4086")));
        }
        if (statusCode != 200) {
            this.throwServerErrorException(ack);
        }
    }

    public synchronized void close() throws JMSException {
        if (this.isClosed) {
            return;
        }
        try {
            this.isClosed = true;
            this.connectionHandler.close();
            this.xmlValidationTable.clear();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4004", true);
        }
        if (this.debug) {
            Debug.println("ConnectionHandler closed ...");
        }
    }

    public void acknowledgeUndeliverable(ReadWritePacket pkt, boolean sendToDMQ) throws JMSException {
        this.acknowledgeUndeliverable(pkt, sendToDMQ, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeUndeliverable(ReadWritePacket pkt, boolean sendToDMQ, int deadReason) throws JMSException {
        try {
            Hashtable<String, Integer> props = new Hashtable<String, Integer>();
            if (sendToDMQ) {
                props.put("JMQAckType", 2);
            } else {
                props.put("JMQAckType", 1);
            }
            if (sendToDMQ) {
                props.put("JMQDeadReason", deadReason);
            }
            pkt.setProperties(props);
            pkt.setPacketType(24);
            if (pkt.getSendAcknowledge() && this.ackAck) {
                this.writePacketWithAck(pkt, 25);
            } else {
                pkt.setSendAcknowledge(false);
                this.writePacketNoAck(pkt);
            }
        }
        finally {
            pkt.reset();
        }
    }

    public void acknowledge(ReadWritePacket pkt) throws JMSException {
        pkt.setPacketType(24);
        if (pkt.getSendAcknowledge() && this.ackAck) {
            ReadOnlyPacket ack = this.writePacketWithReply(pkt, 25);
            int statusCode = ProtocolHandler.getReplyStatus(ack);
            if (statusCode == 200) {
                return;
            }
            this.checkRemoteFailedStatus(statusCode, ack);
            this.throwServerErrorException(ack);
        } else {
            pkt.setSendAcknowledge(false);
            this.writePacketNoAck(pkt);
        }
    }

    public void redeliver(ReadWritePacket pkt, boolean flag, boolean isTransacted) throws JMSException {
        long tid;
        pkt.setPacketType(32);
        Hashtable<String, Comparable<Boolean>> props = new Hashtable<String, Comparable<Boolean>>(1);
        props.put("JMQSetRedelivered", Boolean.valueOf(flag));
        if (isTransacted && (tid = pkt.getTransactionID()) > 0L) {
            props.put("JMQTransactionID", Long.valueOf(tid));
        }
        pkt.setProperties(props);
        this.writePacketNoAck(pkt);
    }

    public long startTransaction(long transactionID, int xaflags, JMQXid xid) throws JMSException {
        return this.startTransaction(transactionID, xaflags, xid, false, 0L);
    }

    public long startTransaction(long transactionID, int xaflags, JMQXid xid, long brokerSessionID) throws JMSException {
        return this.startTransaction(transactionID, xaflags, xid, true, brokerSessionID);
    }

    public long startTransaction(long transactionID, int xaflags, JMQXid xid, boolean setSessionID, long brokerSessionID) throws JMSException {
        ReadWritePacket pkt = new ReadWritePacket();
        ByteArrayOutputStream byteArrayOutputStream = null;
        DataOutputStream dos = null;
        byte[] xidBody = null;
        pkt.setPacketType(44);
        Hashtable<String, Number> ht = new Hashtable<String, Number>(1);
        if (setSessionID) {
            ht.put("JMQSessionID", brokerSessionID);
        }
        if (this.twoPhaseCommitFlag) {
            ht.put("JMQAutoRollback", 2);
        }
        if (xaflags != -1) {
            ht.put("JMQXAFlags", xaflags);
            if (xid != null) {
                try {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    dos = new DataOutputStream(byteArrayOutputStream);
                    xid.write(dos);
                    dos.flush();
                    xidBody = byteArrayOutputStream.toByteArray();
                    dos.close();
                    byteArrayOutputStream.close();
                    pkt.setMessageBody(xidBody);
                }
                catch (IOException ioe) {
                    ExceptionHandler.handleException((Exception)ioe, "C4038");
                }
            }
        }
        pkt.setProperties(ht);
        int statusCode = -1;
        ReadOnlyPacket replypkt = this.writePacketWithReply(pkt, 45);
        try {
            Hashtable replyProps = replypkt.getProperties();
            Integer value = (Integer)replyProps.get("JMQStatus");
            statusCode = value;
            Long lvalue = (Long)replyProps.get("JMQTransactionID");
            if (lvalue != null) {
                transactionID = lvalue;
            }
        }
        catch (IOException e) {
            ExceptionHandler.handleException(e, "C4000", true);
        }
        catch (ClassNotFoundException e) {
            ExceptionHandler.handleException(e, "C4000", true);
        }
        if (statusCode == 409) {
            String errorString = AdministeredObject.cr.getKString("C4028", transactionID) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new com.sun.messaging.jms.JMSException(errorString, "C4028"));
        }
        if (statusCode != 200) {
            this.throwServerErrorException(replypkt);
        }
        return transactionID;
    }

    public void endTransaction(long transactionID, int xaflags, JMQXid xid) throws JMSException {
        this.endTransaction(transactionID, false, xaflags, xid);
    }

    public void endTransaction(long transactionID, boolean jmqnoop, int xaflags, JMQXid xid) throws JMSException {
        ReadWritePacket pkt = new ReadWritePacket();
        ByteArrayOutputStream byteArrayOutputStream = null;
        DataOutputStream dos = null;
        byte[] xidBody = null;
        pkt.setPacketType(58);
        Hashtable<String, Serializable> ht = new Hashtable<String, Serializable>(1);
        if (transactionID != 0L) {
            ht.put("JMQTransactionID", Long.valueOf(transactionID));
        }
        if (xaflags != -1) {
            ht.put("JMQXAFlags", Integer.valueOf(xaflags));
            if (xid != null) {
                try {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    dos = new DataOutputStream(byteArrayOutputStream);
                    xid.write(dos);
                    dos.flush();
                    xidBody = byteArrayOutputStream.toByteArray();
                    dos.close();
                    byteArrayOutputStream.close();
                    pkt.setMessageBody(xidBody);
                }
                catch (IOException ioe) {
                    ExceptionHandler.handleException((Exception)ioe, "C4038");
                }
            }
        }
        if (jmqnoop) {
            ht.put("JMQNoOp", Boolean.valueOf(jmqnoop));
        }
        pkt.setProperties(ht);
        int statusCode = -1;
        ReadOnlyPacket replypkt = this.writePacketWithReply(pkt, 59);
        try {
            Hashtable replyProps = replypkt.getProperties();
            Integer value = (Integer)replyProps.get("JMQStatus");
            statusCode = value;
        }
        catch (IOException e) {
            ExceptionHandler.handleException(e, "C4000", true);
        }
        catch (ClassNotFoundException e) {
            ExceptionHandler.handleException(e, "C4000", true);
        }
        if (statusCode != 200) {
            this.throwServerErrorException(replypkt);
        }
    }

    public JMQXid[] recover(int xaflags) throws JMSException {
        JMQXid[] xids;
        byte[] body;
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setPacketType(60);
        Hashtable<String, Integer> ht = new Hashtable<String, Integer>(1);
        ht.put("JMQXAFlags", xaflags);
        pkt.setProperties(ht);
        int statusCode = -1;
        int quantity = 0;
        ReadOnlyPacket replypkt = this.writePacketWithReply(pkt, 61);
        try {
            Hashtable replyProps = replypkt.getProperties();
            Integer value = (Integer)replyProps.get("JMQStatus");
            statusCode = value;
            value = (Integer)replyProps.get("JMQQuantity");
            quantity = value;
        }
        catch (IOException e) {
            ExceptionHandler.handleException(e, "C4000", true);
        }
        catch (ClassNotFoundException e) {
            ExceptionHandler.handleException(e, "C4000", true);
        }
        if (statusCode != 200) {
            this.throwServerErrorException(replypkt);
        }
        if ((body = ((ReadWritePacket)replypkt).getMessageBody()) == null || body.length == 0) {
            xids = new JMQXid[]{};
        } else {
            int return_qty = body.length / JMQXid.size();
            if (body.length % JMQXid.size() != 0 || return_qty != quantity) {
                ExceptionHandler.handleException(new StreamCorruptedException(), "C4002", true);
            }
            xids = new JMQXid[quantity];
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(body));
            for (int i = 0; i < quantity; ++i) {
                try {
                    xids[i] = JMQXid.read(dis);
                    continue;
                }
                catch (IOException ioe) {
                    ExceptionHandler.handleException(ioe, "C4002", true);
                }
            }
        }
        return xids;
    }

    public void endHATransaction(long transactionID) throws JMSException {
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setPacketType(58);
        Hashtable<String, Number> ht = new Hashtable<String, Number>(1);
        if (transactionID != 0L) {
            ht.put("JMQTransactionID", transactionID);
        }
        ht.put("JMQXAFlags", 0x4000000);
        pkt.setProperties(ht);
        ReadOnlyPacket replypkt = this.writePacketWithReply(pkt, 59);
        int statusCode = -1;
        Hashtable replyProps = ProtocolHandler.getReplyProperties(replypkt);
        Integer value = (Integer)replyProps.get("JMQStatus");
        if (value != null) {
            statusCode = value;
        }
        if (statusCode != 200 && statusCode != 304) {
            String errorString = AdministeredObject.cr.getKString("C4104", String.valueOf(transactionID), String.valueOf(statusCode)) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new com.sun.messaging.jms.JMSException(errorString, "C4104"));
        }
    }

    public void prepareHATransaction(long transactionID) throws JMSException {
        int statusCode = -1;
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setPacketType(56);
        Hashtable<String, Long> ht = new Hashtable<String, Long>(1);
        ht.put("JMQTransactionID", transactionID);
        pkt.setProperties(ht);
        ReadOnlyPacket ack = this.writePacketWithReply(pkt, 57);
        Hashtable replyProps = ProtocolHandler.getReplyProperties(ack);
        Integer value = (Integer)replyProps.get("JMQStatus");
        if (value != null) {
            statusCode = value;
        }
        if (statusCode != 200 && statusCode != 304) {
            this.checkRemoteFailedStatus(statusCode, ack);
            String errorString = AdministeredObject.cr.getKString("C4101", String.valueOf(transactionID), String.valueOf(statusCode)) + this.getUserBrokerInfo();
            Loggable jmse = null;
            jmse = statusCode == 408 ? new TransactionRolledBackException(errorString, "C4101") : new com.sun.messaging.jms.JMSException(errorString, "C4101");
            ExceptionHandler.throwJMSException((JMSException)((Object)jmse));
        }
    }

    public void commitHATransaction(long transactionID) throws JMSException {
        int statusCode = -1;
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setPacketType(46);
        Hashtable<String, Long> ht = new Hashtable<String, Long>(1);
        ht.put("JMQTransactionID", transactionID);
        pkt.setProperties(ht);
        ReadOnlyPacket ack = null;
        ack = this.writePacketWithReply(pkt, 47);
        statusCode = ProtocolHandler.getReplyStatus(ack);
        switch (statusCode) {
            case 200: {
                return;
            }
            case 408: {
                ExceptionHandler.throwJMSException((JMSException)((Object)new TransactionRolledBackException("Timeout")));
            }
            case 410: {
                this.checkRemoteFailedStatus(statusCode, ack);
            }
        }
        Debug.getPrintStream().println("**** Tranaction ERROR, statusCode " + statusCode);
        this.throwServerErrorException(ack);
    }

    public int verifyHATransaction(long transactionID, int tstate) throws JMSException {
        return this.verifyHATransaction(transactionID, tstate, null);
    }

    public int verifyHATransaction(long transactionID, int tstate, JMQXid xid) throws JMSException {
        Hashtable replyBody;
        Integer tmp;
        ReadWritePacket pkt = new ReadWritePacket();
        ByteArrayOutputStream byteArrayOutputStream = null;
        DataOutputStream dos = null;
        byte[] xidBody = null;
        pkt.setPacketType(78);
        Hashtable<String, Long> ht = new Hashtable<String, Long>(1);
        ht.put("JMQTransactionID", transactionID);
        if (xid != null) {
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                dos = new DataOutputStream(byteArrayOutputStream);
                xid.write(dos);
                dos.flush();
                xidBody = byteArrayOutputStream.toByteArray();
                dos.close();
                byteArrayOutputStream.close();
                pkt.setMessageBody(xidBody);
            }
            catch (IOException ioe) {
                ExceptionHandler.handleException((Exception)ioe, "C4038");
            }
        }
        pkt.setProperties(ht);
        int statusCode = -1;
        int transactionState = -1;
        ReadOnlyPacket replypkt = this.writePacketWithReply(pkt, 79);
        Hashtable replyProps = ProtocolHandler.getReplyProperties(replypkt);
        Integer value = (Integer)replyProps.get("JMQStatus");
        statusCode = value;
        if (statusCode == 200 && (tmp = (Integer)(replyBody = ReadChannel.getHashtableFromMessageBody(replypkt)).get("State")) != null) {
            transactionState = tmp;
        }
        if (statusCode == 404) {
            if (tstate == 1) {
                transactionState = 8;
            } else if (tstate == 2) {
                transactionState = 7;
            }
        } else if (statusCode != 200) {
            this.throwServerErrorException(replypkt);
        }
        if (this.debug) {
            Debug.println(new Date().toString() + " transaction state: " + transactionState);
        }
        return transactionState;
    }

    public void prepare(long transactionID, JMQXid xid) throws JMSException {
        this.prepare(transactionID, xid, false);
    }

    public void prepare(long transactionID, JMQXid xid, boolean onePhase) throws JMSException {
        ReadWritePacket pkt = new ReadWritePacket();
        ByteArrayOutputStream byteArrayOutputStream = null;
        DataOutputStream dos = null;
        byte[] xidBody = null;
        pkt.setPacketType(56);
        Hashtable<String, Constable> ht = null;
        if (transactionID != 0L) {
            ht = new Hashtable<String, Constable>(1);
            ht.put("JMQTransactionID", Long.valueOf(transactionID));
        }
        if (onePhase) {
            if (ht == null) {
                ht = new Hashtable(1);
            }
            ht.put("JMQXAOnePhase", Boolean.TRUE);
        }
        if (ht != null) {
            pkt.setProperties(ht);
        }
        if (xid != null) {
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                dos = new DataOutputStream(byteArrayOutputStream);
                xid.write(dos);
                dos.flush();
                xidBody = byteArrayOutputStream.toByteArray();
                dos.close();
                byteArrayOutputStream.close();
                pkt.setMessageBody(xidBody);
            }
            catch (IOException ioe) {
                ExceptionHandler.handleException((Exception)ioe, "C4038");
            }
        }
        int statusCode = -1;
        ReadOnlyPacket replypkt = this.writePacketWithReply(pkt, 57);
        try {
            Hashtable replyProps = replypkt.getProperties();
            Integer value = (Integer)replyProps.get("JMQStatus");
            statusCode = value;
        }
        catch (IOException e) {
            ExceptionHandler.handleException(e, "C4000", true);
        }
        catch (ClassNotFoundException e) {
            ExceptionHandler.handleException(e, "C4000", true);
        }
        if (statusCode != 200) {
            this.checkRemoteFailedStatus(statusCode, replypkt);
            this.throwServerErrorException(replypkt);
        }
    }

    public Hashtable getLicense() throws JMSException {
        Hashtable licenseProps = null;
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setPacketType(76);
        int statusCode = -1;
        ReadOnlyPacket replypkt = this.writePacketWithReply(pkt, 77);
        try {
            licenseProps = replypkt.getProperties();
            Integer value = (Integer)licenseProps.get("JMQStatus");
            statusCode = value;
        }
        catch (IOException ioe) {
            ExceptionHandler.handleException(ioe, "C4000", true);
        }
        catch (ClassNotFoundException cnfe) {
            ExceptionHandler.handleException(cnfe, "C4000", true);
        }
        if (statusCode != 200) {
            this.throwServerErrorException(replypkt);
        }
        return licenseProps;
    }

    public long generateUID() throws JMSException {
        long globalUID = 0L;
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setPacketType(62);
        int statusCode = -1;
        ReadOnlyPacket replypkt = this.writePacketWithReply(pkt, 63);
        try {
            Hashtable replyProps = replypkt.getProperties();
            Integer value = (Integer)replyProps.get("JMQQuantity");
            value = (Integer)replyProps.get("JMQStatus");
            statusCode = value;
        }
        catch (IOException ioe) {
            ExceptionHandler.handleException(ioe, "C4000", true);
        }
        catch (ClassNotFoundException cnfe) {
            ExceptionHandler.handleException(cnfe, "C4000", true);
        }
        if (statusCode != 200) {
            this.throwServerErrorException(replypkt);
        }
        byte[] data = ((ReadWritePacket)replypkt).getMessageBody();
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(data));
        try {
            globalUID = is.readLong();
        }
        catch (IOException ioe2) {
            ExceptionHandler.handleException(ioe2, "C4002", true);
        }
        return globalUID;
    }

    public void rollback(long transactionID, JMQXid xid) throws JMSException {
        this._rollbackXA(transactionID, xid, false, false);
    }

    public void rollback(long transactionID, JMQXid xid, boolean redeliver) throws JMSException {
        this._rollbackXA(transactionID, xid, redeliver, false);
    }

    public void rollback(long transactionID, JMQXid xid, boolean redeliver, boolean setIBit) throws JMSException {
        this._rollbackXA(transactionID, xid, redeliver, setIBit);
    }

    private void _rollbackXA(long transactionID, JMQXid xid, boolean setJMQRedeliver, boolean setIBit) throws JMSException {
        this.rollbackXA(transactionID, xid, setJMQRedeliver, setIBit, -1, false);
    }

    public void rollbackXA(long transactionID, JMQXid xid, boolean setJMQRedeliver, boolean setIBit, int maxRollbacks, boolean dmqOnMaxRollbacks) throws JMSException {
        ReadWritePacket pkt = new ReadWritePacket();
        ByteArrayOutputStream byteArrayOutputStream = null;
        DataOutputStream dos = null;
        byte[] xidBody = null;
        Hashtable<String, Constable> ht = null;
        pkt.setPacketType(48);
        if (setIBit) {
            pkt.setIndempotent(true);
        }
        if (transactionID != 0L || setJMQRedeliver || maxRollbacks > 0) {
            int htsz = 0;
            if (maxRollbacks > 0) {
                htsz = 2;
            }
            if (transactionID != 0L) {
                ++htsz;
            }
            if (setJMQRedeliver) {
                ++htsz;
            }
            ht = new Hashtable<String, Constable>(htsz);
            if (transactionID != 0L) {
                ht.put("JMQTransactionID", Long.valueOf(transactionID));
            }
            if (setJMQRedeliver) {
                ht.put("JMQRedeliver", Boolean.valueOf(setJMQRedeliver));
            }
            if (maxRollbacks > 0) {
                ht.put("JMQMaxRollbacks", Integer.valueOf(maxRollbacks));
                ht.put("JMQDMQOnMaxRollbacks", Boolean.valueOf(dmqOnMaxRollbacks));
            }
            pkt.setProperties(ht);
        }
        if (xid != null) {
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                dos = new DataOutputStream(byteArrayOutputStream);
                xid.write(dos);
                dos.flush();
                xidBody = byteArrayOutputStream.toByteArray();
                dos.close();
                byteArrayOutputStream.close();
                pkt.setMessageBody(xidBody);
            }
            catch (IOException ioe) {
                ExceptionHandler.handleException((Exception)ioe, "C4038");
            }
        }
        ReadOnlyPacket ack = this.writePacketWithReply(pkt, 49);
        int statusCode = ProtocolHandler.getReplyStatus(ack);
        if (statusCode == 400) {
            String errorString = AdministeredObject.cr.getKString("C4027", transactionID) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new com.sun.messaging.jms.JMSException(errorString, "C4027"));
        }
        if (statusCode != 200) {
            this.throwServerErrorException(ack);
        }
    }

    public long commit(long transactionID, int xaflags, JMQXid xid) throws JMSException {
        return this.commit(transactionID, xaflags, xid, false);
    }

    public long commit(long transactionID, int xaflags, JMQXid xid, boolean onePhasePropRequired) throws JMSException {
        long nextTransactionID = -1L;
        ReadWritePacket pkt = new ReadWritePacket();
        ByteArrayOutputStream byteArrayOutputStream = null;
        DataOutputStream dos = null;
        byte[] xidBody = null;
        pkt.setPacketType(46);
        Hashtable<String, Constable> ht = new Hashtable<String, Constable>(1);
        if (transactionID != 0L) {
            ht.put("JMQTransactionID", Long.valueOf(transactionID));
        }
        if (onePhasePropRequired) {
            ht.put("JMQXAOnePhase", Boolean.TRUE);
        }
        if (SessionImpl.autoStartTxn) {
            ht.put("JMQStartNextTransaction", Boolean.TRUE);
        }
        if (xid != null) {
            ht.put("JMQXAFlags", Integer.valueOf(xaflags));
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                dos = new DataOutputStream(byteArrayOutputStream);
                xid.write(dos);
                dos.flush();
                xidBody = byteArrayOutputStream.toByteArray();
                dos.close();
                byteArrayOutputStream.close();
                pkt.setMessageBody(xidBody);
            }
            catch (IOException ioe) {
                ExceptionHandler.handleException((Exception)ioe, "C4038");
            }
        }
        pkt.setProperties(ht);
        ReadOnlyPacket ack = this.writePacketWithReply(pkt, 47);
        int statusCode = ProtocolHandler.getReplyStatus(ack);
        nextTransactionID = ProtocolHandler.getNextTransactionID(ack);
        if (statusCode == 200) {
            return nextTransactionID;
        }
        if (statusCode == 400) {
            String errorString = AdministeredObject.cr.getKString("C4027", transactionID) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new com.sun.messaging.jms.JMSException(errorString, "C4027"));
        }
        this.checkRemoteFailedStatus(statusCode, ack);
        this.throwServerErrorException(ack);
        return nextTransactionID;
    }

    public void rollback(long transactionID) throws JMSException {
        this.rollback(transactionID, false);
    }

    public void rollback(long transactionID, boolean updateConsumed) throws JMSException {
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setPacketType(48);
        Hashtable<String, Constable> ht = new Hashtable<String, Constable>(1);
        ht.put("JMQTransactionID", Long.valueOf(transactionID));
        if (updateConsumed) {
            ht.put("JMQUpdateConsumed", Boolean.valueOf(true));
        }
        pkt.setProperties(ht);
        this.writePacketNoAck(pkt);
    }

    protected void verifyDestination(javax.jms.Destination destination, String selector, boolean browser) throws JMSException {
        String errorString;
        Destination dest = (Destination)destination;
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setPacketType(40);
        Hashtable<String, Object> props = new Hashtable<String, Object>(3);
        props.put("JMQDestination", dest.getName());
        props.put("JMQDestType", this.getDestinationType(dest));
        if (selector != null && selector.trim().length() == 0) {
            selector = null;
        }
        if (selector != null) {
            props.put("JMQSelector", selector);
        }
        pkt.setProperties(props);
        ReadOnlyPacket pktrev = this.writePacketWithReply(pkt, 41);
        int statusCode = -1;
        try {
            Boolean autoCreate;
            Hashtable propsrev = pktrev.getProperties();
            statusCode = (Integer)propsrev.get("JMQStatus");
            if (browser && statusCode == 404 && (autoCreate = (Boolean)propsrev.get("JMQCanCreate")) != null && autoCreate.booleanValue()) {
                return;
            }
        }
        catch (IOException e) {
            ExceptionHandler.handleException(e, "C4000", true);
        }
        catch (ClassNotFoundException e) {
            ExceptionHandler.handleException(e, "C4000", true);
        }
        if (statusCode == 400 && selector != null) {
            errorString = AdministeredObject.cr.getKString("C4022", selector) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((JMSException)((Object)new InvalidSelectorException(errorString, "C4022")));
        }
        if (statusCode == 404) {
            errorString = AdministeredObject.cr.getKString("C4019", dest.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((JMSException)((Object)new InvalidDestinationException(errorString, "C4019")));
        }
        if (statusCode == 403) {
            errorString = AdministeredObject.cr.getKString("C4082", dest.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((JMSException)((Object)new JMSSecurityException(errorString, "C4082")));
        }
        if (statusCode != 200) {
            this.throwServerErrorException(pktrev);
        }
    }

    protected SysMessageID[] browse(Consumer consumer) throws JMSException {
        SysMessageID[] ids;
        byte[] data;
        String errorString;
        Destination dest = (Destination)consumer.getDestination();
        String selector = consumer.getMessageSelector();
        if (selector != null && selector.trim().length() == 0) {
            selector = null;
        }
        ReadWritePacket pktsend = new ReadWritePacket();
        pktsend.setPacketType(26);
        Hashtable<String, Object> props = new Hashtable<String, Object>(2);
        props.put("JMQDestination", dest.getName());
        props.put("JMQDestType", this.getDestinationType(dest));
        if (selector != null) {
            props.put("JMQSelector", selector);
        }
        props.put(REQUEST_META_DATA, consumer);
        pktsend.setProperties(props);
        ReadOnlyPacket pktrev = this.writePacketWithReply(pktsend, 27);
        int statusCode = -1;
        try {
            Boolean autoCreate;
            Hashtable propsrev = pktrev.getProperties();
            statusCode = (Integer)propsrev.get("JMQStatus");
            if (statusCode == 404 && (autoCreate = (Boolean)propsrev.get("JMQCanCreate")) != null && autoCreate.booleanValue()) {
                return new SysMessageID[0];
            }
        }
        catch (IOException e) {
            ExceptionHandler.handleException(e, "C4000", true);
        }
        catch (ClassNotFoundException e) {
            ExceptionHandler.handleException(e, "C4000", true);
        }
        if (statusCode == 400 && selector != null) {
            errorString = AdministeredObject.cr.getKString("C4022", selector) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((JMSException)((Object)new InvalidSelectorException(errorString, "C4022")));
        }
        if (statusCode == 404) {
            errorString = AdministeredObject.cr.getKString("C4019", dest.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((JMSException)((Object)new InvalidDestinationException(errorString, "C4019")));
        }
        if (statusCode == 403) {
            errorString = AdministeredObject.cr.getKString("C4083", dest.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((JMSException)((Object)new JMSSecurityException(errorString, "C4083")));
        }
        if (statusCode != 200) {
            this.throwServerErrorException(pktrev);
        }
        if ((data = ((ReadWritePacket)pktrev).getMessageBody()) == null || data.length == 0) {
            ids = new SysMessageID[]{};
        } else {
            if (data.length % 32 != 0) {
                ExceptionHandler.handleException(new StreamCorruptedException(), "C4002", true);
            }
            int numItems = data.length / 32;
            ids = new SysMessageID[numItems];
            DataInputStream is = new DataInputStream(new ByteArrayInputStream(data));
            for (int i = 0; i < numItems; ++i) {
                ids[i] = new SysMessageID();
                try {
                    ids[i].readID(is);
                    continue;
                }
                catch (IOException e) {
                    ExceptionHandler.handleException(e, "C4002", true);
                }
            }
        }
        return ids;
    }

    protected boolean deliver(ByteArrayOutputStream bos, Consumer consumer) throws JMSException {
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setMessageBody(bos.toByteArray());
        pkt.setPacketType(42);
        Hashtable<String, Long> props = new Hashtable<String, Long>(1);
        props.put("JMQConsumerID", consumer.getInterestId());
        pkt.setProperties(props);
        ReadOnlyPacket ack = this.writePacketWithReply(pkt, 43);
        int statusCode = ProtocolHandler.getReplyStatus(ack);
        if (statusCode == 404) {
            return false;
        }
        if (statusCode == 200) {
            return true;
        }
        this.throwServerErrorException(ack);
        return false;
    }

    public void suspendMessageDelivery() throws JMSException {
        this.stop();
    }

    public void resumeMessageDelivery() throws JMSException {
        this.start();
    }

    public void createSession(SessionImpl session) throws JMSException {
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setPacketType(68);
        if (!session.isTransacted) {
            Hashtable<String, Integer> props = new Hashtable<String, Integer>(1);
            props.put("JMQAckMode", session.acknowledgeMode);
            pkt.setProperties(props);
        }
        ReadOnlyPacket reply = this.writePacketWithReply(pkt, 69);
        int statusCode = -1;
        long sessionID = -1L;
        try {
            Hashtable replyProps = reply.getProperties();
            statusCode = (Integer)replyProps.get("JMQStatus");
            Long jmqSIDProp = (Long)replyProps.get("JMQSessionID");
            if (jmqSIDProp != null) {
                sessionID = jmqSIDProp;
            }
        }
        catch (IOException e) {
            ExceptionHandler.handleException(e, "C4000", true);
        }
        catch (ClassNotFoundException e) {
            ExceptionHandler.handleException(e, "C4000", true);
        }
        if (statusCode != 200) {
            this.throwServerErrorException(reply);
        }
        session.setBrokerSessionID(sessionID);
        if (this.debug) {
            Debug.println("Added session, JMQSessionID: " + session.getBrokerSessionID());
        }
    }

    public void deleteSession(SessionImpl session) throws JMSException {
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setPacketType(70);
        Hashtable<String, Long> props = new Hashtable<String, Long>(1);
        props.put("JMQSessionID", session.getBrokerSessionID());
        pkt.setProperties(props);
        ReadOnlyPacket ack = this.writePacketWithReply(pkt, 71);
        int statusCode = ProtocolHandler.getReplyStatus(ack);
        if (statusCode != 200) {
            this.throwServerErrorException(ack);
        }
    }

    protected static long getNextTransactionID(ReadOnlyPacket ack) throws JMSException {
        long nextTransactionID = -1L;
        Hashtable ackProperties = ProtocolHandler.getReplyProperties(ack);
        Long value = (Long)ackProperties.get("JMQNextTransactionID");
        if (value != null) {
            nextTransactionID = value;
        }
        return nextTransactionID;
    }

    protected static int getReplyStatus(ReadOnlyPacket ack) throws JMSException {
        int statusCode = -1;
        Hashtable ackProperties = ProtocolHandler.getReplyProperties(ack);
        Integer value = (Integer)ackProperties.get("JMQStatus");
        statusCode = value;
        return statusCode;
    }

    protected static Hashtable getReplyProperties(ReadOnlyPacket ack) throws JMSException {
        Hashtable ackProperties = null;
        try {
            ackProperties = ack.getProperties();
        }
        catch (IOException e) {
            ExceptionHandler.handleException(e, "C4005", true);
        }
        catch (ClassNotFoundException e) {
            ExceptionHandler.handleException(e, "C4005", true);
        }
        return ackProperties;
    }

    protected void checkReplyType(ReadOnlyPacket ack, int expectedType) throws JMSException {
        int receivedType = ack.getPacketType();
        if (receivedType != expectedType) {
            String errorString = AdministeredObject.cr.getKString("C4093", PacketType.getString(expectedType), PacketType.getString(receivedType)) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new com.sun.messaging.jms.JMSException(errorString, "C4093"));
        }
    }

    private void throwServerErrorException(ReadOnlyPacket ack) throws JMSException {
        ProtocolHandler.throwServerErrorException(ack, this);
    }

    private static void throwServerErrorException(ReadOnlyPacket ack, ProtocolHandler ph) throws JMSException {
        com.sun.messaging.jms.JMSException serverex;
        String errorString;
        Integer statusCode;
        block5: {
            statusCode = 0;
            errorString = AdministeredObject.cr.getKString("C4036");
            serverex = null;
            try {
                Hashtable properties = ProtocolHandler.getReplyProperties(ack);
                String reason = (String)properties.get("JMQReason");
                statusCode = (Integer)properties.get("JMQStatus");
                if (reason != null) {
                    int type = ack.getPacketType();
                    String pktName = PacketType.getString(type);
                    errorString = "[" + pktName + "] " + errorString + " :[" + statusCode + "] " + reason;
                }
                errorString = errorString + ph.getUserBrokerInfo();
                if (statusCode != null) {
                    serverex = new com.sun.messaging.jms.JMSException(errorString, Status.getString(statusCode));
                }
            }
            catch (Exception e) {
                if (!ph.debug) break block5;
                Debug.printStackTrace(e);
            }
        }
        com.sun.messaging.jms.JMSException jmse = new com.sun.messaging.jms.JMSException(errorString, "C4036");
        if (serverex != null) {
            jmse.setLinkedException((Exception)((Object)serverex));
        }
        Level level = statusCode == 505 ? Level.FINE : Level.WARNING;
        ExceptionHandler.throwJMSException(level, jmse);
    }

    public void checkRemoteFailedStatus(int statusCode, ReadOnlyPacket ack) throws JMSException {
        if (statusCode == 200) {
            return;
        }
        Hashtable replyProps = ProtocolHandler.getReplyProperties(ack);
        if (replyProps == null) {
            return;
        }
        Boolean value = (Boolean)replyProps.get("JMQRemote");
        if (value != null && value.booleanValue() && statusCode == 410) {
            String errorString = AdministeredObject.cr.getKString("C4110");
            RemoteAcknowledgeException raex = new RemoteAcknowledgeException(errorString, "C4110");
            raex.setProperties(replyProps);
            ExceptionHandler.throwJMSException(raex);
        }
        if ((value = (Boolean)replyProps.get("JMQPrepareStateFAILED")) != null && value.booleanValue()) {
            Long tid = (Long)replyProps.get("JMQTransactionID");
            String errorString = AdministeredObject.cr.getKString("C4305", tid == null ? "" : String.valueOf(tid));
            TransactionPrepareStateFAILEDException be = new TransactionPrepareStateFAILEDException(errorString, "C4305");
            ExceptionHandler.throwJMSException(be);
        }
    }

    public void abort() {
        try {
            this.connectionHandler.close();
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            Debug.printStackTrace(e);
        }
    }

    public void ping() throws JMSException {
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setPacketType(54);
        if (this.imqAbortOnPingAckTimeout && this.pingTimeout > 0) {
            pkt.setFlag(16, true);
            this.setPingTimeStamp();
        }
        this.writePacketNoAck(pkt);
    }

    public void pingReply(ReadOnlyPacket ping) throws JMSException {
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setPacketType(55);
        long consumerID = ping.getConsumerID();
        pkt.setConsumerID(consumerID);
        Hashtable<String, Integer> props = new Hashtable<String, Integer>(1);
        props.put("JMQStatus", 200);
        pkt.setProperties(props);
        this.writePacketNoAck(pkt);
    }

    public ConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    protected String getUserBrokerInfo() {
        return ProtocolHandler.getUserBrokerInfo(this);
    }

    private static String getUserBrokerInfo(ProtocolHandler ph) {
        String lname = ph.connection.getUserName();
        if (lname == null) {
            lname = "null";
        } else if (lname.length() == 0) {
            lname = "empty/blank";
        }
        String info = null;
        info = ph.connectionHandler == null ? "unavailable" : ph.connectionHandler.getBrokerAddress();
        return " user=" + lname + ", broker=" + info;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void redirect(String url) throws JMSException {
        block4: {
            if (this.debug) {
                Debug.info("ProtocolHandler: redirect connection to the URL : " + url);
            }
            try {
                this.close();
            }
            catch (Exception e) {
                ExceptionHandler.logCaughtException(e);
                if (!this.debug) break block4;
                Debug.printStackTrace(e);
            }
        }
        this.connection.initiator.setRedirectURL(url);
        this.init(true);
        if (this.debug) {
            Debug.info("*** ProtocolHandler: connection redirected to the URL: " + url);
        }
    }

    public void resend(ReadWritePacket pkt) throws JMSException {
        pkt.setFlag(2048, true);
        this.writePacketNoAck(pkt);
    }

    public void setDebugInboundPkt(boolean flag) {
        this.debugInboundPkt = flag;
    }

    public void setDebugOutboundPkt(boolean flag) {
        this.debugOutboundPkt = flag;
    }

    public void setPktFilter(String filterSpec) {
        this.pktFilter = filterSpec;
    }

    protected boolean isClientIDsent() {
        return this.sentSetClientID;
    }

    public boolean isDirectMode() {
        return this.connectionHandler.isDirectMode();
    }

    public boolean isDirectModeTwoThread() {
        return this.isDirectMode() && BrokerInstanceImpl.isTwoThread;
    }

    public boolean isDirectModeTwoThreadWithSyncReplies() {
        return this.isDirectModeTwoThread() && BrokerInstanceImpl.isTwoThreadSyncReplies;
    }

    public String toString() {
        return this.connectionHandler.toString();
    }

    private void setXMLValidation(Destination dest, ReadOnlyPacket ack) throws JMSException {
        if (turnOffXMLValidation) {
            return;
        }
        try {
            Hashtable ackProperties = ProtocolHandler.getReplyProperties(ack);
            Object validateObj = ackProperties.get("JMQValidateXMLSchema");
            boolean shouldValidate = false;
            if (validateObj != null) {
                shouldValidate = (Boolean)validateObj;
            }
            if (shouldValidate) {
                XMLValidator validator = null;
                String xsdURIList = null;
                Object uriobj = ackProperties.get("JMQXMLSchemaURIList");
                if (uriobj != null) {
                    xsdURIList = (String)uriobj;
                    validator = ValidatorFactory.newValidator(xsdURIList);
                    Object reloadObj = ackProperties.get("JMQReloadXMLSchemaOnFailure");
                    if (reloadObj != null) {
                        boolean doReload = (Boolean)reloadObj;
                        validator.setReloadOnFailure(doReload);
                    }
                } else {
                    validator = ValidatorFactory.newValidator();
                }
                if (!this.xmlValidationTable.containsKey(dest)) {
                    this.xmlValidationTable.put(dest, validator);
                    if (this.debug) {
                        Debug.println("Adding xml validation entry for destination: " + dest.getName() + ", uriList: " + xsdURIList);
                    }
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4005", true);
        }
    }

    public void setReplyDispatcher(PacketDispatcher rd) {
        if (this.isDirectModeTwoThread()) {
            ((DirectConnectionHandler)this.connectionHandler).setReplyDispatcher(rd);
        }
    }

    public long getConnID() {
        if (this.connection.isDirectMode()) {
            return this.connection.getConnectionID();
        }
        return this.getLocalPort();
    }
}

