/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.introspection;

import com.sun.enterprise.deployment.annotation.introspection.AnnotationScanner;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ConstantPoolInfo {
    byte[] bytes = new byte[Short.MAX_VALUE];
    private AnnotationScanner scanner = null;
    public static final byte CLASS = 7;
    public static final int FIELDREF = 9;
    public static final int METHODREF = 10;
    public static final int STRING = 8;
    public static final int INTEGER = 3;
    public static final int FLOAT = 4;
    public static final int LONG = 5;
    public static final int DOUBLE = 6;
    public static final int INTERFACEMETHODREF = 11;
    public static final int NAMEANDTYPE = 12;
    public static final int ASCIZ = 1;
    public static final int UNICODE = 2;
    public static final int METHOD_HANDLE = 15;
    public static final int METHOD_TYPE = 16;
    public static final int INVOKE_DYNAMIC = 18;

    public ConstantPoolInfo(AnnotationScanner scanner) {
        this.scanner = scanner;
    }

    public boolean containsAnnotation(int constantPoolSize, ByteBuffer buffer) throws IOException {
        block8: for (int i = 1; i < constantPoolSize; ++i) {
            byte type = buffer.get();
            switch (type) {
                case 1: 
                case 2: {
                    String stringValue;
                    short length = buffer.getShort();
                    if (length < 0 || length > Short.MAX_VALUE) {
                        return true;
                    }
                    buffer.get(this.bytes, 0, length);
                    if (this.bytes[0] != 76 || this.bytes[1] != 106 || this.bytes[2] != 97 || !this.scanner.isAnnotation(stringValue = type == 1 ? new String(this.bytes, 0, (int)length, "US-ASCII") : new String(this.bytes, 0, (int)length))) continue block8;
                    return true;
                }
                case 7: 
                case 8: 
                case 16: {
                    buffer.getShort();
                    continue block8;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: {
                    buffer.position(buffer.position() + 4);
                    continue block8;
                }
                case 5: 
                case 6: {
                    buffer.position(buffer.position() + 8);
                    ++i;
                    continue block8;
                }
                case 12: 
                case 18: {
                    buffer.getShort();
                    buffer.getShort();
                    continue block8;
                }
                case 15: {
                    buffer.get();
                    buffer.getShort();
                    continue block8;
                }
                default: {
                    DOLUtils.getDefaultLogger().severe("Unknown type constant pool " + type + " at position" + i);
                }
            }
        }
        return false;
    }
}

