/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.xml;

import com.sun.messaging.bridge.service.jms.xml.ConnectionFactoryElement;
import com.sun.messaging.bridge.service.jms.xml.DMQElement;
import com.sun.messaging.bridge.service.jms.xml.DestinationElement;
import com.sun.messaging.bridge.service.jms.xml.JMSBridgeElement;
import com.sun.messaging.bridge.service.jms.xml.JMSBridgeXMLConstant;
import com.sun.messaging.bridge.service.jms.xml.LinkElement;
import com.sun.messaging.bridge.service.jms.xml.TargetElement;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class JMSBridgeReader
extends DefaultHandler {
    private Logger _logger = null;
    private JMSBridgeElement _jmsbridge = null;
    private LinkElement _link = null;
    private DMQElement _dmq = null;
    private TargetElement _target = null;
    private Properties _attrs = null;
    private Properties _props = null;
    private String _refname = null;
    private String _xmlurl = null;

    public JMSBridgeReader(String url, String sysid, Logger logger) throws Exception {
        this._logger = logger;
        this._xmlurl = url;
        this.parseXML(url, sysid);
    }

    private void parseXML(String url, String sysid) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        InputStream is = null;
        try {
            SAXParser parser = factory.newSAXParser();
            is = new URL(url).openStream();
            parser.parse(is, this, sysid);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public JMSBridgeElement getJMSBridgeElement() {
        return this._jmsbridge;
    }

    @Override
    public void startDocument() throws SAXException {
        this._logger.log(Level.FINE, "Start parsing " + this._xmlurl);
    }

    @Override
    public void endDocument() throws SAXException {
        this._logger.log(Level.FINE, "End of parsing " + this._xmlurl);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String elemname = qName;
        String name = null;
        String attrName = null;
        String attrValue = null;
        String propName = null;
        String propValue = null;
        this._logger.log(Level.FINE, "startElement: uri=" + uri + ", localName=" + localName + ", qName=" + qName + ", attributes=" + attributes);
        try {
            if (elemname.equals("jmsbridge") || elemname.equals("connection-factory") || elemname.equals("link") || elemname.equals("source") || elemname.equals("target") || elemname.equals("destination") || elemname.equals("dmq")) {
                this._attrs = new Properties();
                this._props = new Properties();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    attrName = attributes.getQName(i);
                    attrValue = attributes.getValue(i);
                    this._logger.log(Level.FINE, "attr:" + attrName + "=" + attrValue);
                    this._attrs.put(attrName, attrValue);
                    if (attrName.equals("name")) {
                        name = attrValue;
                        JMSBridgeXMLConstant.checkReserved(name);
                        continue;
                    }
                    if (!attrName.equals("ref-name")) continue;
                    this._refname = attrValue;
                    JMSBridgeXMLConstant.checkReserved(name);
                }
                if (elemname.equals("jmsbridge")) {
                    if (this._jmsbridge != null) {
                        throw new SAXNotSupportedException("Multiple jmsbridge element is not allowed");
                    }
                    this._logger.log(Level.FINE, "jmsbridge: name=" + name);
                    this._jmsbridge = new JMSBridgeElement();
                    this._jmsbridge.setAttributes(this._attrs);
                } else if (elemname.equals("link")) {
                    this._logger.log(Level.FINE, "new link: name=" + name);
                    this._link = new LinkElement();
                    this._link.setAttributes(this._attrs);
                } else if (elemname.equals("target")) {
                    this._logger.log(Level.FINE, "target");
                    this._target = new TargetElement();
                    this._target.setAttributes(this._attrs);
                } else if (elemname.equals("dmq")) {
                    this._logger.log(Level.FINE, "new dmq: name=" + name);
                    this._dmq = new DMQElement();
                    this._dmq.setAttributes(this._attrs);
                }
            } else if (elemname.equals("property")) {
                propName = attributes.getValue(0);
                propValue = attributes.getValue(1);
                this._logger.log(Level.FINE, "prop:" + propName + "=" + propValue);
                this._props.put(propName, propValue);
            } else if (!elemname.equals("description")) {
                throw new SAXException("Unknow element " + elemname);
            }
        }
        catch (Exception e) {
            this._logger.log(Level.SEVERE, e.getMessage(), e);
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String elemname = qName;
        this._logger.log(Level.FINE, "startElement: uri=" + uri + ", localName=" + localName + ", qName=" + qName);
        try {
            if (elemname.equals("connection-factory")) {
                this._logger.log(Level.FINE, "add connection factory: " + this._refname);
                ConnectionFactoryElement ecf = new ConnectionFactoryElement();
                ecf.setAttributes(this._attrs);
                ecf.setProperties(this._props);
                this._jmsbridge.addCF(this._refname, ecf);
            } else if (elemname.equals("destination")) {
                this._logger.log(Level.FINE, "add destination: " + this._refname);
                DestinationElement de = new DestinationElement();
                de.setAttributes(this._attrs);
                de.setProperties(this._props);
                this._jmsbridge.addDestination(this._refname, de);
            } else if (elemname.equals("link")) {
                this._jmsbridge.addLink(this._link);
            } else if (elemname.equals("dmq")) {
                this._dmq.setProperties(this._props);
                this._jmsbridge.addDMQ(this._dmq);
            } else if (elemname.equals("source")) {
                this._logger.log(Level.FINE, "set source: " + this._attrs + " to " + this._link);
                this._link.setSource(this._attrs);
            } else if (elemname.equals("target")) {
                this._logger.log(Level.FINE, "set target: " + this._attrs + " to " + this._link);
                this._target.setProperties(this._props);
                this._link.setTarget(this._target);
            } else if (elemname.equals("jmsbridge")) {
                this._logger.log(Level.FINE, "End of Document");
            }
        }
        catch (Exception e) {
            this._logger.log(Level.SEVERE, e.getMessage(), e);
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        this._logger.log(Level.FINE, "XML Parser characters: " + String.valueOf(buf, offset, len));
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this._logger.log(Level.WARNING, e.getSystemId() + ", line " + e.getLineNumber() + ": " + e.getMessage());
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this._logger.log(Level.SEVERE, e.getSystemId() + ", line " + e.getLineNumber() + ": " + e.getMessage());
        throw e;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this._logger.log(Level.SEVERE, e.getSystemId() + ", line " + e.getLineNumber() + ": " + e.getMessage());
        super.fatalError(e);
        throw e;
    }
}

