/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.alert;

import fish.payara.monitoring.model.SeriesDataset;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public final class Condition
implements Serializable {
    private static final String FOR_TIMES = "forTimes";
    private static final String FOR_MILLIS = "forMillis";
    public static final Condition NONE = new Condition(Operator.EQ, 0L);
    public final Operator comparison;
    public final long threshold;
    public final Number forLast;
    public final boolean onAverage;

    public Condition(Operator comparison, long threshold) {
        this(comparison, threshold, null, false);
    }

    public Condition(Operator comparison, long threshold, Number forLast, boolean onAverage) {
        this.comparison = comparison;
        this.threshold = threshold;
        this.forLast = !onAverage && forLast instanceof Integer && forLast.intValue() == 1 ? null : forLast;
        this.onAverage = onAverage && forLast != null && forLast.longValue() > 0L;
    }

    public Condition forLastMillis(long millis) {
        return new Condition(this.comparison, this.threshold, millis, false);
    }

    public Condition forLastTimes(int times) {
        return new Condition(this.comparison, this.threshold, times, false);
    }

    public Condition onAverage() {
        return new Condition(this.comparison, this.threshold, this.forLast, true);
    }

    public boolean isNone() {
        return this == NONE || this.equalTo(NONE);
    }

    public boolean isForLastPresent() {
        return this.isForLastMillis() || this.isForLastTimes();
    }

    public boolean isForLastMillis() {
        return this.forLast instanceof Long;
    }

    public boolean isForLastTimes() {
        return this.forLast instanceof Integer;
    }

    public boolean isSatisfied(SeriesDataset data) {
        if (this.isNone()) {
            return true;
        }
        if (data.getObservedValues() == 0) {
            return false;
        }
        long value = data.lastValue();
        if (this.isForLastMillis()) {
            return this.isSatisfiedForLastMillis(data);
        }
        if (this.isForLastTimes()) {
            return this.isSatisfiedForLastTimes(data);
        }
        return this.compare(value);
    }

    private boolean isSatisfiedForLastMillis(SeriesDataset data) {
        int index;
        boolean all;
        long forLastMillis = Math.abs(this.forLast.longValue());
        if (forLastMillis == 0L) {
            return this.isSatisfiedForLastTimes(data.points(), 0);
        }
        boolean bl = all = this.forLast.longValue() > 0L;
        if (data.isStable() && all) {
            return data.getStableSince() <= data.lastTime() - forLastMillis && this.compare(data.lastValue());
        }
        long startTime = data.lastTime() - forLastMillis;
        long[] points = data.points();
        if (points[0] > startTime && forLastMillis < 30000L && all) {
            return false;
        }
        for (index = points.length - 2; index >= 0 && points[index] > startTime; index -= 2) {
        }
        int forLastTimes = index <= 0 ? points.length / 2 : (points.length - index) / 2;
        return this.isSatisfiedForLastTimes(points, (all ? 1 : -1) * forLastTimes);
    }

    private boolean isSatisfiedForLastTimes(SeriesDataset data) {
        int forLastTimes = this.forLast.intValue();
        if (data.isStable() && forLastTimes > 0) {
            return data.getStableCount() >= Math.abs(forLastTimes) && this.compare(data.lastValue());
        }
        return this.isSatisfiedForLastTimes(data.points(), forLastTimes);
    }

    private boolean isSatisfiedForLastTimes(long[] points, int forLastTimes) {
        int n;
        int maxPoints = points.length / 2;
        int n2 = n = forLastTimes == 0 ? maxPoints : Math.min(maxPoints, Math.abs(forLastTimes));
        if (forLastTimes > 0 && n < forLastTimes && n < 30) {
            return false;
        }
        if (this.onAverage) {
            return this.avgSatisfiedInLastN(points, n);
        }
        if (forLastTimes <= 0) {
            return this.anySatisfiedInLastN(points, n);
        }
        return this.allSatisfiedInLastN(points, n);
    }

    private boolean avgSatisfiedInLastN(long[] points, int n) {
        int index = points.length - 1;
        long sum = 0L;
        for (int i = 0; i < n; ++i) {
            sum += points[index];
            index -= 2;
        }
        return this.compare(sum / (long)n);
    }

    private boolean anySatisfiedInLastN(long[] points, int n) {
        int index = points.length - 1;
        for (int i = 0; i < n; ++i) {
            if (this.compare(points[index])) {
                return true;
            }
            index -= 2;
        }
        return false;
    }

    private boolean allSatisfiedInLastN(long[] points, int n) {
        int index = points.length - 1;
        for (int i = 0; i < n; ++i) {
            if (!this.compare(points[index])) {
                return false;
            }
            index -= 2;
        }
        return true;
    }

    private boolean compare(long value) {
        switch (this.comparison) {
            default: {
                return value == this.threshold;
            }
            case LE: {
                return value <= this.threshold;
            }
            case LT: {
                return value < this.threshold;
            }
            case GE: {
                return value >= this.threshold;
            }
            case GT: 
        }
        return value > this.threshold;
    }

    public int hashCode() {
        return (int)((long)this.comparison.hashCode() ^ this.threshold ^ (long)(this.forLast == null ? 0 : this.forLast.intValue()));
    }

    public boolean equals(Object obj) {
        return obj instanceof Condition && this.equalTo((Condition)obj);
    }

    public boolean equalTo(Condition other) {
        return this.comparison == other.comparison && this.threshold == other.threshold && Objects.equals(this.forLast, other.forLast) && this.onAverage == other.onAverage;
    }

    public String toString() {
        if (this.isNone()) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        boolean any = this.isForLastPresent() && this.forLast.intValue() == 0;
        boolean anyN = this.isForLastPresent() && this.forLast.intValue() < 0;
        str.append("value ").append(this.comparison.toString()).append(' ').append(this.threshold);
        if (this.isForLastPresent()) {
            if (this.onAverage) {
                str.append(" for average of last ");
            } else if (anyN) {
                str.append(" in last ");
            } else if (any) {
                str.append(" in sample");
            } else {
                str.append(" for last ");
            }
        }
        if (this.isForLastTimes() && !any) {
            str.append(Math.abs(this.forLast.intValue())).append('x');
        }
        if (this.isForLastMillis()) {
            str.append(Math.abs(this.forLast.longValue())).append("ms");
        }
        return str.toString();
    }

    public JsonValue toJSON() {
        if (this.isNone()) {
            return JsonValue.NULL;
        }
        JsonObjectBuilder builder = Json.createObjectBuilder().add("comparison", this.comparison.symbol).add("threshold", this.threshold).add("onAverage", this.onAverage);
        if (this.isForLastMillis()) {
            builder.add(FOR_MILLIS, this.forLast.longValue());
        }
        if (this.isForLastTimes()) {
            builder.add(FOR_TIMES, this.forLast.intValue());
        }
        return builder.build();
    }

    public static Condition fromJSON(JsonValue value) {
        if (value == null || value == JsonValue.NULL) {
            return NONE;
        }
        JsonObject obj = value.asJsonObject();
        Number forLast = null;
        if (obj.containsKey((Object)FOR_MILLIS)) {
            forLast = obj.getJsonNumber(FOR_MILLIS).longValue();
        }
        if (obj.containsKey((Object)FOR_TIMES)) {
            forLast = obj.getInt(FOR_TIMES);
        }
        return new Condition(Operator.parse(obj.getString("comparison", ">")), obj.getJsonNumber("threshold").longValue(), forLast, obj.getBoolean("onAverage", false));
    }

    public static enum Operator {
        LT("<"),
        LE("<="),
        EQ("="),
        GT(">"),
        GE(">=");

        public String symbol;

        private Operator(String symbol) {
            this.symbol = symbol;
        }

        public String toString() {
            return this.symbol;
        }

        public static Operator parse(String symbol) {
            for (Operator op : Operator.values()) {
                if (!op.symbol.equals(symbol)) continue;
                return op;
            }
            throw new NoSuchElementException("Operator with symbol does not exist: " + symbol);
        }
    }
}

