/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessControlException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.MBeanServerForwarder;
import org.glassfish.admin.mbeanserver.Util;
import org.glassfish.external.amx.AMXGlassfish;
import org.glassfish.internal.api.AdminAccessController;
import org.glassfish.logging.annotation.LogMessageInfo;

public class AdminAuthorizedMBeanServer {
    private static final Logger mLogger = Util.JMX_LOGGER;
    @LogMessageInfo(message="Attempted access to method {0} on object {1} rejected; user was granted {2} but the operation reports its impact as \"{3}\"", level="FINE")
    private static final String JMX_NOACCESS = "NCLS-JMX-00010";
    private static final Set<String> RESTRICTED_METHOD_NAMES = new HashSet<String>(Arrays.asList("setAttribute", "setAttributes"));
    private static final Set<String> METHOD_NAMES_SUBJECT_TO_ACCESS_CONTROL = new HashSet<String>(Arrays.asList("invoke", "setAttribute", "setAttributes", "getAttribute", "getAttributes"));

    public static MBeanServerForwarder newInstance(MBeanServer mbs, boolean isInstance) {
        Handler handler = new Handler(mbs, isInstance);
        return (MBeanServerForwarder)Proxy.newProxyInstance(MBeanServerForwarder.class.getClassLoader(), new Class[]{MBeanServerForwarder.class}, (InvocationHandler)handler);
    }

    private static class Handler
    implements InvocationHandler {
        private final MBeanServer mBeanServer;
        private final boolean isInstance;

        private Handler(MBeanServer mbs, boolean isInstance) {
            this.mBeanServer = mbs;
            this.isInstance = isInstance;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.isAllowed(method, args)) {
                return method.invoke((Object)this.mBeanServer, args);
            }
            String format = mLogger.getResourceBundle().getString(AdminAuthorizedMBeanServer.JMX_NOACCESS);
            String objNameString = this.objectNameString(args);
            String operationImpact = Handler.impactToString(this.operationImpact(method, args));
            String msg = MessageFormat.format(format, this.operationName(method, args), objNameString, AdminAccessController.Access.READONLY, operationImpact);
            mLogger.log(Level.FINE, "Disallowing access to {0} operation {1} because the impact is declared as {2}", new Object[]{objNameString, this.operationName(method, args), operationImpact});
            throw new AccessControlException(msg);
        }

        private String operationName(Method method, Object[] args) {
            if (method.getName().equals("invoke")) {
                return this.objectNameString(args) == null || args.length < 2 || args[1] == null ? "null" : (String)args[1];
            }
            return method.getName();
        }

        private String objectNameString(Object[] args) {
            return args == null || args.length == 0 || !(args[0] instanceof ObjectName) ? null : ((ObjectName)args[0]).toString();
        }

        private boolean isAllowed(Method method, Object[] args) throws InstanceNotFoundException, IntrospectionException, ReflectionException, NoSuchMethodException {
            return !this.isInstance || !this.isSubjectToAccessControl(method, args) || this.isAMX(args) || this.isReadonlyRequest(method, args);
        }

        private boolean isAMX(Object[] args) {
            return args == null || args[0] == null || !(args[0] instanceof ObjectName) || !this.isAMX((ObjectName)args[0]);
        }

        private boolean isAMX(ObjectName objectName) {
            String amxDomain = this.amxDomain();
            return objectName == null || amxDomain == null ? false : amxDomain.equals(objectName.getDomain());
        }

        private String amxDomain() {
            return AMXGlassfish.DEFAULT.domainRoot().getDomain();
        }

        private boolean isSubjectToAccessControl(Method method, Object[] args) {
            return METHOD_NAMES_SUBJECT_TO_ACCESS_CONTROL.contains(method.getName());
        }

        private boolean isReadonlyRequest(Method method, Object[] args) throws InstanceNotFoundException, IntrospectionException, ReflectionException, NoSuchMethodException {
            if (RESTRICTED_METHOD_NAMES.contains(method.getName())) {
                return false;
            }
            return !method.getName().equals("invoke") || this.operationImpact(method, args) == 0;
        }

        private int operationImpact(Method method, Object[] args) throws InstanceNotFoundException, IntrospectionException, ReflectionException, NoSuchMethodException {
            if (RESTRICTED_METHOD_NAMES.contains(method.getName())) {
                return 1;
            }
            if (method.getName().equals("invoke")) {
                return this.operationImpactOfInvoke(args);
            }
            return 0;
        }

        private int operationImpactOfInvoke(Object[] args) throws InstanceNotFoundException, IntrospectionException, ReflectionException, NoSuchMethodException {
            ObjectName objectName = (ObjectName)args[0];
            String operationName = (String)args[1];
            String[] signature = (String[])args[3];
            MBeanInfo info = this.mBeanServer.getMBeanInfo(objectName);
            if (info != null) {
                for (MBeanOperationInfo opInfo : info.getOperations()) {
                    if (!opInfo.getName().equals(operationName) || !this.isSignatureEqual(opInfo.getSignature(), signature)) continue;
                    return opInfo.getImpact();
                }
                throw new NoSuchMethodException(operationName);
            }
            return 3;
        }

        private static String impactToString(int impact) {
            String result;
            switch (impact) {
                case 1: {
                    result = "action";
                    break;
                }
                case 2: {
                    result = "action_info";
                    break;
                }
                case 0: {
                    result = "info";
                    break;
                }
                case 3: {
                    result = "unknown";
                    break;
                }
                default: {
                    result = "?";
                }
            }
            return result;
        }

        private boolean isSignatureEqual(MBeanParameterInfo[] declaredMBeanParams, String[] calledSig) {
            if (declaredMBeanParams.length != calledSig.length) {
                return false;
            }
            for (int i = 0; i < declaredMBeanParams.length; ++i) {
                if (declaredMBeanParams[i].getType().equals(calledSig[i])) continue;
                return false;
            }
            return true;
        }
    }
}

