/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor;

import com.sun.enterprise.v3.services.impl.monitor.GrizzlyMonitoring;
import com.sun.enterprise.v3.services.impl.monitor.stats.ConnectionQueueStatsProvider;
import com.sun.enterprise.v3.services.impl.monitor.stats.ThreadPoolStatsProvider;
import com.sun.enterprise.v3.services.impl.monitor.stats.ThreadPoolStatsProviderGlobal;
import org.glassfish.grizzly.threadpool.AbstractThreadPool;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.threadpool.ThreadPoolProbe;

public class ThreadPoolMonitor
implements ThreadPoolProbe {
    private final GrizzlyMonitoring grizzlyMonitoring;
    private final String monitoringId;

    public ThreadPoolMonitor(GrizzlyMonitoring grizzlyMonitoring, String monitoringId, ThreadPoolConfig config) {
        this.grizzlyMonitoring = grizzlyMonitoring;
        this.monitoringId = monitoringId;
        if (grizzlyMonitoring != null) {
            ConnectionQueueStatsProvider connectionQueueStatsProvider;
            ThreadPoolStatsProvider threadPoolStatsProvider = grizzlyMonitoring.getThreadPoolStatsProvider(monitoringId);
            if (threadPoolStatsProvider != null && !config.getPoolName().equals("")) {
                threadPoolStatsProvider.setStatsObject(config);
                ThreadPoolStatsProviderGlobal globalThreadPoolStats = (ThreadPoolStatsProviderGlobal)grizzlyMonitoring.getThreadPoolStatsProvider("");
                if (globalThreadPoolStats != null) {
                    globalThreadPoolStats.subtractBusyThreads(threadPoolStatsProvider.getCurrentThreadsBusy().getCount());
                }
                threadPoolStatsProvider.reset();
                grizzlyMonitoring.updateGlobalThreadPoolStatsProvider();
            }
            if ((connectionQueueStatsProvider = grizzlyMonitoring.getConnectionQueueStatsProvider(monitoringId)) != null) {
                connectionQueueStatsProvider.setStatsObject(config);
                connectionQueueStatsProvider.reset();
            }
        }
    }

    public void onThreadPoolStartEvent(AbstractThreadPool threadPool) {
    }

    public void onThreadPoolStopEvent(AbstractThreadPool threadPool) {
    }

    public void onThreadAllocateEvent(AbstractThreadPool threadPool, Thread thread) {
        this.grizzlyMonitoring.getThreadPoolProbeProvider().threadAllocatedEvent(this.monitoringId, threadPool, thread.getId());
    }

    public void onThreadReleaseEvent(AbstractThreadPool threadPool, Thread thread) {
        this.grizzlyMonitoring.getThreadPoolProbeProvider().threadReleasedEvent(this.monitoringId, threadPool, thread.getId());
    }

    public void onMaxNumberOfThreadsEvent(AbstractThreadPool threadPool, int maxNumberOfThreads) {
        this.grizzlyMonitoring.getThreadPoolProbeProvider().maxNumberOfThreadsReachedEvent(this.monitoringId, threadPool, maxNumberOfThreads);
    }

    public void onTaskDequeueEvent(AbstractThreadPool threadPool, Runnable task) {
        this.grizzlyMonitoring.getThreadPoolProbeProvider().threadDispatchedFromPoolEvent(this.monitoringId, Thread.currentThread().getId());
        this.grizzlyMonitoring.getConnectionQueueProbeProvider().onTaskDequeuedEvent(this.monitoringId, task.getClass().getName());
    }

    public void onTaskCancelEvent(AbstractThreadPool threadPool, Runnable task) {
        this.grizzlyMonitoring.getThreadPoolProbeProvider().threadReturnedToPoolEvent(this.monitoringId, Thread.currentThread().getId());
    }

    public void onTaskCompleteEvent(AbstractThreadPool threadPool, Runnable task) {
        this.grizzlyMonitoring.getThreadPoolProbeProvider().threadReturnedToPoolEvent(this.monitoringId, Thread.currentThread().getId());
    }

    public void onTaskQueueEvent(AbstractThreadPool threadPool, Runnable task) {
        this.grizzlyMonitoring.getConnectionQueueProbeProvider().onTaskQueuedEvent(this.monitoringId, task.getClass().getName());
    }

    public void onTaskQueueOverflowEvent(AbstractThreadPool threadPool) {
        this.grizzlyMonitoring.getConnectionQueueProbeProvider().onTaskQueueOverflowEvent(this.monitoringId);
    }
}

