/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.kernel.embedded;

import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.server.DomainXmlPersistence;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import javax.inject.Inject;
import org.glassfish.kernel.embedded.EmbeddedDomainXml;
import org.jvnet.hk2.config.DomDocument;

public class EmbeddedDomainPersistence
extends DomainXmlPersistence {
    @Inject
    StartupContext startupContext;
    static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DomainXmlPersistence.class);

    @Override
    protected File getDestination() throws IOException {
        String configFileReadOnly = this.startupContext.getArguments().getProperty("org.glassfish.embeddable.configFileReadOnly");
        if (configFileReadOnly != null && !Boolean.valueOf(configFileReadOnly).booleanValue()) {
            try {
                URI uri = EmbeddedDomainXml.getDomainXml(this.startupContext).toURI();
                if ("file".equalsIgnoreCase(uri.getScheme())) {
                    return new File(uri);
                }
                throw new IOException("configurationFile is writable but is not a file");
            }
            catch (URISyntaxException ex) {
                throw new IOException(ex);
            }
        }
        return null;
    }

    @Override
    public void save(DomDocument doc) throws IOException {
        File destination = this.getDestination();
        if (destination == null) {
            String msg = localStrings.getLocalString("NoLocation", "domain.xml cannot be persisted, null destination");
            this.logger.finer(msg);
            return;
        }
        super.save(doc);
    }

    @Override
    protected void saved(File destination) {
        this.logger.log(Level.FINE, "Configuration saved at {0}", destination);
    }
}

