/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.mvc.spi;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.server.mvc.internal.LocalizationMessages;
import org.glassfish.jersey.server.mvc.internal.TemplateHelper;
import org.glassfish.jersey.server.mvc.spi.TemplateProcessor;

public abstract class AbstractTemplateProcessor<T>
implements TemplateProcessor<T> {
    private static final Logger LOGGER = Logger.getLogger(AbstractTemplateProcessor.class.getName());
    private final ConcurrentMap<String, T> cache;
    private final String suffix;
    private final Configuration config;
    private final ServletContext servletContext;
    private final String basePath;
    private final Set<String> supportedExtensions;
    private final Charset encoding;

    public AbstractTemplateProcessor(Configuration config, ServletContext servletContext, String propertySuffix, String ... supportedExtensions) {
        this.config = config;
        this.suffix = '.' + propertySuffix;
        this.servletContext = servletContext;
        this.supportedExtensions = Arrays.stream(supportedExtensions).map(input -> (input = input.toLowerCase(Locale.ROOT)).startsWith(".") ? input : "." + input).collect(Collectors.toSet());
        Map properties = config.getProperties();
        String basePath = (String)PropertiesHelper.getValue((Map)properties, (String)("jersey.config.server.mvc.templateBasePath" + this.suffix), String.class, null);
        if (basePath == null) {
            basePath = (String)PropertiesHelper.getValue((Map)properties, (String)"jersey.config.server.mvc.templateBasePath", (Object)"", null);
        }
        this.basePath = basePath;
        Boolean cacheEnabled = (Boolean)PropertiesHelper.getValue((Map)properties, (String)("jersey.config.server.mvc.caching" + this.suffix), Boolean.class, null);
        if (cacheEnabled == null) {
            cacheEnabled = (Boolean)PropertiesHelper.getValue((Map)properties, (String)"jersey.config.server.mvc.caching", (Object)false, null);
        }
        this.cache = cacheEnabled != false ? new ConcurrentHashMap() : null;
        this.encoding = TemplateHelper.getTemplateOutputEncoding(config, this.suffix);
    }

    protected String getBasePath() {
        return this.basePath;
    }

    protected ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public T resolve(String name, MediaType mediaType) {
        if (this.cache != null) {
            if (!this.cache.containsKey(name)) {
                this.cache.putIfAbsent(name, this.resolve(name));
            }
            return (T)this.cache.get(name);
        }
        return this.resolve(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T resolve(String name) {
        for (String template : this.getTemplatePaths(name)) {
            InputStream stream3;
            Reader reader = null;
            if (this.servletContext != null) {
                String path = template.startsWith("/") ? template : "/" + template;
                InputStream stream2 = this.servletContext.getResourceAsStream(path);
                Reader reader2 = reader = stream2 != null ? new InputStreamReader(stream2) : null;
            }
            if (reader == null) {
                stream3 = this.getClass().getResourceAsStream(template);
                if (stream3 == null) {
                    stream3 = this.getClass().getClassLoader().getResourceAsStream(template);
                }
                Reader reader3 = reader = stream3 != null ? new InputStreamReader(stream3) : null;
            }
            if (reader == null) {
                try {
                    reader = new InputStreamReader((InputStream)new FileInputStream(template), this.encoding);
                }
                catch (FileNotFoundException stream3) {
                    // empty catch block
                }
            }
            if (reader == null) continue;
            try {
                stream3 = this.resolve(template, reader);
                return (T)stream3;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, LocalizationMessages.TEMPLATE_RESOLVE_ERROR(template), e);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, LocalizationMessages.TEMPLATE_ERROR_CLOSING_READER(), e);
                }
            }
        }
        return null;
    }

    protected abstract T resolve(String var1, Reader var2) throws Exception;

    private Collection<String> getTemplatePaths(String name) {
        String lowerName = name.toLowerCase(Locale.ROOT);
        String templatePath = this.basePath.endsWith("/") ? this.basePath + name.substring(1) : this.basePath + name;
        for (String extension : this.supportedExtensions) {
            if (!lowerName.endsWith(extension)) continue;
            return Collections.singleton(templatePath);
        }
        return this.supportedExtensions.stream().map(input -> templatePath + input).collect(Collectors.toSet());
    }

    protected <F> F getTemplateObjectFactory(Function<Class<?>, ?> createInstance, Class<F> type, Value<F> defaultValue) {
        Object objectFactoryProperty = this.config.getProperty("jersey.config.server.mvc.factory" + this.suffix);
        if (objectFactoryProperty != null) {
            if (type.isAssignableFrom(objectFactoryProperty.getClass())) {
                return type.cast(objectFactoryProperty);
            }
            Class factoryClass = null;
            if (objectFactoryProperty instanceof String) {
                factoryClass = (Class)ReflectionHelper.classForNamePA((String)((String)objectFactoryProperty)).run();
            } else if (objectFactoryProperty instanceof Class) {
                factoryClass = (Class)objectFactoryProperty;
            }
            if (factoryClass != null) {
                if (type.isAssignableFrom(factoryClass)) {
                    return type.cast(createInstance.apply(factoryClass));
                }
                LOGGER.log(Level.CONFIG, LocalizationMessages.WRONG_TEMPLATE_OBJECT_FACTORY(factoryClass, type));
            }
        }
        return (F)defaultValue.get();
    }

    protected Charset setContentType(MediaType mediaType, MultivaluedMap<String, Object> httpHeaders) {
        MediaType finalMediaType;
        Charset encoding;
        String charset = (String)mediaType.getParameters().get("charset");
        if (charset == null) {
            encoding = this.getEncoding();
            HashMap<String, String> params = new HashMap<String, String>(mediaType.getParameters());
            params.put("charset", encoding.name());
            finalMediaType = new MediaType(mediaType.getType(), mediaType.getSubtype(), params);
        } else {
            encoding = Charset.forName(charset);
            finalMediaType = mediaType;
        }
        ArrayList<String> typeList = new ArrayList<String>(1);
        typeList.add(finalMediaType.toString());
        httpHeaders.put((Object)"Content-Type", typeList);
        return encoding;
    }

    protected Charset getEncoding() {
        return this.encoding;
    }
}

