/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jwt.JWTClaimsSet;
import fish.payara.security.openid.OpenIdCredential;
import fish.payara.security.openid.controller.TokenController;
import fish.payara.security.openid.domain.AccessTokenImpl;
import fish.payara.security.openid.domain.IdentityTokenImpl;
import fish.payara.security.openid.domain.OpenIdConfiguration;
import fish.payara.security.openid.domain.OpenIdContextImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import javax.security.enterprise.credential.Credential;
import javax.security.enterprise.identitystore.CredentialValidationResult;
import javax.security.enterprise.identitystore.IdentityStore;

@ApplicationScoped
public class OpenIdIdentityStore
implements IdentityStore {
    private static final Logger LOGGER = Logger.getLogger(OpenIdIdentityStore.class.getName());
    @Inject
    private OpenIdContextImpl context;
    @Inject
    private TokenController tokenController;
    @Inject
    private OpenIdConfiguration configuration;

    public CredentialValidationResult validate(OpenIdCredential credential) {
        HttpMessageContext httpContext = credential.getHttpContext();
        IdentityTokenImpl idToken = credential.getIdentityTokenImpl();
        Algorithm idTokenAlgorithm = idToken.getTokenJWT().getHeader().getAlgorithm();
        JWTClaimsSet idTokenClaims = Objects.isNull(this.context.getIdentityToken()) ? this.tokenController.validateIdToken(idToken, httpContext) : this.tokenController.validateRefreshedIdToken(this.context.getIdentityToken(), idToken);
        this.context.setIdentityToken(idToken.withClaims(idTokenClaims));
        AccessTokenImpl accessToken = (AccessTokenImpl)credential.getAccessToken();
        if (Objects.nonNull(accessToken)) {
            this.tokenController.validateAccessToken(accessToken, idTokenAlgorithm, this.context.getIdentityToken().getClaims());
            this.context.setAccessToken(accessToken);
        }
        String callerName = this.getCallerName();
        this.context.setCallerName(callerName);
        Set<String> callerGroups = this.getCallerGroups();
        this.context.setCallerGroups(callerGroups);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Setting caller groups into the OpenID context: " + callerGroups);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Setting caller name into the OpenID context: " + callerName);
            }
        }
        return new CredentialValidationResult(this.context.getCallerName(), this.context.getCallerGroups());
    }

    public CredentialValidationResult validate(Credential credential) {
        if (credential instanceof OpenIdCredential) {
            return this.validate((OpenIdCredential)credential);
        }
        return CredentialValidationResult.NOT_VALIDATED_RESULT;
    }

    private String getCallerName() {
        String callerNameClaim = this.configuration.getClaimsConfiguration().getCallerNameClaim();
        if ("sub".equals(callerNameClaim)) {
            return this.context.getSubject();
        }
        String callerName = this.context.getIdentityToken().getJwtClaims().getStringClaim(callerNameClaim).orElse(null);
        if (callerName == null) {
            callerName = this.context.getAccessToken().getJwtClaims().getStringClaim(callerNameClaim).orElse(null);
        }
        if (callerName == null) {
            callerName = this.context.getClaims().getStringClaim(callerNameClaim).orElse(null);
        }
        if (callerName == null) {
            callerName = this.context.getSubject();
        }
        return callerName;
    }

    private Set<String> getCallerGroups() {
        String callerGroupsClaim = this.configuration.getClaimsConfiguration().getCallerGroupsClaim();
        List<String> groupsAccessClaim = this.context.getAccessToken().getJwtClaims().getArrayStringClaim(callerGroupsClaim);
        if (!groupsAccessClaim.isEmpty()) {
            return new HashSet<String>(groupsAccessClaim);
        }
        List<String> groupsIdentityClaim = this.context.getIdentityToken().getJwtClaims().getArrayStringClaim(callerGroupsClaim);
        if (!groupsIdentityClaim.isEmpty()) {
            return new HashSet<String>(groupsIdentityClaim);
        }
        List<String> groupsUserinfoClaim = this.context.getClaims().getArrayStringClaim(callerGroupsClaim);
        if (!groupsUserinfoClaim.isEmpty()) {
            return new HashSet<String>(groupsUserinfoClaim);
        }
        return Collections.emptySet();
    }
}

