/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid;

import java.util.Optional;
import java.util.function.Predicate;
import javax.el.ELProcessor;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.microprofile.config.Config;

public final class OpenIdUtil {
    private OpenIdUtil() {
    }

    public static <T> T getConfiguredValue(Class<T> type, T value, Config provider, String mpConfigKey) {
        Object result = value;
        Optional configResult = provider.getOptionalValue(mpConfigKey, type);
        if (configResult.isPresent()) {
            return configResult.get();
        }
        if (type == String.class && OpenIdUtil.isELExpression((String)value)) {
            ELProcessor elProcessor = new ELProcessor();
            BeanManager beanManager = OpenIdUtil.getBeanManagerForCurrentModule();
            elProcessor.getELManager().addELResolver(beanManager.getELResolver());
            result = elProcessor.getValue(OpenIdUtil.toRawExpression((String)result), type);
        }
        return result;
    }

    private static BeanManager getBeanManagerForCurrentModule() {
        try {
            return (BeanManager)new InitialContext().lookup("java:comp/BeanManager");
        }
        catch (NamingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean isELExpression(String expression) {
        return expression != null && !expression.isEmpty() && OpenIdUtil.isDeferredExpression(expression);
    }

    public static boolean isDeferredExpression(String expression) {
        return expression.startsWith("#{") && expression.endsWith("}");
    }

    public static String toRawExpression(String expression) {
        return expression.substring(2, expression.length() - 1);
    }

    public static <T> Predicate<T> not(Predicate<T> t) {
        return t.negate();
    }

    public static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }
}

