/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.memory.levels;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.memory.MemoryGlobals;
import com.sun.messaging.jmq.jmsserver.memory.MemoryLevelHandler;

public class Red
extends MemoryLevelHandler {
    protected static final boolean SWAP_NON_PERSIST = false;
    protected static final int GC_DEFAULT = 10;
    protected static final int GC_ITR_DEFAULT = 10;
    protected int GCCount = 0;
    protected int GCItrCount = 0;

    public Red(String name) {
        super(name);
        this.MEMORY_NAME_KEY = "B0024";
        this.GCCount = Globals.getConfig().getIntProperty("imq." + name + ".gccount", 10);
        this.GCItrCount = Globals.getConfig().getIntProperty("imq." + name + ".gcitr", 10);
    }

    @Override
    public int getMessageCount(long freeMem, int producers) {
        return 0;
    }

    @Override
    public long getMemory(long freeMemory, int producers) {
        return 0L;
    }

    @Override
    public int gcCount() {
        return this.GCCount;
    }

    @Override
    public int gcIteration() {
        return this.GCItrCount;
    }

    @Override
    public boolean cleanup(int cnt) {
        super.cleanup(cnt);
        switch (cnt) {
            case 0: {
                this.logger.log(8, "B1089");
                this.logger.log(4, "Broker is swapping all persistent messages");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return true;
    }

    @Override
    public boolean enter(boolean fromHigher) {
        super.enter(fromHigher);
        if (fromHigher) {
            return true;
        }
        MemoryGlobals.setMEM_DISALLOW_PRODUCERS(true);
        MemoryGlobals.setMEM_DISALLOW_CREATE_DEST(true);
        try {
            Globals.getClusterBroadcast().pauseMessageFlow();
        }
        catch (Exception ex) {
            this.logger.logStack(4, "Got exception in Red", (Throwable)ex);
        }
        return true;
    }

    @Override
    public boolean leave(boolean toHigher) {
        super.leave(toHigher);
        if (toHigher) {
            return true;
        }
        MemoryGlobals.setMEM_DISALLOW_PRODUCERS(false);
        MemoryGlobals.setMEM_DISALLOW_CREATE_DEST(false);
        try {
            Globals.getClusterBroadcast().resumeMessageFlow();
        }
        catch (Exception ex) {
            this.logger.logStack(4, "Got exception in Red", (Throwable)ex);
        }
        return true;
    }
}

