/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterProtocolHelper;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;

public class ClusterTakeoverMEInfo
implements ClusterProtocolHelper {
    protected Logger logger = Globals.getLogger();
    private String groupName = null;
    private String nodeName = null;
    private String masterHostPort = null;
    private String targetNodeName = null;
    private String uuid = null;
    private Long xid = null;
    private Cluster c = null;
    private GPacket pkt = null;
    private RaptorProtocol parent = null;

    private ClusterTakeoverMEInfo(String groupName, String nodeName, String masterHostPort, String targetNodeName, String uuid, Long xid, Cluster c) {
        this.groupName = groupName;
        this.nodeName = nodeName;
        this.masterHostPort = masterHostPort;
        this.targetNodeName = targetNodeName;
        this.uuid = uuid;
        this.xid = xid;
        this.c = c;
    }

    private ClusterTakeoverMEInfo(GPacket pkt, Cluster c) {
        this.pkt = pkt;
        this.c = c;
    }

    public void setParent(RaptorProtocol parent) {
        this.parent = parent;
    }

    public static ClusterTakeoverMEInfo newInstance(String groupName, String nodeName, String masterHostPort, String targetNodeName, String uuid, Long xid, Cluster c) {
        return new ClusterTakeoverMEInfo(groupName, nodeName, masterHostPort, targetNodeName, uuid, xid, c);
    }

    public static ClusterTakeoverMEInfo newInstance(String myBrokerID, String targetBrokerID, String uuid, Long xid, Cluster c) {
        return new ClusterTakeoverMEInfo(null, myBrokerID, null, targetBrokerID, uuid, xid, c);
    }

    public static ClusterTakeoverMEInfo newInstance(GPacket pkt, Cluster c) {
        return new ClusterTakeoverMEInfo(pkt, c);
    }

    public GPacket getGPacket() throws IOException {
        GPacket gp = GPacket.getInstance();
        gp.setType((short)59);
        if (this.groupName != null) {
            gp.putProp((Object)"groupName", (Object)this.groupName);
        }
        gp.putProp((Object)"nodeName", (Object)this.nodeName);
        if (this.masterHostPort != null) {
            gp.putProp((Object)"masterHostPort", (Object)this.masterHostPort);
        }
        gp.putProp((Object)"clusterid", (Object)Globals.getClusterID());
        gp.putProp((Object)"targetNodeName", (Object)this.targetNodeName);
        gp.putProp((Object)"X", (Object)this.xid);
        gp.putProp((Object)"uuid", (Object)this.uuid);
        gp.putProp((Object)"TS", (Object)System.currentTimeMillis());
        this.c.marshalBrokerAddress(this.c.getSelfAddress(), gp);
        gp.setBit(1, true);
        return gp;
    }

    public String getGroupName() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"groupName");
    }

    public String getNodeName() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"nodeName");
    }

    public String getMasterHostPort() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"masterHostPort");
    }

    public String getClusterID() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"clusterid");
    }

    public String getTargetNodeName() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"targetNodeName");
    }

    public String getUUID() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"uuid");
    }

    public Long getXid() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp((Object)"X");
    }

    public BrokerAddress getOwnerAddress() throws Exception {
        assert (this.pkt != null);
        return this.c.unmarshalBrokerAddress(this.pkt);
    }

    public Long getTimestamp() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp((Object)"TS");
    }

    public boolean needReply() {
        assert (this.pkt != null);
        return this.pkt.getBit(1);
    }

    public GPacket getReplyGPacket(int status, String reason) {
        assert (this.pkt != null);
        GPacket gp = GPacket.getInstance();
        gp.setType((short)60);
        gp.putProp((Object)"X", (Object)((Long)this.pkt.getProp((Object)"X")));
        gp.putProp((Object)"S", (Object)status);
        if (reason != null) {
            gp.putProp((Object)"reason", (Object)reason);
        }
        return gp;
    }

    public static GPacket getReplyAckGPacket(GPacket reply) {
        GPacket gp = GPacket.getInstance();
        gp.setType((short)61);
        gp.putProp((Object)"X", (Object)((Long)reply.getProp((Object)"X")));
        gp.putProp((Object)"S", (Object)200);
        return gp;
    }

    @Override
    public void sendReply(BrokerAddress to, int status, String reason, Object extraInfo) {
        if (!this.needReply()) {
            return;
        }
        this.parent.sendTakeoverMEReply(this, status, reason, to);
    }

    @Override
    public String toString() {
        if (this.pkt == null) {
            return "[" + this.groupName + "[" + this.nodeName + ", " + this.masterHostPort + "]target=" + this.targetNodeName + ", xid=" + this.xid + ", uuid=" + this.uuid + "]";
        }
        return "[" + this.getGroupName() + "[" + this.getNodeName() + ", " + this.getMasterHostPort() + "]target=" + this.getTargetNodeName() + ", xid=" + this.getXid() + ", uuid=" + this.getUUID() + ", time=" + this.getTimestamp() + "]";
    }

    protected String getReplyToString(GPacket reply) {
        return this.toString() + ":[status=" + reply.getProp((Object)"S") + ", " + reply.getProp((Object)"reason") + "]";
    }

    protected static String getReplyAckToString(GPacket replyack) {
        return "[xid=" + replyack.getProp((Object)"X") + "]";
    }

    public static Long getReplyPacketXid(GPacket gp) {
        return (Long)gp.getProp((Object)"X");
    }
}

