/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterProtocolHelper;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ClusterTakeoverMEPrepareInfo
implements ClusterProtocolHelper {
    protected Logger logger = Globals.getLogger();
    private String groupName = null;
    private String nodeName = null;
    private String masterHostPort = null;
    private byte[] commitToken = null;
    private String targetNodeName = null;
    private Long xid = null;
    private Cluster c = null;
    private String uuid = null;
    private Long syncTimeout = null;
    private GPacket pkt = null;

    private ClusterTakeoverMEPrepareInfo(String groupName, String nodeName, String masterHostPort, byte[] commitToken, Long syncTimeout, String targetNodeName, String uuid, Long xid, Cluster c) {
        this.groupName = groupName;
        this.nodeName = nodeName;
        this.masterHostPort = masterHostPort;
        this.targetNodeName = targetNodeName;
        this.xid = xid;
        this.c = c;
        this.commitToken = commitToken;
        this.syncTimeout = syncTimeout;
        this.uuid = uuid;
    }

    private ClusterTakeoverMEPrepareInfo(GPacket pkt, Cluster c) {
        this.pkt = pkt;
        this.c = c;
    }

    public static ClusterTakeoverMEPrepareInfo newInstance(String groupName, String nodeName, String masterHostPort, byte[] commitToken, Long syncTimeout, String targetNodeName, String uuid, Long xid, Cluster c) {
        return new ClusterTakeoverMEPrepareInfo(groupName, nodeName, masterHostPort, commitToken, syncTimeout, targetNodeName, uuid, xid, c);
    }

    public static ClusterTakeoverMEPrepareInfo newInstance(GPacket pkt, Cluster c) {
        return new ClusterTakeoverMEPrepareInfo(pkt, c);
    }

    public GPacket getGPacket() throws IOException {
        GPacket gp = GPacket.getInstance();
        gp.setType((short)57);
        gp.putProp((Object)"groupName", (Object)this.groupName);
        gp.putProp((Object)"nodeName", (Object)this.nodeName);
        gp.putProp((Object)"masterHostPort", (Object)this.masterHostPort);
        gp.putProp((Object)"clusterid", (Object)Globals.getClusterID());
        gp.putProp((Object)"targetNodeName", (Object)this.targetNodeName);
        gp.putProp((Object)"X", (Object)this.xid);
        gp.putProp((Object)"UUID", (Object)this.uuid);
        gp.putProp((Object)"TS", (Object)System.currentTimeMillis());
        if (this.syncTimeout != null) {
            gp.putProp((Object)"syncTimeout", (Object)this.syncTimeout);
        }
        this.c.marshalBrokerAddress(this.c.getSelfAddress(), gp);
        gp.setPayload(ByteBuffer.wrap(this.commitToken));
        gp.setBit(1, true);
        return gp;
    }

    public String getGroupName() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"groupName");
    }

    public String getNodeName() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"nodeName");
    }

    public String getMasterHostPort() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"masterHostPort");
    }

    public String getClusterID() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"clusterid");
    }

    public byte[] getCommitToken() {
        assert (this.pkt != null);
        byte[] buf = null;
        if (this.pkt.getPayload() != null) {
            buf = this.pkt.getPayload().array();
        }
        return buf;
    }

    public Long getSyncTimeout() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp((Object)"syncTimeout");
    }

    public String getTargetNodeName() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"targetNodeName");
    }

    public BrokerAddress getOwnerAddress() throws Exception {
        assert (this.pkt != null);
        return this.c.unmarshalBrokerAddress(this.pkt);
    }

    public String getUUID() {
        if (this.pkt != null) {
            return (String)this.pkt.getProp((Object)"UUID");
        }
        return this.uuid;
    }

    public Long getXid() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp((Object)"X");
    }

    public Long getTimestamp() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp((Object)"TS");
    }

    public boolean needReply() {
        assert (this.pkt != null);
        return this.pkt.getBit(1);
    }

    public GPacket getReplyGPacket(int status, String reason, String replicaHostPort) {
        assert (this.pkt != null);
        GPacket gp = GPacket.getInstance();
        gp.setType((short)58);
        gp.putProp((Object)"X", (Object)((Long)this.pkt.getProp((Object)"X")));
        gp.putProp((Object)"S", (Object)status);
        if (reason != null) {
            gp.putProp((Object)"reason", (Object)reason);
        }
        if (replicaHostPort != null) {
            gp.putProp((Object)"replicaHostPort", (Object)replicaHostPort);
        }
        return gp;
    }

    @Override
    public void sendReply(BrokerAddress recipient, int status, String reason, Object extraInfo) {
        if (!this.needReply()) {
            return;
        }
        String replicaHostPort = (String)extraInfo;
        GPacket reply = this.getReplyGPacket(status, reason, replicaHostPort);
        try {
            this.c.unicast(recipient, reply);
        }
        catch (Exception e) {
            Object[] args = new String[]{ProtocolGlobals.getPacketTypeDisplayString(58), recipient.toString(), this.toString()};
            BrokerResources brokerResources = Globals.getBrokerResources();
            Globals.getBrokerResources();
            this.logger.logStack(32, brokerResources.getKString("B3192", args), (Throwable)e);
        }
    }

    @Override
    public String toString() {
        if (this.pkt == null) {
            return "[" + this.groupName + "[" + this.nodeName + ", " + this.masterHostPort + "]target=" + this.targetNodeName + ", timeout=" + this.syncTimeout + ", xid=" + this.xid + ", uuid=" + this.uuid + "]";
        }
        return "[" + this.getGroupName() + "[" + this.getNodeName() + ", " + this.getMasterHostPort() + "]target=" + this.getTargetNodeName() + ", timeout=" + this.getSyncTimeout() + ", xid=" + this.getXid() + ", uuid=" + this.getUUID() + ", time=" + this.getTimestamp() + "]";
    }

    protected static Long getReplyPacketXid(GPacket gp) {
        return (Long)gp.getProp((Object)"X");
    }

    protected String getReplyReplicaHostPort(GPacket gp) {
        return (String)gp.getProp((Object)"replicaHostPort");
    }
}

