/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.concurrent.internal;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.enterprise.concurrent.AbortedException;
import javax.enterprise.concurrent.ContextService;
import javax.enterprise.concurrent.ManagedTask;
import javax.enterprise.concurrent.ManagedTaskListener;
import org.glassfish.enterprise.concurrent.AbstractManagedExecutorService;
import org.glassfish.enterprise.concurrent.internal.TaskDoneCallback;
import org.glassfish.enterprise.concurrent.spi.ContextHandle;
import org.glassfish.enterprise.concurrent.spi.ContextSetupProvider;

public class ManagedFutureTask<V>
extends FutureTask<V>
implements Future<V> {
    protected final AbstractManagedExecutorService executor;
    protected final ManagedTaskListener taskListener;
    protected ContextHandle contextHandleForSetup = null;
    protected ContextHandle contextHandleForReset = null;
    protected Object task;
    protected Throwable taskRunThrowable;
    protected TaskDoneCallback taskDoneCallback;
    final boolean isContextualCallback;
    IllegalStateException contextSetupException = null;

    public ManagedFutureTask(AbstractManagedExecutorService executor, Runnable runnable, V result) {
        super(runnable, result);
        this.task = runnable;
        this.executor = executor;
        this.taskListener = this.getManagedTaskListener(this.task);
        this.isContextualCallback = this.isTaskContextualCallback(this.task) || executor.isContextualCallback();
        this.captureContext(executor);
    }

    public ManagedFutureTask(AbstractManagedExecutorService executor, Callable callable) {
        super(callable);
        this.task = callable;
        this.executor = executor;
        this.taskListener = this.getManagedTaskListener(this.task);
        this.isContextualCallback = this.isTaskContextualCallback(this.task) || executor.isContextualCallback();
        this.captureContext(executor);
    }

    private ManagedTaskListener getManagedTaskListener(Object task) {
        if (task instanceof ManagedTask) {
            return ((ManagedTask)task).getManagedTaskListener();
        }
        return null;
    }

    private boolean isTaskContextualCallback(Object task) {
        return false;
    }

    protected final void captureContext(AbstractManagedExecutorService executor) {
        ContextSetupProvider contextSetupProvider = executor.getContextSetupProvider();
        ContextService contextService = executor.getContextService();
        if (contextService != null && contextSetupProvider != null) {
            this.contextHandleForSetup = contextSetupProvider.saveContext(contextService);
        }
    }

    public void setupContext() {
        ContextSetupProvider contextSetupProvider = this.executor.getContextSetupProvider();
        if (contextSetupProvider != null) {
            try {
                this.contextHandleForReset = contextSetupProvider.setup(this.contextHandleForSetup);
            }
            catch (IllegalStateException ex) {
                this.contextSetupException = ex;
            }
        }
    }

    public void resetContext() {
        ContextSetupProvider contextSetupProvider;
        if (this.contextSetupException == null && (contextSetupProvider = this.executor.getContextSetupProvider()) != null) {
            contextSetupProvider.reset(this.contextHandleForReset);
        }
    }

    @Override
    public void run() {
        if (this.contextSetupException == null) {
            super.run();
        } else {
            this.abort();
        }
    }

    @Override
    public boolean runAndReset() {
        if (this.contextSetupException == null) {
            return super.runAndReset();
        }
        this.abort();
        return false;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean result = super.cancel(mayInterruptIfRunning);
        if (result && this.taskListener != null) {
            try {
                if (this.isContextualCallback) {
                    this.setupContext();
                }
                this.taskListener.taskAborted((Future)this, this.executor.getExecutorForTaskListener(), this.task, (Throwable)new CancellationException());
            }
            finally {
                if (this.isContextualCallback) {
                    this.resetContext();
                }
            }
        }
        return result;
    }

    public void submitted() {
        if (this.taskListener != null) {
            try {
                if (this.isContextualCallback) {
                    this.setupContext();
                }
                this.taskListener.taskSubmitted((Future)this, this.executor.getExecutorForTaskListener(), this.task);
            }
            finally {
                if (this.isContextualCallback) {
                    this.resetContext();
                }
            }
        }
    }

    @Override
    protected void done() {
        super.done();
        if (this.taskDoneCallback != null) {
            this.taskDoneCallback.taskDone(this);
        }
        if (this.taskListener != null && this.isCancelled()) {
            try {
                if (this.isContextualCallback) {
                    this.setupContext();
                }
                this.taskListener.taskDone((Future)this, this.executor.getExecutorForTaskListener(), this.task, (Throwable)new CancellationException());
            }
            finally {
                if (this.isContextualCallback) {
                    this.resetContext();
                }
            }
        }
    }

    @Override
    protected void setException(Throwable t) {
        super.setException(t);
        this.taskRunThrowable = t;
    }

    public void starting(Thread t) {
        if (this.executor.getManagedThreadFactory() != null) {
            this.executor.getManagedThreadFactory().taskStarting(t, this);
        }
        if (this.taskListener != null) {
            this.taskListener.taskStarting((Future)this, this.executor.getExecutorForTaskListener(), this.task);
        }
    }

    public void done(Throwable t) {
        if (this.executor.getManagedThreadFactory() != null) {
            this.executor.getManagedThreadFactory().taskDone(Thread.currentThread());
        }
        if (this.taskListener != null) {
            this.taskListener.taskDone((Future)this, this.executor.getExecutorForTaskListener(), this.task, t != null ? t : this.taskRunThrowable);
        }
    }

    public void setTaskDoneCallback(TaskDoneCallback taskDoneCallback) {
        this.taskDoneCallback = taskDoneCallback;
    }

    public String getTaskIdentityName() {
        String taskName;
        Map executionProperties;
        if (this.task instanceof ManagedTask && (executionProperties = ((ManagedTask)this.task).getExecutionProperties()) != null && (taskName = (String)executionProperties.get("javax.enterprise.concurrent.IDENTITY_NAME")) != null) {
            return taskName;
        }
        return this.task.toString();
    }

    private void abort() {
        AbortedException ex = new AbortedException(this.contextSetupException.getMessage());
        this.setException((Throwable)ex);
        if (this.taskListener != null) {
            this.taskListener.taskAborted((Future)this, this.executor.getExecutorForTaskListener(), this.task, (Throwable)ex);
        }
    }
}

