/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.security;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.security.SecurityServicesUtil;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.module.ServerAuthModule;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.Response;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestResponse;
import org.glassfish.admingui.common.util.RestUtil;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;

public class AdminConsoleAuthModule
implements ServerAuthModule {
    private static final Logger logger = GuiUtil.getLogger();
    private static final Class<?>[] SUPPORTED_MESSAGE_TYPES = new Class[]{HttpServletRequest.class, HttpServletResponse.class};
    private static final String SAVED_SUBJECT = "Saved_Subject";
    private static final String USER_NAME = "userName";
    private static final String ORIG_REQUEST_PATH = "origRequestPath";
    private static final String RESPONSE_TYPE = "application/json";
    public static final String REST_SERVER_NAME = "serverName";
    public static final String REST_SERVER_PORT = "serverPort";
    public static final String REST_TOKEN = "__rTkn__";
    private CallbackHandler handler;
    private String restURL;
    private String loginPage;
    private String loginErrorPage;

    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options) throws AuthException {
        this.handler = handler;
        if (options != null) {
            this.loginPage = (String)options.get("loginPage");
            if (this.loginPage == null) {
                throw new AuthException("'loginPage' must be supplied as a property in the provider-config in the domain.xml file!");
            }
            this.loginErrorPage = (String)options.get("loginErrorPage");
            if (this.loginErrorPage == null) {
                throw new AuthException("'loginErrorPage' must be supplied as a property in the provider-config in the domain.xml file!");
            }
            this.restURL = this.getAuthenticationURL();
        }
    }

    public Class[] getSupportedMessageTypes() {
        return SUPPORTED_MESSAGE_TYPES;
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        char[] password;
        HttpServletRequest request = (HttpServletRequest)messageInfo.getRequestMessage();
        HttpServletResponse response = (HttpServletResponse)messageInfo.getResponseMessage();
        if (!this.isMandatory(messageInfo) && !request.getRequestURI().endsWith("/j_security_check")) {
            return this.doNothing(clientSubject);
        }
        HttpSession session = request.getSession(true);
        Subject savedClientSubject = (Subject)session.getAttribute(SAVED_SUBJECT);
        String savedUsername = (String)session.getAttribute(USER_NAME);
        if (savedClientSubject != null && savedUsername != null) {
            return this.notifyContainerAboutLogin(clientSubject, savedUsername);
        }
        if (session.getAttribute(REST_SERVER_NAME) == null) {
            this.saveServerHostPort(session);
        }
        String username = request.getParameter("j_username");
        char[] cArray = password = request.getParameter("j_password") != null ? request.getParameter("j_password").toCharArray() : null;
        if (username == null || password == null || !request.getMethod().equalsIgnoreCase("post")) {
            return this.saveRequestAndForwardToLogin(session, request, response);
        }
        RestResponse validationResult = this.validateCredentials(request, username, password);
        if (validationResult.isSuccess()) {
            this.notifyContainerAboutLogin(clientSubject, username);
            request.changeSessionId();
            Map extraProperties = this.getExtraProperties(validationResult);
            if (extraProperties != null) {
                session.setAttribute(REST_TOKEN, extraProperties.get("token"));
            }
            session.setAttribute(SAVED_SUBJECT, (Object)clientSubject);
            session.setAttribute(USER_NAME, (Object)username);
            return this.redirectBack(session, request, response);
        }
        return this.forwardToErrorPage(validationResult, request, response);
    }

    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        return AuthStatus.SUCCESS;
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
    }

    private AuthStatus doNothing(Subject clientSubject) throws AuthException {
        try {
            this.handler.handle(new Callback[]{new CallerPrincipalCallback(clientSubject, (Principal)null)});
            return AuthStatus.SUCCESS;
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw (AuthException)new AuthException().initCause((Throwable)e);
        }
    }

    private void saveServerHostPort(HttpSession session) {
        try {
            URL url = new URL(this.restURL);
            session.setAttribute(REST_SERVER_NAME, (Object)url.getHost());
            session.setAttribute(REST_SERVER_PORT, (Object)url.getPort());
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Unable to parse REST URL: (" + this.restURL + ")", ex);
        }
    }

    private String getAuthenticationURL() {
        ServiceLocator habitat = SecurityServicesUtil.getInstance().getHabitat();
        Domain domain = (Domain)habitat.getService(Domain.class, new Annotation[0]);
        SecureAdmin secureAdmin = (SecureAdmin)habitat.getService(SecureAdmin.class, new Annotation[0]);
        NetworkListener adminListener = domain.getServerNamed("server").getConfig().getNetworkConfig().getNetworkListener("admin-listener");
        String host = adminListener.getAddress();
        String port = adminListener.getPort();
        return (SecureAdmin.Util.isEnabled((SecureAdmin)secureAdmin) ? "https://" : "http://") + (host.equals("0.0.0.0") ? "localhost" : host) + ":" + port + "/management/sessions";
    }

    private RestResponse validateCredentials(HttpServletRequest request, String username, char[] password) {
        WebTarget target = (WebTarget)RestUtil.initialize(ClientBuilder.newBuilder()).build().target(this.restURL).register((Object)HttpAuthenticationFeature.basic((String)username, (String)new String(password)));
        MultivaluedHashMap payLoad = new MultivaluedHashMap();
        payLoad.putSingle((Object)"remoteHostName", (Object)request.getRemoteHost());
        return RestResponse.getRestResponse((Response)target.request(new String[]{RESPONSE_TYPE}).post(Entity.entity((Object)payLoad, (String)"application/x-www-form-urlencoded"), Response.class));
    }

    private Map getExtraProperties(RestResponse validationResult) {
        Object obj = validationResult.getResponse().get("data");
        Map extraProperties = null;
        if (obj instanceof Map && (obj = ((Map)obj).get("extraProperties")) instanceof Map) {
            extraProperties = (Map)obj;
        }
        return extraProperties;
    }

    private AuthStatus saveRequestAndForwardToLogin(HttpSession session, HttpServletRequest request, HttpServletResponse response) throws AuthException {
        String originalPath = request.getRequestURI();
        String queryString = request.getQueryString();
        if (queryString != null && !queryString.isEmpty()) {
            originalPath = originalPath + "?" + queryString;
        }
        session.setAttribute(ORIG_REQUEST_PATH, (Object)originalPath);
        try {
            request.getRequestDispatcher(this.loginPage).forward((ServletRequest)request, (ServletResponse)response);
            return AuthStatus.SEND_CONTINUE;
        }
        catch (Exception ex) {
            throw (AuthException)new AuthException().initCause((Throwable)ex);
        }
    }

    private AuthStatus forwardToErrorPage(RestResponse validationResult, HttpServletRequest request, HttpServletResponse response) throws AuthException {
        if (validationResult.getResponseCode() == 403) {
            request.setAttribute("errorText", (Object)GuiUtil.getMessage("alert.ConfigurationError"));
            request.setAttribute("messageText", (Object)GuiUtil.getMessage("alert.EnableSecureAdmin"));
        }
        try {
            request.getRequestDispatcher(this.loginErrorPage).forward((ServletRequest)request, (ServletResponse)response);
            return AuthStatus.SEND_FAILURE;
        }
        catch (Exception ex) {
            throw (AuthException)new AuthException().initCause((Throwable)ex);
        }
    }

    private AuthStatus notifyContainerAboutLogin(Subject clientSubject, String username) throws AuthException {
        try {
            this.handler.handle(new Callback[]{new CallerPrincipalCallback(clientSubject, username)});
            return AuthStatus.SUCCESS;
        }
        catch (Exception ex) {
            throw (AuthException)new AuthException().initCause((Throwable)ex);
        }
    }

    private AuthStatus redirectBack(HttpSession session, HttpServletRequest request, HttpServletResponse response) throws AuthException {
        try {
            String origRequest = (String)session.getAttribute(ORIG_REQUEST_PATH);
            if (origRequest == null || "/favicon.ico".equals(origRequest)) {
                origRequest = "/index.jsf";
            }
            logger.log(Level.INFO, "Redirecting to {0}", origRequest);
            response.sendRedirect(response.encodeRedirectURL(origRequest));
            return AuthStatus.SEND_CONTINUE;
        }
        catch (Exception ex) {
            throw (AuthException)new AuthException().initCause((Throwable)ex);
        }
    }

    private boolean isMandatory(MessageInfo messageInfo) {
        return Boolean.valueOf((String)messageInfo.getMap().get("javax.security.auth.message.MessagePolicy.isMandatory"));
    }
}

