/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import java.io.Serializable;
import javax.transaction.xa.Xid;

public class XidImpl
implements Xid,
Serializable {
    protected int formatId;
    protected byte[] branchQualifier = new byte[64];
    protected byte[] globalTxnId = new byte[64];
    protected int gtLength;
    protected int bqLength;
    public static final int MAXGTXNSIZE = 64;
    public static final int MAXBQUALSIZE = 64;
    public static final int NULL_XID = -1;
    public static final int OSICCR_XID = 0;
    private static final String hextab = "0123456789ABCDEF";

    public XidImpl() {
        this.formatId = -1;
        this.bqLength = 0;
        this.gtLength = 0;
    }

    public XidImpl(Xid xid) {
        this.copy(xid);
    }

    public void copy(Xid xid) {
        if (xid == null || xid.getFormatId() == -1) {
            this.formatId = -1;
            this.bqLength = 0;
            this.gtLength = 0;
            return;
        }
        this.formatId = xid.getFormatId();
        byte[] tmp = xid.getBranchQualifier();
        this.bqLength = tmp.length > 64 ? 64 : tmp.length;
        System.arraycopy(tmp, 0, this.branchQualifier, 0, this.bqLength);
        tmp = xid.getGlobalTransactionId();
        this.gtLength = tmp.length > 64 ? 64 : tmp.length;
        System.arraycopy(tmp, 0, this.globalTxnId, 0, this.gtLength);
    }

    public boolean equals(Object obj) {
        return this.equals((Xid)obj);
    }

    public boolean equals(Xid xid) {
        if (xid == null || this.formatId == -1) {
            return false;
        }
        return this.formatId == xid.getFormatId() && this.isEqualGlobalTxnId(xid.getGlobalTransactionId()) && this.isEqualBranchQualifier(xid.getBranchQualifier());
    }

    public int hashCode() {
        int hash = 0;
        if (this.bqLength >= 2) {
            hash += this.branchQualifier[this.bqLength - 1] << 8;
        }
        if (this.bqLength >= 1) {
            hash += this.branchQualifier[0];
        }
        if (this.gtLength >= 2) {
            hash += this.globalTxnId[this.gtLength - 1] << 24;
        }
        if (this.gtLength >= 1) {
            hash += this.globalTxnId[0] << 16;
        }
        return hash;
    }

    public String toLongString() {
        int value;
        int i;
        StringBuffer data = new StringBuffer(200);
        data.append("{XID:hash(" + this.hashCode() + ")fmt(" + this.formatId + ")bq(");
        for (i = 0; i < this.bqLength; ++i) {
            value = this.branchQualifier[i] & 0xFF;
            data.append("0x" + hextab.charAt(value / 16) + hextab.charAt(value & 0xF));
            if (i == this.bqLength - 1) continue;
            data.append(",");
        }
        data.append(")gt(");
        for (i = 0; i < this.gtLength; ++i) {
            value = this.globalTxnId[i] & 0xFF;
            data.append("0x" + hextab.charAt(value / 16) + hextab.charAt(value & 0xF));
            if (i == this.gtLength - 1) continue;
            data.append(",");
        }
        data.append(")}");
        return new String(data);
    }

    public String toString() {
        int value;
        int i;
        StringBuffer data = new StringBuffer(256);
        if (this.formatId == -1) {
            return "NULL_XID";
        }
        for (i = 0; i < this.bqLength; ++i) {
            value = this.branchQualifier[i] & 0xFF;
            data.append(hextab.charAt(value / 16));
            data.append(hextab.charAt(value & 0xF));
        }
        for (i = 0; i < this.gtLength; ++i) {
            value = this.globalTxnId[i] & 0xFF;
            data.append(hextab.charAt(value / 16));
            data.append(hextab.charAt(value & 0xF));
        }
        return new String(data);
    }

    @Override
    public byte[] getBranchQualifier() {
        byte[] bq = new byte[this.bqLength];
        System.arraycopy(this.branchQualifier, 0, bq, 0, this.bqLength);
        return bq;
    }

    public void setBranchQualifier(byte[] bq) {
        this.bqLength = bq.length > 64 ? 64 : bq.length;
        System.arraycopy(bq, 0, this.branchQualifier, 0, this.bqLength);
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    public void setFormatId(int formatId) {
        this.formatId = formatId;
    }

    public boolean isEqualBranchQualifier(byte[] bq) {
        if (bq == null) {
            return this.bqLength == 0;
        }
        if (bq.length != this.bqLength) {
            return false;
        }
        for (int i = 0; i < this.bqLength; ++i) {
            if (bq[i] == this.branchQualifier[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isEqualGlobalTxnId(byte[] gt) {
        if (gt == null) {
            return this.gtLength == 0;
        }
        if (gt.length != this.gtLength) {
            return false;
        }
        for (int i = 0; i < this.gtLength; ++i) {
            if (gt[i] == this.globalTxnId[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        byte[] gt = new byte[this.gtLength];
        System.arraycopy(this.globalTxnId, 0, gt, 0, this.gtLength);
        return gt;
    }

    public void setGlobalTransactionId(byte[] gt) {
        this.gtLength = gt.length > 64 ? 64 : gt.length;
        System.arraycopy(gt, 0, this.globalTxnId, 0, this.gtLength);
    }
}

