/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.stats;

import com.sun.enterprise.admin.monitor.stats.AverageRangeStatistic;
import com.sun.enterprise.admin.monitor.stats.AverageRangeStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableBoundedRangeStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import javax.management.j2ee.statistics.BoundedRangeStatistic;
import javax.management.j2ee.statistics.Statistic;

public class MutableAverageRangeStatisticImpl
implements AverageRangeStatistic,
MutableCountStatistic {
    public static final long DEFAULT_MAX_BOUND = Long.MAX_VALUE;
    private MutableBoundedRangeStatisticImpl mutableBoundedRangeStat = null;
    private long numberOfSamples;
    private long runningTotal;
    private String description = null;

    public MutableAverageRangeStatisticImpl(BoundedRangeStatistic initial) {
        this.mutableBoundedRangeStat = new MutableBoundedRangeStatisticImpl(initial);
        this.numberOfSamples = 0L;
        this.runningTotal = 0L;
        this.description = initial.getDescription();
    }

    @Override
    public Statistic modifiableView() {
        return this;
    }

    @Override
    public Statistic unmodifiableView() {
        return new AverageRangeStatisticImpl(this.getCurrent(), this.getHighWaterMark(), this.getLowWaterMark(), this.mutableBoundedRangeStat.getUpperBound(), this.mutableBoundedRangeStat.getLowerBound(), this.mutableBoundedRangeStat.getName(), this.mutableBoundedRangeStat.getUnit(), this.mutableBoundedRangeStat.getDescription(), this.getLastSampleTime(), this.getStartTime(), this.numberOfSamples, this.runningTotal);
    }

    @Override
    public void reset() {
        this.mutableBoundedRangeStat.reset();
        this.resetAverageStats();
    }

    private void resetAverageStats() {
        this.numberOfSamples = 0L;
        this.runningTotal = 0L;
    }

    @Override
    public void setCount(long current) {
        this.mutableBoundedRangeStat.setCount(current);
        if (Long.MAX_VALUE - this.runningTotal < current) {
            this.resetAverageStats();
        }
        ++this.numberOfSamples;
        this.runningTotal += current;
    }

    @Override
    public long getAverage() {
        if (this.numberOfSamples == 0L) {
            return -1L;
        }
        return this.runningTotal / this.numberOfSamples;
    }

    public long getCurrent() {
        return this.mutableBoundedRangeStat.getCurrent();
    }

    public String getDescription() {
        return this.description;
    }

    public long getHighWaterMark() {
        return this.mutableBoundedRangeStat.getHighWaterMark();
    }

    public long getLastSampleTime() {
        return this.mutableBoundedRangeStat.getLastSampleTime();
    }

    public long getLowWaterMark() {
        long result = this.mutableBoundedRangeStat.getLowWaterMark();
        if (result == Long.MAX_VALUE) {
            result = 0L;
        }
        return result;
    }

    public String getName() {
        return this.mutableBoundedRangeStat.getName();
    }

    public long getStartTime() {
        return this.mutableBoundedRangeStat.getStartTime();
    }

    public String getUnit() {
        return this.mutableBoundedRangeStat.getUnit();
    }
}

