/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.opentracing.jaxrs;

import fish.payara.microprofile.opentracing.jaxrs.OpenTracingRequestEventListener;
import fish.payara.nucleus.requesttracing.RequestTracingService;
import fish.payara.opentracing.OpenTracingService;
import fish.payara.requesttracing.jaxrs.client.PayaraTracingServices;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Priority;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;

@Priority(value=2500)
public class OpenTracingApplicationEventListener
implements ApplicationEventListener {
    private static final Logger LOG = Logger.getLogger(OpenTracingApplicationEventListener.class.getName());
    private RequestTracingService requestTracing;
    private OpenTracingService openTracing;
    private String applicationName;
    @Context
    private ResourceInfo resourceInfo;

    @PostConstruct
    public void postConstruct() {
        LOG.finest("postConstruct()");
        PayaraTracingServices payaraTracingServices = new PayaraTracingServices();
        this.requestTracing = payaraTracingServices.getRequestTracingService();
        this.openTracing = payaraTracingServices.getOpenTracingService();
        this.applicationName = payaraTracingServices.getApplicationName();
    }

    @Override
    public void onEvent(ApplicationEvent event) {
        LOG.config(() -> "onEvent(event.type=" + (Object)((Object)event.getType()) + ")");
    }

    @Override
    public RequestEventListener onRequest(RequestEvent event) {
        LOG.finer(() -> "onRequest(event.type=" + (Object)((Object)event.getType()) + ")");
        if (!this.isRequestTracingInProgress()) {
            LOG.finest("isRequestTracingInProgress() returned false, nothing to do.");
            return null;
        }
        return new OpenTracingRequestEventListener(this.applicationName, this.resourceInfo, this.openTracing);
    }

    private boolean isRequestTracingInProgress() {
        return this.requestTracing != null && this.requestTracing.isRequestTracingEnabled() && this.requestTracing.isTraceInProgress();
    }
}

