/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.asadmin.recorder.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.ColumnFormatter;
import fish.payara.asadmin.recorder.AsadminRecorderConfiguration;
import java.util.HashMap;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-asadmin-recorder-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="get.asadmin.recorder.configuration")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="get-asadmin-recorder-configuration", description="Gets the current configuration settings of the Asadmin Recorder Service")})
public class GetAsadminRecorderConfiguration
implements AdminCommand {
    @Inject
    private Target targetUtil;
    private final String target = "server";
    private final String[] headers = new String[]{"Enabled", "Filter Commands", "Output Location", "Filtered Commands", "Prepend Enabled", "Prepended Options"};

    public void execute(AdminCommandContext context) {
        Config config = this.targetUtil.getConfig("server");
        if (config == null) {
            context.getActionReport().setMessage("No such config named: server");
            context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        AsadminRecorderConfiguration asadminRecorderConfiguration = (AsadminRecorderConfiguration)config.getExtensionByType(AsadminRecorderConfiguration.class);
        ActionReport actionReport = context.getActionReport();
        ColumnFormatter columnFormatter = new ColumnFormatter(this.headers);
        Object[] values = new Object[]{asadminRecorderConfiguration.isEnabled(), asadminRecorderConfiguration.filterCommands(), asadminRecorderConfiguration.getOutputLocation(), asadminRecorderConfiguration.getFilteredCommands(), asadminRecorderConfiguration.prependEnabled(), asadminRecorderConfiguration.getPrependedOptions()};
        columnFormatter.addRow(values);
        HashMap<String, Object> map = new HashMap<String, Object>();
        Properties extraProps = new Properties();
        map.put("enabled", values[0]);
        map.put("filterCommands", values[1]);
        map.put("outputLocation", values[2]);
        map.put("filteredCommands", values[3]);
        map.put("prependEnabled", values[4]);
        map.put("prependedOptions", values[5]);
        extraProps.put("getAsadminRecorderConfiguration", map);
        actionReport.setExtraProperties(extraProps);
        actionReport.setMessage(columnFormatter.toString());
        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

