/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.cluster;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.v3.admin.cluster.ClusterCommandHelper;
import com.sun.enterprise.v3.admin.cluster.Strings;
import fish.payara.enterprise.config.serverbeans.DeploymentGroup;
import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="restart-deployment-group")
@ExecuteOn(value={RuntimeType.DAS})
@CommandLock(value=CommandLock.LockType.NONE)
@PerLookup
@RestEndpoints(value={@RestEndpoint(configBean=DeploymentGroup.class, opType=RestEndpoint.OpType.POST, path="restart-deployment-group", description="Restart Deployment Group", params={@RestParam(name="id", value="$parent")})})
public class RestartDeploymentGroupCommand
implements AdminCommand {
    private static final String NL = System.lineSeparator();
    @Inject
    private ServerEnvironment env;
    @Inject
    private Domain domain;
    @Inject
    private CommandRunner runner;
    @Param(optional=false, primary=true)
    private String deploymentGroup;
    @Param(optional=true, defaultValue="false")
    private boolean verbose;
    @Param(optional=true, defaultValue="true")
    private boolean rolling;
    @Param(optional=true, defaultValue="5000")
    private String delay;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        logger.info(Strings.get("restart.dg", this.deploymentGroup));
        if (!this.env.isDas()) {
            String msg = Strings.get("cluster.command.notDas");
            logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        if (this.rolling) {
            this.doRolling(context);
        } else {
            ClusterCommandHelper clusterHelper = new ClusterCommandHelper(this.domain, this.runner);
            ParameterMap pm = new ParameterMap();
            pm.add((Object)"delay", (Object)this.delay);
            try {
                String commandName = "restart-instance";
                clusterHelper.runCommand(commandName, pm, this.deploymentGroup, context, this.verbose, this.rolling);
            }
            catch (CommandException e) {
                String msg = e.getLocalizedMessage();
                logger.warning(msg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(msg);
            }
        }
    }

    private void doRolling(AdminCommandContext context) {
        List servers = this.domain.getServersInTarget(this.deploymentGroup);
        StringBuilder output = new StringBuilder();
        Logger logger = context.getLogger();
        for (Server server : servers) {
            ParameterMap instanceParameterMap = new ParameterMap();
            instanceParameterMap.set((Object)"DEFAULT", (Object)server.getName());
            ActionReport instanceReport = this.runner.getActionReport("plain");
            instanceReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            CommandRunner.CommandInvocation invocation = this.runner.getCommandInvocation("stop-instance", instanceReport, context.getSubject());
            invocation.parameters(instanceParameterMap);
            String msg = "stop-instance " + server.getName();
            logger.info(msg);
            if (this.verbose) {
                output.append(msg).append(NL);
            }
            invocation.execute();
            logger.info(invocation.report().getMessage());
            if (this.verbose) {
                output.append(invocation.report().getMessage()).append(NL);
            }
            instanceParameterMap = new ParameterMap();
            instanceParameterMap.set((Object)"DEFAULT", (Object)server.getName());
            instanceReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            invocation = this.runner.getCommandInvocation("start-instance", instanceReport, context.getSubject());
            invocation.parameters(instanceParameterMap);
            msg = "start-instance " + server.getName();
            logger.info(msg);
            if (this.verbose) {
                output.append(msg).append(NL);
            }
            invocation.execute();
            logger.info(invocation.report().getMessage());
            if (this.verbose) {
                output.append(invocation.report().getMessage()).append(NL);
            }
            try {
                long delayVal = Long.parseLong(this.delay);
                if (delayVal <= 0L) continue;
                Thread.sleep(delayVal);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

