/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.LocalInstanceCommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import com.sun.enterprise.util.StringUtils;
import java.io.File;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="delete-local-instance")
@PerLookup
public class DeleteLocalInstanceCommand
extends LocalInstanceCommand {
    @Param(name="instance_name", primary=true, optional=true)
    private String instanceName0;

    @Override
    protected void initInstance() throws CommandException {
        try {
            super.initInstance();
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommandException(Strings.get("DeleteInstance.noInstance"));
        }
    }

    @Override
    protected boolean mkdirs(File f) {
        return false;
    }

    @Override
    protected void validate() throws CommandException, CommandValidationException {
        this.instanceName = this.instanceName0;
        super.validate();
        if (!StringUtils.ok((String)this.getServerDirs().getServerName())) {
            throw new CommandException(Strings.get("DeleteInstance.noInstanceName"));
        }
        File dasProperties = this.getServerDirs().getDasPropertiesFile();
        if (dasProperties.isFile()) {
            this.setDasDefaults(dasProperties);
        }
        if (!this.getServerDirs().getServerDir().isDirectory()) {
            throw new CommandException(Strings.get("DeleteInstance.noWhack", this.getServerDirs().getServerDir()));
        }
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        if (this.isRunning()) {
            throw new CommandException(Strings.get("DeleteInstance.running"));
        }
        this.doRemote();
        this.whackFilesystem();
        return 0;
    }

    private void doRemote() throws CommandException {
        if (!this.isDASRunning()) {
            String newString = Strings.get("DeleteInstance.remoteError", this.programOpts.getHost(), "" + this.programOpts.getPort());
            throw new CommandException(newString);
        }
        if (this.isRegisteredToDas()) {
            RemoteCLICommand rc = new RemoteCLICommand("_unregister-instance", this.programOpts, this.env);
            rc.execute(new String[]{"_unregister-instance", this.getServerDirs().getServerName()});
        }
    }

    private boolean isDASRunning() {
        try {
            this.getUptime();
            return true;
        }
        catch (CommandException ex) {
            return false;
        }
    }

    private boolean isRegisteredToDas() {
        boolean isRegistered;
        String instanceDottedName = "servers.server." + this.instanceName;
        try {
            RemoteCLICommand rc = new RemoteCLICommand("get", this.programOpts, this.env);
            rc.executeAndReturnOutput(new String[]{"get", instanceDottedName});
            isRegistered = true;
        }
        catch (CommandException ce) {
            isRegistered = false;
        }
        return isRegistered;
    }
}

