/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.cli.cluster;

import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.CommandException;

public class NamingHelper {
    public static List<String> getAllNamesInUse(ProgramOptions programOptions, Environment environment) {
        ArrayList<String> namesInUse = new ArrayList<String>();
        namesInUse.addAll(NamingHelper.getNames(programOptions, environment, "servers"));
        namesInUse.addAll(NamingHelper.getNames(programOptions, environment, "configs"));
        namesInUse.addAll(NamingHelper.getNames(programOptions, environment, "nodes"));
        namesInUse.addAll(NamingHelper.getNames(programOptions, environment, "clusters"));
        namesInUse.addAll(NamingHelper.getNames(programOptions, environment, "deployment-groups"));
        return namesInUse;
    }

    private static List<String> getNames(ProgramOptions programOptions, Environment environment, String dottedNameRoot) {
        ArrayList<String> names;
        block3: {
            names = new ArrayList<String>();
            try {
                RemoteCLICommand rc = new RemoteCLICommand("get", programOptions, environment);
                String returnOutput = rc.executeAndReturnOutput(new String[]{"get", dottedNameRoot + ".*.name"});
                if (returnOutput != null && !returnOutput.isEmpty()) {
                    List<String> splitReturnOutput = Arrays.asList(returnOutput.split("\n"));
                    splitReturnOutput.forEach(dottedConfig -> {
                        String name;
                        if (!dottedConfig.contains("system-property") && !names.contains(name = dottedConfig.substring(dottedConfig.indexOf("=") + 1).replace("\r", ""))) {
                            names.add(name);
                        }
                    });
                }
            }
            catch (CommandException ce) {
                if (ce.getMessage().equals("remote failure: Dotted name path " + dottedNameRoot + ".*.name not found.")) break block3;
                Logger.getLogger(NamingHelper.class.getName()).log(Level.WARNING, "Error executing command", ce);
            }
        }
        return names;
    }
}

