/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.config.extensions.oauth;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.function.Supplier;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;

public class OAuth2Client {
    private final Supplier<Response> invocation;
    private Response lastResponse;
    private volatile Instant lastResponseTime;
    private volatile Duration expiryTime;

    public OAuth2Client(String authUrl, String referrer, Map<? extends Serializable, ? extends Serializable> data) {
        WebTarget target = ClientBuilder.newClient().target(authUrl);
        Form input = new Form();
        data.forEach((key, value) -> input.param(key.toString(), value.toString()));
        Entity entity = Entity.entity((Object)input, (String)"application/x-www-form-urlencoded");
        Invocation.Builder requestBuilder = target.request().header("Content-Type", (Object)"application/x-www-form-urlencoded").accept(new String[]{"application/json"});
        if (referrer != null && !referrer.isEmpty()) {
            requestBuilder = requestBuilder.header("referrer", (Object)referrer);
        }
        Invocation.Builder invocationTarget = requestBuilder;
        this.invocation = () -> invocationTarget.post(entity);
    }

    public OAuth2Client(String authUrl, Map<? extends Serializable, ? extends Serializable> data) {
        this(authUrl, null, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response authenticate() {
        if (this.lastResponse == null || this.checkExpiry()) {
            OAuth2Client oAuth2Client = this;
            synchronized (oAuth2Client) {
                if (this.lastResponse == null || this.checkExpiry()) {
                    Response result = this.invocation.get();
                    this.lastResponseTime = Instant.now();
                    if (result.getStatus() == 200) {
                        this.lastResponse = result;
                        this.lastResponse.bufferEntity();
                    }
                    return result;
                }
            }
        }
        return this.lastResponse;
    }

    public void expire(Duration expiryTime) {
        this.expiryTime = expiryTime;
    }

    private final boolean checkExpiry() {
        return this.lastResponseTime == null || this.expiryTime == null || this.lastResponseTime.plus(this.expiryTime).isBefore(Instant.now());
    }
}

