/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.internal.notification.NotifierUtils;
import fish.payara.internal.notification.TimeUtil;
import fish.payara.nucleus.healthcheck.HealthCheckService;
import fish.payara.nucleus.healthcheck.configuration.HealthCheckServiceConfiguration;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.validation.constraints.Min;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Deprecated
@Service(name="healthcheck-configure")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="healthcheck.configure")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=HealthCheckServiceConfiguration.class, opType=RestEndpoint.OpType.POST, path="healthcheck-configure", description="Enables/Disables Health Check Service")})
public class HealthCheckConfigurer
implements AdminCommand {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(HealthCheckConfigurer.class);
    @Inject
    ServerEnvironment server;
    @Inject
    protected Logger logger;
    @Inject
    HealthCheckService service;
    @Inject
    ServiceLocator serviceLocator;
    @Inject
    protected Target targetUtil;
    @Param(name="dynamic", optional=true, defaultValue="false")
    protected Boolean dynamic;
    @Param(name="target", optional=true, defaultValue="server-config")
    protected String target;
    @Param(name="enabled")
    private Boolean enabled;
    @Deprecated
    @Param(name="notifierEnabled", optional=true)
    private Boolean notifierEnabled;
    @Param(name="historicalTraceEnabled", optional=true)
    private Boolean historicalTraceEnabled;
    @Param(name="historicalTraceStoreSize", optional=true, defaultValue="20")
    @Min(value=1L, message="Store size must be greater than 0")
    private @Min(value=1L, message="Store size must be greater than 0") Integer historicalTraceStoreSize;
    @Param(name="historicalTraceStoreTimeout", optional=true)
    private String historicalTraceStoreTimeout;
    @Param(name="enableNotifiers", alias="enable-notifiers", optional=true)
    private List<String> enableNotifiers;
    @Param(name="disableNotifiers", alias="disable-notifiers", optional=true)
    private List<String> disableNotifiers;
    @Param(name="setNotifiers", alias="set-notifiers", optional=true)
    private List<String> setNotifiers;

    public void execute(AdminCommandContext context) {
        Config config;
        HealthCheckServiceConfiguration healthCheckServiceConfiguration;
        final ActionReport actionReport = context.getActionReport();
        Properties extraProperties = actionReport.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            actionReport.setExtraProperties(extraProperties);
        }
        if ((healthCheckServiceConfiguration = (HealthCheckServiceConfiguration)(config = this.targetUtil.getConfig(this.target)).getExtensionByType(HealthCheckServiceConfiguration.class)) != null) {
            try {
                final Set notifierNames = NotifierUtils.getNotifierNames((ServiceLocator)this.serviceLocator);
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HealthCheckServiceConfiguration>(){

                    public Object run(HealthCheckServiceConfiguration proxy) throws PropertyVetoException, TransactionFailure {
                        if (HealthCheckConfigurer.this.enabled != null) {
                            proxy.enabled(HealthCheckConfigurer.this.enabled.toString());
                        }
                        if (HealthCheckConfigurer.this.historicalTraceEnabled != null) {
                            proxy.setHistoricalTraceEnabled(HealthCheckConfigurer.this.historicalTraceEnabled.toString());
                        }
                        if (HealthCheckConfigurer.this.historicalTraceStoreSize != null) {
                            proxy.setHistoricalTraceStoreSize(HealthCheckConfigurer.this.historicalTraceStoreSize.toString());
                        }
                        if (HealthCheckConfigurer.this.historicalTraceStoreTimeout != null) {
                            proxy.setHistoricalTraceStoreTimeout(HealthCheckConfigurer.this.historicalTraceStoreTimeout.toString());
                        }
                        List<String> notifiers = proxy.getNotifierList();
                        if (HealthCheckConfigurer.this.enableNotifiers != null) {
                            for (String notifier : HealthCheckConfigurer.this.enableNotifiers) {
                                if (notifierNames.contains(notifier)) {
                                    notifiers.add(notifier);
                                    continue;
                                }
                                throw new PropertyVetoException("Unrecognised notifier " + notifier, new PropertyChangeEvent(proxy, "notifiers", notifiers, notifiers));
                            }
                        }
                        if (HealthCheckConfigurer.this.disableNotifiers != null) {
                            for (String notifier : HealthCheckConfigurer.this.disableNotifiers) {
                                if (notifierNames.contains(notifier)) {
                                    notifiers.remove(notifier);
                                    continue;
                                }
                                throw new PropertyVetoException("Unrecognised notifier " + notifier, new PropertyChangeEvent(proxy, "notifiers", notifiers, notifiers));
                            }
                        }
                        if (HealthCheckConfigurer.this.setNotifiers != null) {
                            notifiers.clear();
                            for (String notifier : HealthCheckConfigurer.this.setNotifiers) {
                                if (notifierNames.contains(notifier)) {
                                    if (notifiers.contains(notifier)) continue;
                                    notifiers.add(notifier);
                                    continue;
                                }
                                throw new PropertyVetoException("Unrecognised notifier " + notifier, new PropertyChangeEvent(proxy, "notifiers", notifiers, notifiers));
                            }
                        }
                        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return proxy;
                    }
                }, (ConfigBeanProxy)healthCheckServiceConfiguration);
            }
            catch (TransactionFailure ex) {
                this.logger.log(Level.WARNING, "Exception during command ", ex);
                actionReport.setMessage(ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage());
                actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        if (this.dynamic.booleanValue()) {
            if (this.server.isDas()) {
                if (this.targetUtil.getConfig(this.target).isDas()) {
                    this.configureDynamically();
                }
            } else {
                this.configureDynamically();
            }
        }
    }

    private void configureDynamically() {
        this.service.setEnabled(this.enabled);
        if (this.historicalTraceEnabled != null) {
            this.service.setHistoricalTraceEnabled(this.historicalTraceEnabled);
        }
        if (this.historicalTraceStoreSize != null) {
            this.service.setHistoricalTraceStoreSize(this.historicalTraceStoreSize);
        }
        if (this.historicalTraceStoreTimeout != null) {
            long timeout = TimeUtil.setStoreTimeLimit((String)this.historicalTraceStoreTimeout);
            this.service.setHistoricalTraceStoreTimeout(timeout);
        }
        Set<String> notifiers = this.service.getEnabledNotifiers();
        if (this.enableNotifiers != null) {
            this.enableNotifiers.forEach(notifiers::add);
        }
        if (this.disableNotifiers != null) {
            this.disableNotifiers.forEach(notifiers::remove);
        }
        if (this.setNotifiers != null) {
            notifiers.clear();
            this.setNotifiers.forEach(notifiers::add);
        }
    }
}

