/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.admin;

import com.sun.enterprise.config.serverbeans.Config;
import fish.payara.internal.notification.NotifierUtils;
import fish.payara.internal.notification.TimeUtil;
import fish.payara.nucleus.healthcheck.HealthCheckService;
import fish.payara.nucleus.healthcheck.configuration.HealthCheckServiceConfiguration;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.validation.constraints.Min;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-healthcheck-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="healthcheck.configure")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=HealthCheckServiceConfiguration.class, opType=RestEndpoint.OpType.POST, path="set-healthcheck-configuration", description="Enables/Disables Health Check Service")})
public class SetHealthCheckConfiguration
implements AdminCommand {
    @Inject
    ServerEnvironment server;
    @Inject
    private Logger logger;
    @Inject
    HealthCheckService healthCheck;
    @Inject
    ServiceLocator serviceLocator;
    @Inject
    private Target targetUtil;
    private Config targetConfig;
    @Param(name="dynamic", optional=true, defaultValue="false")
    private boolean dynamic;
    @Param(name="target", optional=true, defaultValue="server-config")
    private String target;
    @Param(name="enabled", optional=true)
    private Boolean enabled;
    @Param(name="historical-trace-enabled", optional=true)
    private Boolean historicalTraceEnabled;
    @Param(name="historical-trace-store-size", optional=true, defaultValue="20")
    @Min(value=1L, message="Store size must be greater than 0")
    private @Min(value=1L, message="Store size must be greater than 0") int historicalTraceStoreSize;
    @Param(name="historical-trace-store-timeout", optional=true)
    private String historicalTraceStoreTimeout;
    @Param(name="enableNotifiers", alias="enable-notifiers", optional=true)
    private List<String> enableNotifiers;
    @Param(name="disableNotifiers", alias="disable-notifiers", optional=true)
    private List<String> disableNotifiers;
    @Param(name="setNotifiers", alias="set-notifiers", optional=true)
    private List<String> setNotifiers;

    public void execute(AdminCommandContext context) {
        this.targetConfig = this.targetUtil.getConfig(this.target);
        HealthCheckServiceConfiguration config = (HealthCheckServiceConfiguration)this.targetConfig.getExtensionByType(HealthCheckServiceConfiguration.class);
        if (config != null) {
            this.updateConfig(config, context);
        }
        if (this.dynamic && (!this.server.isDas() || this.targetConfig.isDas())) {
            this.configureDynamically();
        }
    }

    private static ActionReport initActionReport(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (report.getExtraProperties() == null) {
            report.setExtraProperties(new Properties());
        }
        return report;
    }

    private void updateConfig(HealthCheckServiceConfiguration config, AdminCommandContext context) {
        ActionReport report = SetHealthCheckConfiguration.initActionReport(context);
        try {
            Set notifierNames = NotifierUtils.getNotifierNames((ServiceLocator)this.serviceLocator);
            ConfigSupport.apply(configProxy -> {
                if (this.enabled != null) {
                    configProxy.enabled(this.enabled.toString());
                }
                configProxy.setHistoricalTraceStoreSize(String.valueOf(this.historicalTraceStoreSize));
                if (this.historicalTraceEnabled != null) {
                    configProxy.setHistoricalTraceEnabled(this.historicalTraceEnabled.toString());
                }
                if (this.historicalTraceStoreTimeout != null) {
                    configProxy.setHistoricalTraceStoreTimeout(this.historicalTraceStoreTimeout.toString());
                }
                List<String> notifiers = configProxy.getNotifierList();
                if (this.enableNotifiers != null) {
                    for (String notifier : this.enableNotifiers) {
                        if (notifierNames.contains(notifier)) {
                            if (notifiers.contains(notifier)) continue;
                            notifiers.add(notifier);
                            continue;
                        }
                        throw new PropertyVetoException("Unrecognised notifier " + notifier, new PropertyChangeEvent(configProxy, "notifiers", notifiers, notifiers));
                    }
                }
                if (this.disableNotifiers != null) {
                    for (String notifier : this.disableNotifiers) {
                        if (notifierNames.contains(notifier)) {
                            notifiers.remove(notifier);
                            continue;
                        }
                        throw new PropertyVetoException("Unrecognised notifier " + notifier, new PropertyChangeEvent(configProxy, "notifiers", notifiers, notifiers));
                    }
                }
                if (this.setNotifiers != null) {
                    notifiers.clear();
                    for (String notifier : this.setNotifiers) {
                        if (notifierNames.contains(notifier)) {
                            if (notifiers.contains(notifier)) continue;
                            notifiers.add(notifier);
                            continue;
                        }
                        throw new PropertyVetoException("Unrecognised notifier " + notifier, new PropertyChangeEvent(configProxy, "notifiers", notifiers, notifiers));
                    }
                }
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                return configProxy;
            }, (ConfigBeanProxy)config);
        }
        catch (TransactionFailure ex) {
            this.logger.log(Level.WARNING, "Exception during command ", ex);
            report.setMessage(ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
    }

    private void configureDynamically() {
        if (this.enabled != null) {
            this.healthCheck.setEnabled(this.enabled);
        }
        this.healthCheck.setHistoricalTraceStoreSize(this.historicalTraceStoreSize);
        if (this.historicalTraceEnabled != null) {
            this.healthCheck.setHistoricalTraceEnabled(this.historicalTraceEnabled);
        }
        if (this.historicalTraceStoreTimeout != null) {
            this.healthCheck.setHistoricalTraceStoreTimeout(TimeUtil.setStoreTimeLimit((String)this.historicalTraceStoreTimeout));
        }
        Set<String> notifiers = this.healthCheck.getEnabledNotifiers();
        if (this.enableNotifiers != null) {
            this.enableNotifiers.forEach(notifiers::add);
        }
        if (this.disableNotifiers != null) {
            this.disableNotifiers.forEach(notifiers::remove);
        }
        if (this.setNotifiers != null) {
            notifiers.clear();
            this.setNotifiers.forEach(notifiers::add);
        }
    }
}

