/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.preliminary;

import fish.payara.internal.notification.TimeUtil;
import fish.payara.monitoring.collect.MonitoringData;
import fish.payara.monitoring.collect.MonitoringDataCollector;
import fish.payara.monitoring.collect.MonitoringDataSource;
import fish.payara.monitoring.collect.MonitoringWatchCollector;
import fish.payara.monitoring.collect.MonitoringWatchSource;
import fish.payara.notification.healthcheck.HealthCheckResultEntry;
import fish.payara.notification.healthcheck.HealthCheckResultStatus;
import fish.payara.nucleus.healthcheck.HealthCheckResult;
import fish.payara.nucleus.healthcheck.HealthCheckWithThresholdExecutionOptions;
import fish.payara.nucleus.healthcheck.configuration.GarbageCollectorChecker;
import fish.payara.nucleus.healthcheck.preliminary.BaseThresholdHealthCheck;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="healthcheck-gc")
@RunLevel(value=10)
public class GarbageCollectorHealthCheck
extends BaseThresholdHealthCheck<HealthCheckWithThresholdExecutionOptions, GarbageCollectorChecker>
implements MonitoringDataSource,
MonitoringWatchSource {
    private final GcUsage youngHealthCheck = new GcUsage();
    private final GcUsage oldHealthCheck = new GcUsage();
    private final Map<String, GcUsage> collect = new ConcurrentHashMap<String, GcUsage>();

    @PostConstruct
    void postConstruct() {
        this.postConstruct(this, GarbageCollectorChecker.class);
    }

    @Override
    public HealthCheckWithThresholdExecutionOptions constructOptions(GarbageCollectorChecker checker) {
        return super.constructThresholdOptions(checker);
    }

    @Override
    protected String getDescription() {
        return "healthcheck.description.garbageCollector";
    }

    @Override
    protected HealthCheckResult doCheckInternal() {
        HealthCheckResult result = new HealthCheckResult();
        for (GarbageCollectorMXBean gcBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (GarbageCollectorHealthCheck.isYoungGenerationGC(gcBean)) {
                result.add(new HealthCheckResultEntry(this.decideOnStatusWithRatio(this.youngHealthCheck.percentage(gcBean)), this.youngHealthCheck.getNumberOfGcs() + " times Young GC (" + gcBean.getName() + ") collecting for " + TimeUtil.prettyPrintDuration((long)this.youngHealthCheck.getTimeSpendDoingGc())));
                continue;
            }
            if (GarbageCollectorHealthCheck.isOldGenerationGC(gcBean)) {
                result.add(new HealthCheckResultEntry(this.decideOnStatusWithRatio(this.oldHealthCheck.percentage(gcBean)), this.oldHealthCheck.getNumberOfGcs() + " times Old GC (" + gcBean.getName() + ") after " + TimeUtil.prettyPrintDuration((long)this.oldHealthCheck.getTimeSpendDoingGc())));
                continue;
            }
            result.add(new HealthCheckResultEntry(HealthCheckResultStatus.CHECK_ERROR, "Could not identify GarbageCollectorMXBean with name: " + gcBean.getName()));
        }
        return result;
    }

    public void collect(MonitoringWatchCollector collector) {
        this.collectUsage(collector, "ns:health TotalGcPercentage", "GC Percentage", 10, true);
    }

    @MonitoringData(ns="health", intervalSeconds=4)
    public void collect(MonitoringDataCollector collector) {
        if (this.options == null || !((HealthCheckWithThresholdExecutionOptions)this.options).isEnabled()) {
            return;
        }
        for (GarbageCollectorMXBean gcBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            GcUsage usage = this.collect.computeIfAbsent(gcBean.getName(), key -> new GcUsage());
            double percentage = usage.percentage(gcBean);
            if (GarbageCollectorHealthCheck.isYoungGenerationGC(gcBean)) {
                GarbageCollectorHealthCheck.collectGcUage(collector, "Young", percentage, usage.getNumberOfGcs(), usage.getTimeSpendDoingGc());
                continue;
            }
            if (!GarbageCollectorHealthCheck.isOldGenerationGC(gcBean)) continue;
            GarbageCollectorHealthCheck.collectGcUage(collector, "Old", percentage, usage.getNumberOfGcs(), usage.getTimeSpendDoingGc());
        }
        long timeSpendDoingGc = 0L;
        long timePassed = 0L;
        long numberOfGcs = 0L;
        for (GcUsage u : this.collect.values()) {
            timePassed = Math.max(timePassed, u.getTimePassed());
            timeSpendDoingGc += u.getTimeSpendDoingGc();
            numberOfGcs += u.getNumberOfGcs();
        }
        double usage = timePassed == 0L ? 0.0 : 100.0 * (double)timeSpendDoingGc / (double)timePassed;
        GarbageCollectorHealthCheck.collectGcUage(collector, "Total", usage, numberOfGcs, timeSpendDoingGc);
    }

    private static void collectGcUage(MonitoringDataCollector collector, String label, double usage, long numberOfGcs, long timeSpendDoingGc) {
        collector.collect((CharSequence)(label + "GcPercentage"), (long)usage).collect((CharSequence)(label + "GcCount"), numberOfGcs).collect((CharSequence)(label + "GcDuration"), timeSpendDoingGc);
    }

    private static boolean isOldGenerationGC(GarbageCollectorMXBean gcBean) {
        String name = gcBean.getName();
        return "PS MarkSweep".equals(name) || "G1 Old Generation".equals(name) || "MarkSweepCompact".equals(name) || "ConcurrentMarkSweep".equals(name);
    }

    private static boolean isYoungGenerationGC(GarbageCollectorMXBean gcBean) {
        String name = gcBean.getName();
        return "PS Scavenge".equals(name) || "G1 Young Generation".equals(name) || "Copy".equals(name) || "ParNew".equals(name);
    }

    private static final class GcUsage {
        private volatile long timeLastChecked;
        private volatile long lastCollectionCount;
        private volatile long lastCollectionTime;
        private volatile long timeSpendDoingGc;
        private volatile long numberOfGcs;
        private volatile long timePassed;

        GcUsage() {
        }

        public double percentage(GarbageCollectorMXBean gcBean) {
            long collectionCount = gcBean.getCollectionCount();
            this.numberOfGcs = collectionCount - this.lastCollectionCount;
            this.lastCollectionCount = collectionCount;
            long collectionTime = gcBean.getCollectionTime();
            this.timeSpendDoingGc = collectionTime - this.lastCollectionTime;
            this.lastCollectionTime = collectionTime;
            long now = System.currentTimeMillis();
            this.timePassed = now - this.timeLastChecked;
            this.timeLastChecked = now;
            return this.numberOfGcs == 0L || this.lastCollectionCount == 0L ? 0.0 : 100.0 * (double)this.timeSpendDoingGc / (double)this.timePassed;
        }

        long getNumberOfGcs() {
            return this.numberOfGcs;
        }

        long getTimeSpendDoingGc() {
            return this.timeSpendDoingGc;
        }

        long getTimePassed() {
            return this.timePassed;
        }
    }
}

