/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.source;

import fish.payara.nucleus.microprofile.config.source.PayaraConfigSource;
import fish.payara.nucleus.microprofile.config.spi.ConfigProviderResolverImpl;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class DirConfigSource
extends PayaraConfigSource
implements ConfigSource {
    private static final Logger logger = Logger.getLogger(DirConfigSource.class.getName());
    public static final String DEFAULT_DIR = "secrets";
    private Path directory;
    private final ConcurrentHashMap<String, DirProperty> properties = new ConcurrentHashMap();

    public DirConfigSource() {
        try {
            Optional<Path> dir = this.findDir();
            if (dir.isPresent()) {
                this.directory = dir.get();
                this.configService.getExecutor().scheduleWithFixedDelay((Runnable)this.createWatcher(this.directory), 0L, 1L, TimeUnit.SECONDS);
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "MPCONFIG DirConfigSource: error during setup.", e);
        }
    }

    DirConfigSource(Path directory, ConfigProviderResolverImpl configService) {
        super(configService);
        this.directory = directory;
    }

    DirPropertyWatcher createWatcher(Path topmostDirectory) throws IOException {
        return new DirPropertyWatcher(topmostDirectory);
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((DirProperty)e.getValue()).propertyValue)));
    }

    void setProperties(Map<String, DirProperty> properties) {
        this.properties.clear();
        this.properties.putAll(properties);
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public int getOrdinal() {
        String storedOrdinal = this.getValue("config_ordinal");
        if (storedOrdinal != null) {
            return Integer.parseInt(storedOrdinal);
        }
        return Integer.parseInt(this.configService.getMPConfig().getSecretDirOrdinality());
    }

    public String getValue(String property) {
        DirProperty result = this.properties.get(property);
        return result == null ? null : result.propertyValue;
    }

    public String getName() {
        return "Directory";
    }

    Optional<Path> findDir() throws IOException {
        String path = this.configService.getMPConfig().getSecretDir();
        if (path == null) {
            return Optional.empty();
        }
        ArrayList<Path> candidates = new ArrayList<Path>();
        candidates.add(Paths.get(path, new String[0]));
        if (!Paths.get(path, new String[0]).isAbsolute()) {
            candidates.add(Paths.get(System.getProperty("com.sun.aas.instanceRoot"), path).normalize());
        }
        for (Path candidate : candidates) {
            if (!DirConfigSource.isAptDir(candidate)) continue;
            return Optional.of(candidate);
        }
        Level lvl = Level.SEVERE;
        if (path.equals(DEFAULT_DIR)) {
            lvl = Level.FINE;
        }
        logger.log(lvl, "Given MPCONFIG directory '" + path + "' is no directory, cannot be read or has a leading dot.");
        return Optional.empty();
    }

    final boolean upsertPropertyFromPath(Path path, BasicFileAttributes mainAtts) throws IOException {
        String property;
        if (DirConfigSource.isAptFile(path, mainAtts) && this.isLongestMatchForPath(property = DirConfigSource.parsePropertyNameFromPath(path, this.directory), path)) {
            this.properties.put(property, DirConfigSource.readPropertyFromPath(path, mainAtts, this.directory));
            return true;
        }
        return false;
    }

    final void removePropertyFromPath(Path path) {
        String property = DirConfigSource.parsePropertyNameFromPath(path, this.directory);
        if (!this.properties.containsKey(property)) {
            return;
        }
        if (path.equals(this.properties.get((Object)property).path)) {
            this.properties.remove(property);
        }
    }

    final boolean isLongestMatchForPath(String property, Path newPath) {
        if (newPath == null || property == null || property.isEmpty()) {
            return false;
        }
        if (!this.properties.containsKey(property)) {
            return true;
        }
        DirProperty old = this.properties.get(property);
        return DirConfigSource.isLongestMatchForPath(this.directory, old.path, newPath);
    }

    static final boolean isLongestMatchForPath(Path rootDir, Path oldPath, Path newPath) {
        int newPathDepth;
        if (oldPath.equals(newPath)) {
            return true;
        }
        int oldPathDepth = rootDir.relativize(oldPath).getNameCount();
        if (oldPathDepth < (newPathDepth = rootDir.relativize(newPath).getNameCount())) {
            return true;
        }
        if (oldPathDepth == newPathDepth) {
            String oldPathS = oldPath.toString();
            String newPathS = newPath.toAbsolutePath().toString();
            int offset = 0;
            while (offset > -1) {
                if (newPathS.indexOf(".", offset) > oldPathS.indexOf(".", offset)) {
                    return true;
                }
                offset = oldPathS.indexOf(".", offset + 1);
            }
        }
        return false;
    }

    public static final boolean isAptDir(Path path) throws IOException {
        return path != null && Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]) && Files.isReadable(path) && !path.getFileName().toString().startsWith(".");
    }

    public static final boolean isAptFile(Path path, BasicFileAttributes atts) throws IOException {
        return path != null && Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0]) && Files.isReadable(path) && !path.getFileName().toString().startsWith(".") && atts.size() < 524288L;
    }

    public static final String parsePropertyNameFromPath(Path path, Path rootDir) {
        String property = "";
        if (!path.getParent().equals(rootDir)) {
            property = property + rootDir.relativize(path.getParent()).toString() + File.separatorChar;
        }
        property = property + path.getFileName();
        property = property.replace(File.separatorChar, '.');
        return property;
    }

    static final DirProperty readPropertyFromPath(Path path, BasicFileAttributes mainAtts, Path rootPath) throws IOException {
        if (Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0]) && Files.isReadable(path)) {
            return new DirProperty(new String(Files.readAllBytes(path), StandardCharsets.UTF_8), mainAtts.lastModifiedTime(), path.toAbsolutePath());
        }
        throw new IOException("Cannot read property from '" + path.toString() + "'.");
    }

    final class DirPropertyWatcher
    implements Runnable {
        private final Logger logger = Logger.getLogger(DirConfigSource.class.getName());
        private final WatchService watcher = FileSystems.getDefault().newWatchService();
        private final ConcurrentHashMap<WatchKey, Path> watchedFileKeys = new ConcurrentHashMap();

        DirPropertyWatcher(Path topmostDir) throws IOException {
            if (!(Files.exists(topmostDir, new LinkOption[0]) && Files.isDirectory(topmostDir, new LinkOption[0]) && Files.isReadable(topmostDir))) {
                throw new IOException("Given directory '" + topmostDir + "' is no directory or cannot be read.");
            }
            this.registerAll(topmostDir);
        }

        final void registerAll(Path dir) throws IOException {
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (DirConfigSource.isAptDir(dir)) {
                        DirPropertyWatcher.this.register(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes mainAtts) throws IOException {
                    DirConfigSource.this.upsertPropertyFromPath(path, mainAtts);
                    return FileVisitResult.CONTINUE;
                }
            });
        }

        final void register(Path dir) throws IOException {
            WatchKey key = dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            this.watchedFileKeys.putIfAbsent(key, dir);
            this.logger.finer("MPCONFIG DirConfigSource: registered \"" + dir + "\" as key \"" + key + "\".");
        }

        @Override
        public final void run() {
            WatchKey key;
            try {
                key = this.watcher.take();
            }
            catch (InterruptedException ex) {
                this.logger.info("MPCONFIG DirConfigSource: shutting down watcher thread.");
                return;
            }
            Path workDir = this.watchedFileKeys.get(key);
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                WatchEvent<?> ev = event;
                Path fileName = (Path)ev.context();
                Path path = workDir.resolve(fileName);
                this.logger.finer("MPCONFIG DirConfigSource: detected change: " + fileName.toString() + " : " + kind.toString());
                try {
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE && DirConfigSource.isAptDir(path)) {
                        this.logger.finer("MPCONFIG DirConfigSource: registering new paths.");
                        this.registerAll(path);
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_MODIFY || kind == StandardWatchEventKinds.ENTRY_CREATE && Files.isSymbolicLink(path)) {
                        this.logger.finer("MPCONFIG DirConfigSource: processing new or updated file \"" + path.toString() + "\".");
                        BasicFileAttributes atts = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                        DirConfigSource.this.upsertPropertyFromPath(path, atts);
                    }
                    if (!Files.notExists(path, new LinkOption[0]) || this.watchedFileKeys.containsValue(path) || kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                    this.logger.finer("MPCONFIG DirConfigSource: removing deleted file \"" + path.toString() + "\".");
                    DirConfigSource.this.removePropertyFromPath(path);
                }
                catch (IOException e) {
                    this.logger.log(Level.WARNING, "MPCONFIG DirConfigSource: could not process event '" + kind + "' on '" + path + "'", e);
                }
            }
            boolean valid = key.reset();
            if (!valid) {
                this.logger.finer("MPCONFIG DirConfigSource: removing watcher for key \"" + key + "\".");
                this.watchedFileKeys.remove(key);
            }
        }
    }

    static final class DirProperty {
        final String propertyValue;
        final FileTime lastModifiedTime;
        final Path path;

        DirProperty(String propertyValue, FileTime lastModifiedTime, Path path) {
            this.propertyValue = propertyValue;
            this.lastModifiedTime = lastModifiedTime;
            this.path = path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DirProperty that = (DirProperty)o;
            return this.propertyValue.equals(that.propertyValue) && this.lastModifiedTime.equals(that.lastModifiedTime) && this.path.equals(that.path);
        }

        public int hashCode() {
            return Objects.hash(this.propertyValue, this.lastModifiedTime, this.path);
        }
    }
}

