/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.source.extension;

import fish.payara.nucleus.microprofile.config.source.extension.ExtensionConfigSource;
import fish.payara.nucleus.microprofile.config.spi.ConfigSourceConfiguration;
import java.lang.reflect.ParameterizedType;
import org.glassfish.hk2.api.ServiceHandle;

public class ConfigSourceExtensions {
    private ConfigSourceExtensions() {
    }

    public static final String getName(ServiceHandle<? extends ExtensionConfigSource> handle) {
        String configSourceName = handle.getService().getName();
        if (configSourceName != null && !configSourceName.isEmpty()) {
            return configSourceName;
        }
        String serviceName = handle.getActiveDescriptor().getName();
        if (serviceName != null && !serviceName.isEmpty()) {
            return serviceName;
        }
        String className = handle.getActiveDescriptor().getImplementationClass().getSimpleName();
        if (className != null && !className.isEmpty()) {
            return className;
        }
        return "null";
    }

    public static <C extends ConfigSourceConfiguration> Class<C> getConfigurationClass(Class<?> configSourceClass) {
        ParameterizedType genericSuperclass = (ParameterizedType)configSourceClass.getGenericSuperclass();
        if (genericSuperclass == null) {
            return null;
        }
        return (Class)genericSuperclass.getActualTypeArguments()[0];
    }
}

