/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.common;

import com.sun.enterprise.security.common.AbstractSecurityContext;
import com.sun.enterprise.security.integration.AppServSecurityContext;
import java.security.Principal;
import javax.security.auth.Subject;
import org.glassfish.security.common.PrincipalImpl;

public final class ClientSecurityContext
extends AbstractSecurityContext {
    private static final long serialVersionUID = -8079501498521266505L;
    public static final String IIOP_CLIENT_PER_THREAD_FLAG = "com.sun.appserv.iiopclient.perthreadauth";
    private static final boolean isPerThreadAuth = Boolean.getBoolean("com.sun.appserv.iiopclient.perthreadauth");
    private static ThreadLocal<ClientSecurityContext> localSecurityContext = isPerThreadAuth ? new ThreadLocal() : null;
    private static volatile ClientSecurityContext sharedSecurityContext;

    public ClientSecurityContext(String username, Subject subject) {
        this.callerPrincipal = new PrincipalImpl(username);
        this.subject = subject;
    }

    public static ClientSecurityContext getCurrent() {
        if (isPerThreadAuth) {
            return localSecurityContext.get();
        }
        return sharedSecurityContext;
    }

    public static void setCurrent(ClientSecurityContext clientSecurityContext) {
        if (isPerThreadAuth) {
            localSecurityContext.set(clientSecurityContext);
        } else {
            sharedSecurityContext = clientSecurityContext;
        }
    }

    @Override
    public Principal getCallerPrincipal() {
        return this.callerPrincipal;
    }

    @Override
    public Subject getSubject() {
        return this.subject;
    }

    public String toString() {
        return "ClientSecurityContext[ Initiator: " + this.callerPrincipal + "Subject " + this.subject + " ]";
    }

    public static boolean hasEmtpyCredentials(ClientSecurityContext clientSecurityContext) {
        if (clientSecurityContext == null) {
            return true;
        }
        Subject subject = clientSecurityContext.getSubject();
        if (subject == null) {
            return true;
        }
        return subject.getPrincipals().isEmpty();
    }

    public AppServSecurityContext newInstance(String userName, Subject subject, String realm) {
        return new ClientSecurityContext(userName, subject);
    }

    public AppServSecurityContext newInstance(String userName, Subject subject) {
        return new ClientSecurityContext(userName, subject);
    }

    public void setCurrentSecurityContext(AppServSecurityContext context) {
        if (context instanceof ClientSecurityContext) {
            ClientSecurityContext.setCurrent((ClientSecurityContext)context);
            return;
        }
        throw new IllegalArgumentException("Expected ClientSecurityContext, found " + context);
    }

    public AppServSecurityContext getCurrentSecurityContext() {
        return ClientSecurityContext.getCurrent();
    }

    public void setUnauthenticatedSecurityContext() {
        throw new UnsupportedOperationException("Not supported yet in V3.");
    }

    public void setSecurityContextWithPrincipal(Principal principal) {
        throw new UnsupportedOperationException("Not supported yet in V3.");
    }
}

