/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.services.impl.authorization;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.net.URI;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.security.auth.Subject;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.security.services.api.authorization.AuthorizationService;
import org.glassfish.security.services.api.authorization.AzAction;
import org.glassfish.security.services.api.authorization.AzAttributeResolver;
import org.glassfish.security.services.api.authorization.AzResource;
import org.glassfish.security.services.api.authorization.AzResult;
import org.glassfish.security.services.api.authorization.AzSubject;
import org.glassfish.security.services.api.common.Attributes;
import org.glassfish.security.services.api.context.SecurityContextService;
import org.glassfish.security.services.common.PrivilegedLookup;
import org.glassfish.security.services.common.Secure;
import org.glassfish.security.services.config.AuthorizationService;
import org.glassfish.security.services.config.SecurityConfiguration;
import org.glassfish.security.services.config.SecurityProvider;
import org.glassfish.security.services.impl.ServiceFactory;
import org.glassfish.security.services.impl.authorization.AzActionImpl;
import org.glassfish.security.services.impl.authorization.AzEnvironmentImpl;
import org.glassfish.security.services.impl.authorization.AzResourceImpl;
import org.glassfish.security.services.impl.authorization.AzSubjectImpl;
import org.glassfish.security.services.spi.authorization.AuthorizationProvider;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
@Secure(accessPermissionName="security/service/authorization")
public final class AuthorizationServiceImpl
implements org.glassfish.security.services.api.authorization.AuthorizationService,
PostConstruct {
    private static final Level DEBUG_LEVEL = Level.FINER;
    private static final Logger logger = Logger.getLogger("javax.enterprise.security.services", "org.glassfish.security.services.LogMessages");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AuthorizationServiceImpl.class);
    @Inject
    private volatile Domain domain;
    @Inject
    private volatile ServiceLocator serviceLocator;
    private volatile AuthorizationService atzSvCfg;
    @Inject
    private volatile SecurityContextService securityContextService;
    private volatile SecurityProvider atzPrvConfig;
    private volatile AuthorizationProvider provider;
    private static final CodeSource NULL_CODESOURCE = new CodeSource(null, (CodeSigner[])null);
    private volatile InitializationState initialized = InitializationState.NOT_INITIALIZED;
    private volatile String reasonInitFailed = localStrings.getLocalString("service.atz.never_init", "Authorization Service never initialized.");
    private final List<AzAttributeResolver> attributeResolvers = Collections.synchronizedList(new ArrayList());
    @LogMessageInfo(message="Authorization Service has successfully initialized.", level="FINE")
    private static final String ATZSVC_INITIALIZED = "SEC-SVCS-00100";
    @LogMessageInfo(message="Authorization Service initialization failed, exception {0}, message {1}", level="WARNING")
    private static final String ATZSVC_INIT_FAILED = "SEC-SVCS-00101";

    private boolean isDebug() {
        return logger.isLoggable(DEBUG_LEVEL);
    }

    @Override
    public void initialize(SecurityConfiguration securityServiceConfiguration) {
        if (InitializationState.NOT_INITIALIZED != this.initialized) {
            return;
        }
        try {
            if (!(securityServiceConfiguration instanceof AuthorizationService)) {
                throw new IllegalStateException(localStrings.getLocalString("service.atz.not_config", "The Authorization service is not configured in the domain configuration file."));
            }
            this.atzSvCfg = (AuthorizationService)securityServiceConfiguration;
            List<SecurityProvider> providersConfig = this.atzSvCfg.getSecurityProviders();
            if (providersConfig == null || (this.atzPrvConfig = providersConfig.get(0)) == null) {
                throw new IllegalStateException(localStrings.getLocalString("service.atz.no_prov_config", "No provider configured for the Authorization service in the domain configuration file."));
            }
            String providerName = this.atzPrvConfig.getName();
            if (this.isDebug()) {
                logger.log(DEBUG_LEVEL, "Attempting to get Authorization provider \"{0}\".", providerName);
            }
            this.provider = AccessController.doPrivileged(new PrivilegedLookup<AuthorizationProvider>(this.serviceLocator, AuthorizationProvider.class, providerName));
            if (this.provider == null) {
                throw new IllegalStateException(localStrings.getLocalString("service.atz.not_provider", "Authorization Provider {0} not found.", new Object[]{providerName}));
            }
            this.provider.initialize(this.atzPrvConfig);
            this.initialized = InitializationState.SUCCESS_INIT;
            this.reasonInitFailed = null;
            logger.log(Level.FINE, ATZSVC_INITIALIZED);
        }
        catch (Exception e) {
            String eMsg = e.getMessage();
            String eClass = e.getClass().getName();
            this.reasonInitFailed = localStrings.getLocalString("service.atz.init_failed", "Authorization Service initialization failed, exception {0}, message {1}", new Object[]{eClass, eMsg});
            logger.log(Level.WARNING, ATZSVC_INIT_FAILED, new Object[]{eClass, eMsg});
            throw new RuntimeException(this.reasonInitFailed, e);
        }
        finally {
            if (InitializationState.SUCCESS_INIT != this.initialized) {
                this.initialized = InitializationState.FAILED_INIT;
            }
        }
    }

    @Override
    public boolean isPermissionGranted(Subject subject, Permission permission) {
        if (null == subject) {
            throw new IllegalArgumentException(localStrings.getLocalString("service.subject_null", "The supplied Subject is null."));
        }
        if (null == permission) {
            throw new IllegalArgumentException(localStrings.getLocalString("service.permission_null", "The supplied Permission is null."));
        }
        Set<Principal> principalset = subject.getPrincipals();
        Principal[] principalAr = principalset.isEmpty() ? null : principalset.toArray(new Principal[principalset.size()]);
        ProtectionDomain pd = new ProtectionDomain(NULL_CODESOURCE, null, null, principalAr);
        Policy policy = Policy.getPolicy();
        boolean result = policy.implies(pd, permission);
        return result;
    }

    @Override
    public boolean isAuthorized(Subject subject, URI resource) {
        return this.isAuthorized(subject, resource, null);
    }

    @Override
    public boolean isAuthorized(Subject subject, URI resource, String action) {
        AzAction azAction;
        AzResource azResource;
        this.checkServiceAvailability();
        if (null == subject) {
            throw new IllegalArgumentException(localStrings.getLocalString("service.subject_null", "The supplied Subject is null."));
        }
        if (null == resource) {
            throw new IllegalArgumentException(localStrings.getLocalString("service.resource_null", "The supplied Resource is null."));
        }
        AzSubject azSubject = this.makeAzSubject(subject);
        AzResult azResult = this.getAuthorizationDecision(azSubject, azResource = this.makeAzResource(resource), azAction = this.makeAzAction(action));
        boolean result = AzResult.Status.OK.equals((Object)azResult.getStatus()) && AzResult.Decision.PERMIT.equals((Object)azResult.getDecision());
        return result;
    }

    @Override
    public AzResult getAuthorizationDecision(AzSubject subject, AzResource resource, AzAction action) {
        this.checkServiceAvailability();
        if (null == subject) {
            throw new IllegalArgumentException(localStrings.getLocalString("service.subject_null", "The supplied Subject is null."));
        }
        if (null == resource) {
            throw new IllegalArgumentException(localStrings.getLocalString("service.resource_null", "The supplied Resource is null."));
        }
        AzEnvironmentImpl env = new AzEnvironmentImpl();
        Attributes attrs = this.securityContextService.getEnvironmentAttributes();
        for (String attrName : attrs.getAttributeNames()) {
            env.addAttribute(attrName, attrs.getAttributeValue(attrName), true);
        }
        AzResult result = this.provider.getAuthorizationDecision(subject, resource, action, env, this.attributeResolvers);
        if (this.isDebug()) {
            logger.log(DEBUG_LEVEL, "Authorization Service result for {0} was {1}.", new String[]{subject.toString(), result.toString()});
        }
        return result;
    }

    @Override
    public AzSubject makeAzSubject(Subject subject) {
        AzSubjectImpl azs = new AzSubjectImpl(subject);
        return azs;
    }

    @Override
    public AzResource makeAzResource(URI resource) {
        AzResourceImpl azr = new AzResourceImpl(resource);
        return azr;
    }

    @Override
    public AzAction makeAzAction(String action) {
        AzActionImpl aza = new AzActionImpl(action);
        return aza;
    }

    @Override
    public AuthorizationService.PolicyDeploymentContext findOrCreateDeploymentContext(String appContext) {
        this.checkServiceAvailability();
        return this.provider.findOrCreateDeploymentContext(appContext);
    }

    public void postConstruct() {
        AuthorizationService atzConfiguration = ServiceFactory.getSecurityServiceConfiguration(this.domain, AuthorizationService.class);
        this.initialize(atzConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean appendAttributeResolver(AzAttributeResolver resolver) {
        if (null == resolver) {
            throw new IllegalArgumentException(localStrings.getLocalString("service.resolver_null", "The supplied Attribute Resolver is null."));
        }
        List<AzAttributeResolver> list = this.attributeResolvers;
        synchronized (list) {
            if (!this.attributeResolvers.contains(resolver)) {
                this.attributeResolvers.add(resolver);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttributeResolvers(List<AzAttributeResolver> resolverList) {
        if (null == resolverList) {
            throw new IllegalArgumentException(localStrings.getLocalString("service.resolver_null", "The supplied Attribute Resolver is null."));
        }
        List<AzAttributeResolver> list = this.attributeResolvers;
        synchronized (list) {
            this.attributeResolvers.clear();
            for (AzAttributeResolver ar : resolverList) {
                if (null == ar || this.attributeResolvers.contains(ar)) continue;
                this.attributeResolvers.add(ar);
            }
        }
    }

    @Override
    public List<AzAttributeResolver> getAttributeResolvers() {
        return new ArrayList<AzAttributeResolver>(this.attributeResolvers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAllAttributeResolvers() {
        List<AzAttributeResolver> list = this.attributeResolvers;
        synchronized (list) {
            if (this.attributeResolvers.isEmpty()) {
                return false;
            }
            this.attributeResolvers.clear();
            return true;
        }
    }

    final InitializationState getInitializationState() {
        return this.initialized;
    }

    final String getReasonInitializationFailed() {
        return this.reasonInitFailed;
    }

    final void checkServiceAvailability() {
        if (InitializationState.SUCCESS_INIT != this.getInitializationState()) {
            throw new IllegalStateException(localStrings.getLocalString("service.atz.not_avail", "The Authorization service is not available.") + this.getReasonInitializationFailed());
        }
    }

    static enum InitializationState {
        NOT_INITIALIZED,
        SUCCESS_INIT,
        FAILED_INIT;

    }
}

