/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.readers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ws.rs.Consumes;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;

@Consumes(value={"application/x-www-form-urlencoded", "application/octet-stream"})
@Provider
public class FormReader
implements MessageBodyReader<Map<String, String>> {
    private static final String DEFAULT_CHARSET = StandardCharsets.UTF_8.toString();

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Map.class.isAssignableFrom(type);
    }

    @Override
    public Map<String, String> readFrom(Class<Map<String, String>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream in) throws IOException {
        String formData = this.readAsString(in);
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(formData, "&");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int idx = token.indexOf(61);
            if (idx < 0) {
                map.put(URLDecoder.decode(token, DEFAULT_CHARSET), null);
                continue;
            }
            if (idx <= 0) continue;
            map.put(URLDecoder.decode(token.substring(0, idx), DEFAULT_CHARSET), URLDecoder.decode(token.substring(idx + 1), DEFAULT_CHARSET));
        }
        return map;
    }

    public final String readAsString(InputStream in) throws IOException {
        int l;
        InputStreamReader reader = new InputStreamReader(in);
        StringBuilder sb = new StringBuilder();
        char[] c = new char[1024];
        while ((l = reader.read(c)) != -1) {
            sb.append(c, 0, l);
        }
        return sb.toString();
    }
}

