/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.readers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonParser;
import javax.ws.rs.Consumes;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.glassfish.api.admin.ParameterMap;

@Consumes(value={"application/json"})
@Provider
public class JsonParameterMapProvider
implements MessageBodyReader<ParameterMap> {
    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(ParameterMap.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ParameterMap readFrom(Class<ParameterMap> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream in) throws IOException {
        try (JsonParser parser = Json.createParser((InputStream)in);){
            JsonObject obj;
            if (parser.hasNext()) {
                parser.next();
                obj = parser.getObject();
            } else {
                obj = JsonValue.EMPTY_JSON_OBJECT;
            }
            ParameterMap map = new ParameterMap();
            for (Map.Entry entry : obj.entrySet()) {
                JsonValue value = (JsonValue)entry.getValue();
                if (value instanceof JsonArray) {
                    JsonArray array = (JsonArray)value;
                    for (int i = 0; i < array.size(); ++i) {
                        map.add(entry.getKey(), (Object)JsonParameterMapProvider.getStringValue((JsonValue)array.get(i)));
                    }
                    continue;
                }
                map.add(entry.getKey(), (Object)JsonParameterMapProvider.getStringValue(value));
            }
            ParameterMap parameterMap = map;
            return parameterMap;
        }
        catch (Exception ex) {
            Logger.getLogger("org.glassfish.admin.rest").log(Level.SEVERE, null, ex);
            ParameterMap map = new ParameterMap();
            map.add((Object)"error", (Object)("Entity Parsing Error: " + ex.getMessage()));
            return map;
        }
    }

    private static String getStringValue(JsonValue json) {
        if (json == null) {
            return "";
        }
        if (json instanceof JsonString) {
            return ((JsonString)json).getString();
        }
        return json.toString();
    }

    public static String inputStreamAsString(InputStream stream) throws IOException {
        StringBuilder sb;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(stream));){
            sb = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        return sb.toString();
    }
}

