/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance.policy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import javax.interceptor.InvocationContext;

public final class StaticAnalysisContext
implements InvocationContext {
    private final Class<?> targetClass;
    private final Method annotated;
    private Object[] arguments;
    private transient Object target;

    public StaticAnalysisContext(Class<?> targetClass, Method annotated) {
        this(null, targetClass, annotated, new Object[0]);
    }

    public StaticAnalysisContext(Object target, Method annotated, Object ... arguments) {
        this(target, target.getClass(), annotated, arguments);
    }

    private StaticAnalysisContext(Object target, Class<?> targetClass, Method annotated, Object ... arguments) {
        this.target = target;
        this.targetClass = targetClass;
        this.annotated = annotated;
        this.arguments = arguments;
    }

    public Object getTarget() {
        if (this.target == null) {
            try {
                this.target = this.targetClass.newInstance();
            }
            catch (Exception e) {
                this.target = new UnsupportedOperationException();
            }
        }
        if (this.target instanceof UnsupportedOperationException) {
            throw (UnsupportedOperationException)this.target;
        }
        return this.target;
    }

    public Object getTimer() {
        return null;
    }

    public Method getMethod() {
        return this.annotated;
    }

    public Constructor<?> getConstructor() {
        return null;
    }

    public Object[] getParameters() {
        return this.arguments;
    }

    public void setParameters(Object[] params) {
        this.arguments = params;
    }

    public Map<String, Object> getContextData() {
        return Collections.emptyMap();
    }

    public Object proceed() throws Exception {
        if (this.arguments.length != this.annotated.getParameterCount()) {
            throw new UnsupportedOperationException();
        }
        try {
            return this.annotated.invoke(this.getTarget(), this.arguments);
        }
        catch (InvocationTargetException ex) {
            throw (Exception)ex.getTargetException();
        }
    }

    public String toString() {
        return this.target.getClass().getSimpleName() + "." + this.annotated.getName() + "@" + System.identityHashCode(this.target);
    }
}

