/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance.service;

import fish.payara.microprofile.faulttolerance.FaultToleranceConfig;
import fish.payara.microprofile.faulttolerance.service.FaultToleranceUtils;
import fish.payara.microprofile.faulttolerance.service.Stereotypes;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;

final class BindableFaultToleranceConfig
implements FaultToleranceConfig {
    static final String NON_FALLBACK_ENABLED_PROPERTY = "MP_Fault_Tolerance_NonFallback_Enabled";
    static final String METRICS_ENABLED_PROPERTY = "MP_Fault_Tolerance_Metrics_Enabled";
    private static final Logger logger = Logger.getLogger(BindableFaultToleranceConfig.class.getName());
    private final AtomicReference<Boolean> nonFallbackEnabled;
    private final AtomicReference<Boolean> metricsEnabled;
    private final AtomicReference<Class<? extends Annotation>[]> alternativeAsynchronousAnnotations;
    private final Config config;
    private final Stereotypes sterotypes;
    private final InvocationContext context;

    public BindableFaultToleranceConfig(Stereotypes sterotypes) {
        this(BindableFaultToleranceConfig.resolveConfig(), sterotypes);
    }

    public BindableFaultToleranceConfig(Config config, Stereotypes sterotypes) {
        this(null, config, sterotypes, new AtomicReference<Boolean>(), new AtomicReference<Boolean>(), new AtomicReference<Class<? extends Annotation>[]>());
    }

    private BindableFaultToleranceConfig(InvocationContext context, Config config, Stereotypes sterotypes, AtomicReference<Boolean> nonFallbackEnabled, AtomicReference<Boolean> metricsEnabled, AtomicReference<Class<? extends Annotation>[]> alternativeAsynchronousAnnotations) {
        this.context = context;
        this.sterotypes = sterotypes;
        this.config = config;
        this.nonFallbackEnabled = nonFallbackEnabled;
        this.metricsEnabled = metricsEnabled;
        this.alternativeAsynchronousAnnotations = alternativeAsynchronousAnnotations;
    }

    private static Config resolveConfig() {
        logger.log(Level.FINE, "Resolving Fault Tolerance Config from Provider.");
        try {
            return ConfigProvider.getConfig();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "No Config could be found, using annotation values only.", ex);
            return null;
        }
    }

    public FaultToleranceConfig bindTo(InvocationContext context) {
        return this.config == null ? FaultToleranceConfig.asAnnotated(context.getTarget().getClass(), context.getMethod()) : new BindableFaultToleranceConfig(context, this.config, this.sterotypes, this.nonFallbackEnabled, this.metricsEnabled, this.alternativeAsynchronousAnnotations);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return FaultToleranceUtils.getAnnotation(this.sterotypes, annotationType, this.context);
    }

    @Override
    public boolean isNonFallbackEnabled() {
        if (this.nonFallbackEnabled.get() == null) {
            this.nonFallbackEnabled.compareAndSet(null, this.config.getOptionalValue(NON_FALLBACK_ENABLED_PROPERTY, Boolean.class).orElse(true));
        }
        return this.nonFallbackEnabled.get();
    }

    @Override
    public boolean isMetricsEnabled() {
        if (this.metricsEnabled.get() == null) {
            this.metricsEnabled.compareAndSet(null, this.config.getOptionalValue(METRICS_ENABLED_PROPERTY, Boolean.class).orElse(true));
        }
        return this.metricsEnabled.get();
    }

    @Override
    public boolean isEnabled(Class<? extends Annotation> annotationType) {
        return FaultToleranceUtils.getEnabledOverrideValue(this.config, annotationType, this.context, annotationType == Fallback.class || this.isNonFallbackEnabled());
    }

    @Override
    public boolean isAlternativeAsynchronousAnnoationPresent() {
        if (this.alternativeAsynchronousAnnotations.get() == null) {
            this.alternativeAsynchronousAnnotations.compareAndSet(null, FaultToleranceUtils.toClassArray(this.config.getOptionalValue("MP_Fault_Tolerance_Alternative_Asynchronous_Annotations", String.class).orElse(null), "MP_Fault_Tolerance_Alternative_Asynchronous_Annotations", NO_ALTERNATIVE_ANNOTATIONS));
        }
        for (Class<? extends Annotation> alterantiveAnnotation : this.alternativeAsynchronousAnnotations.get()) {
            if (!this.isAnnotationPresent(alterantiveAnnotation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int maxRetries(Retry annotation) {
        return this.intValue(Retry.class, "maxRetries", annotation.maxRetries());
    }

    @Override
    public long delay(Retry annotation) {
        return this.longValue(Retry.class, "delay", annotation.delay());
    }

    @Override
    public ChronoUnit delayUnit(Retry annotation) {
        return this.chronoUnitValue(Retry.class, "delayUnit", annotation.delayUnit());
    }

    @Override
    public long maxDuration(Retry annotation) {
        return this.longValue(Retry.class, "maxDuration", annotation.maxDuration());
    }

    @Override
    public ChronoUnit durationUnit(Retry annotation) {
        return this.chronoUnitValue(Retry.class, "durationUnit", annotation.durationUnit());
    }

    @Override
    public long jitter(Retry annotation) {
        return this.longValue(Retry.class, "jitter", annotation.jitter());
    }

    @Override
    public ChronoUnit jitterDelayUnit(Retry annotation) {
        return this.chronoUnitValue(Retry.class, "jitterDelayUnit", annotation.jitterDelayUnit());
    }

    @Override
    public Class<? extends Throwable>[] retryOn(Retry annotation) {
        return this.getClassArrayValue(Retry.class, "retryOn", annotation.retryOn());
    }

    @Override
    public Class<? extends Throwable>[] abortOn(Retry annotation) {
        return this.getClassArrayValue(Retry.class, "abortOn", annotation.abortOn());
    }

    @Override
    public Class<? extends Throwable>[] failOn(CircuitBreaker annotation) {
        return this.getClassArrayValue(CircuitBreaker.class, "failOn", annotation.failOn());
    }

    @Override
    public Class<? extends Throwable>[] skipOn(CircuitBreaker annotation) {
        return this.getClassArrayValue(CircuitBreaker.class, "skipOn", annotation.skipOn());
    }

    @Override
    public long delay(CircuitBreaker annotation) {
        return this.longValue(CircuitBreaker.class, "delay", annotation.delay());
    }

    @Override
    public ChronoUnit delayUnit(CircuitBreaker annotation) {
        return this.chronoUnitValue(CircuitBreaker.class, "delayUnit", annotation.delayUnit());
    }

    @Override
    public int requestVolumeThreshold(CircuitBreaker annotation) {
        return this.intValue(CircuitBreaker.class, "requestVolumeThreshold", annotation.requestVolumeThreshold());
    }

    @Override
    public double failureRatio(CircuitBreaker annotation) {
        return this.value(CircuitBreaker.class, "failureRatio", Double.class, annotation.failureRatio());
    }

    @Override
    public int successThreshold(CircuitBreaker annotation) {
        return this.intValue(CircuitBreaker.class, "successThreshold", annotation.successThreshold());
    }

    @Override
    public int value(Bulkhead annotation) {
        return this.intValue(Bulkhead.class, "value", annotation.value());
    }

    @Override
    public int waitingTaskQueue(Bulkhead annotation) {
        return this.intValue(Bulkhead.class, "waitingTaskQueue", annotation.waitingTaskQueue());
    }

    @Override
    public long value(Timeout annotation) {
        return this.longValue(Timeout.class, "value", annotation.value());
    }

    @Override
    public ChronoUnit unit(Timeout annotation) {
        return this.chronoUnitValue(Timeout.class, "unit", annotation.unit());
    }

    @Override
    public Class<? extends FallbackHandler<?>> value(Fallback annotation) {
        String className = FaultToleranceUtils.getOverrideValue(this.config, Fallback.class, "value", this.context, String.class, null);
        if (className == null) {
            return annotation.value();
        }
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return annotation.value();
        }
    }

    @Override
    public String fallbackMethod(Fallback annotation) {
        return this.value(Fallback.class, "fallbackMethod", String.class, annotation.fallbackMethod());
    }

    @Override
    public Class<? extends Throwable>[] applyOn(Fallback annotation) {
        return this.getClassArrayValue(Fallback.class, "applyOn", annotation.applyOn());
    }

    @Override
    public Class<? extends Throwable>[] skipOn(Fallback annotation) {
        return this.getClassArrayValue(Fallback.class, "skipOn", annotation.skipOn());
    }

    private long longValue(Class<? extends Annotation> annotationType, String attribute, long annotationValue) {
        return this.value(annotationType, attribute, Long.class, annotationValue);
    }

    private int intValue(Class<? extends Annotation> annotationType, String attribute, int annotationValue) {
        return this.value(annotationType, attribute, Integer.class, annotationValue);
    }

    private ChronoUnit chronoUnitValue(Class<? extends Annotation> annotationType, String attribute, ChronoUnit annotationValue) {
        return this.value(annotationType, attribute, ChronoUnit.class, annotationValue);
    }

    private <T> T value(Class<? extends Annotation> annotationType, String attribute, Class<T> valueType, T annotationValue) {
        return FaultToleranceUtils.getOverrideValue(this.config, annotationType, attribute, this.context, valueType, annotationValue);
    }

    private Class<? extends Throwable>[] getClassArrayValue(Class<? extends Annotation> annotationType, String attributeName, Class<? extends Throwable>[] annotationValue) {
        String classNames = FaultToleranceUtils.getOverrideValue(this.config, annotationType, attributeName, this.context, String.class, null);
        return FaultToleranceUtils.toClassArray(classNames, attributeName, annotationValue);
    }
}

